/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: palControl.c,v 1.2 1993/05/05 18:52:47 gbourhis Exp $";
#endif


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/MenuShell.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/ToggleBG.h>

#include "view.h"


extern void CBMakeCurrentPalette();


#ifndef MALLOC
#define MALLOC  malloc
#define FREE    free
#endif


struct pal_rec {
	View *V;
	Widget menu;
	struct pal_rec *next;
};

static struct pal_rec *PalList = NULL;


void
AddNewPal(p)
	Palette *p;
{
	struct pal_rec *pptr;
	struct pal_view *pv;
	Widget b;
	Arg argList[10];
	Cardinal i;
	XmString label;
	char tlab[256];

	for (pptr = PalList; pptr != NULL; pptr = pptr->next)
	{
		pv = (struct pal_view *)MALLOC(sizeof(struct pal_view));
		if (pv != NULL)
		{
			pv->V = pptr->V;
			pv->p = p;
		}

		sprintf(tlab, "%s", p->name);
		i = 0;
		label = XmStringCreateSimple(tlab);
		XtSetArg(argList[i], XmNlabelString, label); i++;
		XtSetArg(argList[i], XmNuserData, p); i++;
		b = XmCreateToggleButtonGadget(pptr->menu, "menuButton",
			argList, i);
		XtAddCallback(b, XmNvalueChangedCallback, CBMakeCurrentPalette,
			(caddr_t)pv);
		XtManageChild(b);

	}
}


Widget
RegisterPalMenu(V, menuBar)
	View *V;
	Widget menuBar;
{
	Widget b, pulldown;
	Arg argList[10];
	Cardinal i;
	XmString label;
	char tlab[256];
	Palette *p;
	struct pal_rec *pptr;
	struct pal_view *pv;

	/*
	 * Palettes menu
	 */
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	XtSetArg(argList[i], XmNradioBehavior, True); i++;
	pulldown = XmCreatePulldownMenu(menuBar, "pulldown", argList, i);

	pptr = (struct pal_rec *)MALLOC(sizeof(struct pal_rec));
	if (pptr != NULL)
	{
		pptr->V = V;
		pptr->menu = pulldown;
		pptr->next = PalList;
		PalList = pptr;
	}

	for (p = PaletteFirst(); p; p = PaletteNext())
	{
		pv = (struct pal_view *)MALLOC(sizeof(struct pal_view));
		if (pv != NULL)
		{
			pv->V = V;
			pv->p = p;
		}

		sprintf(tlab, "%s", p->name);
		i = 0;
		label = XmStringCreateSimple(tlab);
		XtSetArg(argList[i], XmNlabelString, label); i++;
		XtSetArg(argList[i], XmNuserData, p); i++;
		b = XmCreateToggleButtonGadget(pulldown, "menuButton",
					       argList, i);
		XtAddCallback(b, XmNvalueChangedCallback, CBMakeCurrentPalette,
			(caddr_t)pv);
		XtManageChild(b);

	}
	return(pulldown);
}

