#define	FALSE	0		/* This is the naked Truth */
#define	TRUE	1		/* and this is the Light */

#define	EMPTY		0	/* Tag is empty */
#define	NONEMPTY	1	/* There is a closing tag */

#define	NOVALUE	((char *)-1)

/* Global structures from html.c */

typedef
struct attrib {
	struct attrib	*next;
	int		type;
	char		*value;
	} attrib;

typedef
struct element {
	struct element	*next;
	struct element	*parent;
	int		type;
	char		**attrib;
	struct element	*content;
	int		open;
	} element;

typedef
struct elements_list {
	char	*name;
	size_t	attribs;
	char	**attrib;
	int	bracket;	/* TRUE if this tag isn't empty */
	int	brk;		/* TRUE if this tag forces line breaks */
	} elements_list;

typedef
struct url {
	char	*scheme;
	char	*host;
	int	port;
	char	*path;
	char	*anchor;
	} url;

/* Global variables from html.c */

extern elements_list elements[];

/* Functions from html.c */

extern int stricmp();
extern char *strndup();
extern int element_type();
extern int attrib_type();
extern element *new_element();
extern void parsetext();
extern void parseitem();
extern element *file2parse();
extern element *mem2parse();
extern int defport();
extern void txt2url();
extern void url2txt();
extern void url2fname();
extern void url2rel();
extern void freeparse();
extern void freeurl();

#ifdef PROXY
#define NETCLOSE ipcclose
#else
#define NETCLOSE close
#endif
