/*
 * Lynx.c - Hypertext navagation system
 *
 * SYNOPSIS:
 *	lynx [args] [path]
 *
 * EXPLANATION
 *      This is a general hypertext browser, with some fancy features.
 *      This program uses a superset of the hytelnet file format which
 *      is a derivative of HYPERRES, so it should be 
 *      possible to plug-and-play other databases as well.
 *     
 *      The database consists of many more-or-less plain text files,
 *      on any file system.  Any text in angle brackets (eg <HELP>)
 *      is a link, it is also possible to change the link delimiter
 *      (eg %HELP%).  Selecting it moves you to the named file. 
 *	Files can reside on remote systems and can be accessed through
 * 	internet gopher servers.  A gopher client is built into lynx. 
 *
 *      The program notices telnet commands embedded in the text files,
 *      and will execute them for the user, if desired.
 *
 * NOTES
 *	Big thanks to 
 *      Earl Fogel, Computing Services, University of Saskatchewan
 *	fogel@sask.usask.ca from who's code this whole thing started from
 *
 *	Thanks to Michael A. Rowley (mcrowley@mtholyoke.edu) for some
 *      of the interrupt handling code.
 *
 *	Thanks to Kathryn Huxtable (huxtable@kuhub.cc.ukans.edu) for the
 *	VMS termio routines, and various other VMS oddities.
 *
 *      Thanks to the Gopher folks, whos code helped a great deal
 *
 *      And thanks to anyone else who's code examples I might have used
 *
 * BUGS
 *    - There are no bugs just features
 *
 * AUTHORS
 *	Lou Montulli, University of Kansas, Computing Services
 *	Montulli@KUHUB.cc.ukans.edu
 *
 *	Michael Grobe, University of Kansas, Computing Services
 *	Grobe@KUHUB.cc.ukans.edu
 *
 *	Charles Rezac, University of Kansas, Computing Services
 *	Rezac@KUHUB.cc.ukans.edu
 *
 * CHANGE LOG
 *
 * NOTICE
 *	Permissions to copy, use and redistribute this program are hereby
 *	granted provided the Copyright notice and this comment remain
 *	intact.
 *
 *		    (c) Copyright 1992  Lou Montulli
 */
/*
 * Things you must change
 */
#   define STARTDIR "/home/dug-docs"

/* STARTFILE is the default file if none is specified on the command line */
#   define STARTFILE "cwis.screen"


/* the Left target delimiter must be 2 charactors with quotes */
#define LEFT_TARGET_DELIMITER "[*"
/* same for the right one as the left */
#define RIGHT_TARGET_DELIMITER "*]"
/* default link delimiter, '\0' means no default */
#define DEFAULT_LINK_DELIMITER '\0'   
#define DEFAULT_END_LINK_DELIMITER '>'   /* default link delimiter */
#define DEFAULT_TOKEN_DELIMITER ':'  /* token delimiter */
#define MAXBASE 100       /* max length of base directory */
#define MAXHIGHLIGHT 160 /* max length of highlighted text */
#define MAXTARGET 130    /* max length of target string */
#define LINESIZE 400    /* max length of line to read from file*/
#define MAXFNAME 300	/* max filename length DDD/FILENAME.EXT */
#define MAXCOMMAND MAXFNAME /* max lengh of command should be the same */
#define MAXHIST  90	/* number of links we remember in history */
#define MAXLINKS 106	/* max links on one screen */
#define MAXFORMLINKS 100 /* max number of form links */
#define HELP "Commands: Use arrow keys to move, '?' for help, 'q' to quit, '<-' to go back"
#define LINEWRAP 20   /* maximum size of word to linewrap */
