//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
//		03-29-94	Modified to now work with searchable indexes.
#include"turlview.h"
#include"trace.h"

extern "C"	{
#include"htaccess.h"
}; //	extern "C"

Boolean TURLView::loadURL(const char *cp_URL, const char *cp_Index)	{
//	Purpose:	Load a URL into a TURLView object.
//	Arguments:	cp_URL	The url to load.
//	Return Value:	Boolean	True	URL loaded.
//				False	URL not loaded.
//	Remarks/Portability/Dependencies/Restrictions:
//		cp_URL should never be passed in as a NULL or even empty
//			string.
//		All code calling this function that requires some type of
//			dialog to query for a URL must provide that code
//			before calling this function, or just provide a name.
//		The global variable TURLV_current is vital to proper
//			functionality with the WWW library.
//	Revision History:
//		12-30-93	created
//		03-30-94	Will notify user in this function if unable
//				to load a particular document.

	auto BOOL B_HTLAResult = TRUE;

	//	Reset the limits of the view.
	delta.y = delta.x = limit.y = limit.x = 0;

	//	This will load the url.
	//	Check to see if we should perform a search or just load.
	if(cp_Index == NULL)	{
		B_HTLAResult = ::HTLoadAbsolute(cp_URL);
	}
	else	{
		//	HTSearch must be used since we can have a different
		//	index server than the url states.
		B_HTLAResult = ::HTSearch(cp_Index, (HTParentAnchor *)
			HTAnchor_findAddress(cp_URL));
	}

	//	If the result is not good, then put a message out to the
	//	user indicating such.
	if(B_HTLAResult != TRUE)	{
		doslynxmessage("Unable to load " << cp_URL);
	}
#ifndef RELEASE
	trace("loadURL returning " << (B_HTLAResult == TRUE ? "true." :
		"false."));
#endif // RELEASE

	return(B_HTLAResult == TRUE ? True : False);
}
