//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide a view for a URL.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		03-24-94	created
#define Uses_TFileDialog
#define Uses_TProgram
#define Uses_TDeskTop
#include"turlview.h"
#include"trace.h"

void TURLView::save(const char *cp_filename, const Boolean B_appendff)	{
//	Purpose:	Save the currently viewed document as a text file.
//	Arguments:	cp_filename	The name of the file to save the
//					view into.
//			B_appendff	Wether or not we should append a
//					form feed onto the end of the file.
//					Used in conjunction with printing.
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		If cp_filename is NULL or is "" then the user will be promted
//		to enter the filename in which to save the view.
//	Revision History:
//		03-24-94	created

#ifndef RELEASE
	trace("saving rendered " << cp_filename);
#endif // RELEASE
	auto char *cp_savename = (char *)cp_filename;

	//	first, check to see if we need to prompt the user for the
	//	file name.
	if(cp_savename == NULL || *cp_savename == '\0')	{
		//	Create a file dialog box.
		TFileDialog *TFD = new TFileDialog("*.*", "Save Rendering",
			"Save as", fdOKButton, usi_SaveHist);

		//	If the dialog was allocated
		if(TFD == NULL)	{
			return;
		}

		//	Execute the dialog.
		unsigned short int usi_retval = TProgram::deskTop->
			execView(TFD);

		//	If the user didn't cancel.
		if(usi_retval == cmCancel)	{
			destroy(TFD);
			return;
		}

		//	Small buffer to hold file name
		auto char ca_buffer[usi_TILURLSize];

		//	Get the information from the Dialog
		TFD->getFileName(ca_buffer);

		//	Done with the dialog.
		destroy(TFD);

		if(NULL == (cp_savename = newStr(ca_buffer)))	{
			return;
		}
	}

	//	Remove whitespace from the front of the line.
	if(isspace(*cp_savename))	{
		auto char *cp_temp = cp_savename + 1;

		while(isspace(*cp_temp))	{
			cp_temp++;
		}

		auto int i_traverse;
		for(i_traverse = 0; *cp_temp != '\0'; i_traverse++)
		{
			*(cp_savename + i_traverse) = *cp_temp++;
		}

		*(cp_savename + i_traverse) = '\0';
	}

	//	If there is a filename left.
	if(*cp_savename == '\0')	{
		return;
	}



	//	Open the file for writing text.
	auto fstream *fsp_save = new fstream(cp_savename, ios::out |
		ios::trunc);

	//	If there was failure, report so.
	if(fsp_save == NULL)	{
		doslynxmessage("Unable to save rendereing to " <<
			cp_savename);
	}
	else	{
		//	We can save.
		//	Seek the rendered image file to the beginning.
		//	Assume it is already open.
		fsp_temp->seekg(0L);

		auto Line L_save;

		//	While we're not to the end of the file....
		while(fsp_temp->eof() == 0)	{

			//	Read the line information.
			fsp_temp->read((char *)(&L_save), sizeof(Line));
			if(fsp_temp->bad() != 0 || fsp_temp->eof() != 0)
			{
				if(fsp_temp->bad() != 0)	{
					doslynxmessage("Error in reading "
						"rendered image " <<
						TTNp_temp->getName());
				}
				break;
			}

			//	While we are indenting.
			while(L_save.ssi_indent && L_save.ssi_length != 0)
			{
				//	Optimize for tabs.
				if(L_save.ssi_indent >= 8)	{
					fsp_save->put('\t');
					L_save.ssi_indent -= 8;
				}
				else	{
					fsp_save->put(' ');
					L_save.ssi_indent--;
				}

				if(fsp_save->bad() != 0)	{
					doslynxmessage("Error in saving "
					"rendered image " << cp_savename);
					break;
				}
			}

			//	Continue if all OK.
			if(fsp_save->bad() != 0)	{
				break;
			}

			//	While there is length still in the line.
			while(L_save.ssi_length--)	{
				//	Output the characters.
				fsp_save->put(fsp_temp->get());

				//	Check errors.
				if(fsp_save->bad() != 0)	{
					doslynxmessage("Error in saving "
					"rendered image " << cp_savename);
					break;
				}
				else if(fsp_temp->bad() != 0 || fsp_temp->
					eof() != 0)	{
					if(fsp_temp->bad() != 0)	{
						doslynxmessage("Error in "
							"reading rendered "
							"image " <<
							TTNp_temp->getName());
					}
					break;
				}
			}

			//	Continue if all OK.
			if(fsp_save->bad() != 0 || fsp_temp->bad() != 0 ||
				fsp_temp->eof() != 0)
			{
				break;
			}

			//	Output the end of a line.
			fsp_save->put('\n');
			if(fsp_save->bad() != 0)	{
				doslynxmessage("Error in saving "
				"rendered image " << cp_savename);
				break;
			}
		}

		//	If we should append a form feed, do so now.
		if(B_appendff == True && fsp_save->bad() == 0)	{
			fsp_save->put('\f');
			if(fsp_save->bad() != 0)	{
				doslynxmessage("Error in saving "
				"rendered image " << cp_savename);
			}
		}

		//	Close the saved file.
		fsp_save->close();
		delete(fsp_save);

		//	Reset the rendered image file to not EOF.
		fsp_temp->clear();
	}


	//	If we have allocated the space for the file name, then we
	//	need to free it.
	if(cp_savename != cp_filename)	{
		delete(cp_savename);
	}
}