//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		none
//	Include File:	memstrat.h
//	Purpose:	Set or get the msdos memory allocation strategy.
//	Remarks/Portability/Dependencies/Restrictions:
//		Based on an MS-DOS 3.0 DOS interrupt function.
//		Can only be used with DOS 3.0 or higher.
//	Revision History:
//		04-20-94	created
#include"memstrat.h"
#include<dos.h>

extern StrategyType getMemoryAllocationStrategy()	{
//	Purpose:	Return the type of strategy that DOS is currently
//			using to allocate memory.
//	Arguments:	void
//	Return Value:	StrategyType	firstFit	This is the default
//							DOS allocation
//							strategy, finding the
//							first available peice
//							of memory that will
//							hold the size
//							requested.
//					bestFit		This finds the heap
//							chunk closest in size
//							to the requested
//							amount.
//					lastFit		Like firstFit, but
//							starts at the end of
//							the heap.
//	Remarks/Portability/Dependencies/Restrictions:
//		DOS 3.0 or greater.
//	Revision History:
//		04-20-94	created

	auto REGS R_in, R_out;

	//	First, clear out our two REGS.
	for(signed short int ssi_counter = 0; ssi_counter < sizeof(REGS);
		ssi_counter++)	{
		*((char *)(&R_in) + ssi_counter) = 0;
		*((char *)(&R_out) + ssi_counter) = 0;
	}

	//	Set up R_in for the call.
	R_in.h.ah = (unsigned char)0x58;
	R_in.h.al = (unsigned char)0x0;

	//	Return the AX register which values directly correlate to
	//	the enumeration of StrategyType.
	return((StrategyType)int86(0x21, &R_in, &R_out));
}

extern void setMemoryAllocationStrategy(const StrategyType ST_fit)	{
//	Purpose:	Set the DOS memory allocation strategy.
//	Arguments:	ST_fit	The type of strategy to have DOS begin
//				employing.
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Works only with DOS 3.0 or higher.
//	Revision History:
//		04-20-94	created

	auto REGS R_in, R_out;

	//	First, clear out our two REGS.
	for(signed short int ssi_counter = 0; ssi_counter < sizeof(REGS);
		ssi_counter++)	{
		*((char *)(&R_in) + ssi_counter) = 0;
		*((char *)(&R_out) + ssi_counter) = 0;
	}

	//	Set up R_in for the call.
	R_in.h.ah = (unsigned char)0x58;
	R_in.h.al = (unsigned char)0x1;
	R_in.x.bx = (unsigned short int)ST_fit;

	//	Invoke the DOS interrupt to perform the setting of the scheme.
	int86(0x21, &R_in, &R_out);
}