#include <stdio.h>
#include "defines.h"
#include "externs.h"


/* ------------------------------------------------------------
		parse_query()
   parses input line and sets up query 
   for call to search engine. A query is currently 
   of the form:
	<term> [';' <term>] [':' <constraints>]

   We use a finite state machine and the "parse_term()"
   routine to make it happen. Note that punctuation will
   probably change.

   ------------------------------------------------------------ */

parse_query() {
struct term_type * tptr;
int tresult;

	logit ("parse_query:", "into parser");


/* program needs only a single query structure for now so        */
/* it is already declared. Use ptr to simplify thing if we       */
/* need to pass them around later. First, fill in some defaults. */

	qptr			= &query;
	qptr->termptr		= NULL;
	qptr->command_type	= SEARCH_COMMAND;
	qptr->constraints[0]	= '\0';
	strcpy (qptr->version, "0.1beta");

/* fetch first term. */
	if ((tresult = parse_term()) == NO_TERM) {
	    logit ("parse_query:", "NO TERM");
	    return (NO_QUERY);
	}
	if (tresult == BOGUS_TERM) {
	    logit ("parse_query:", "BOGUS QUERY");
	    return (BOGUS_QUERY);
	}

/* else it's a valid term, so attach it to query structure */
	termptr->nextptr = qptr->termptr;
	qptr->termptr = termptr;

/* now check for system command. If so, we're done... */
	if ((qptr->command_type = termptr->command_type)  == SYSTEM_COMMAND) {
	   logit ("parse_query:", "found system command");
	   return (VALID_QUERY);
	}

/* otherwise, we've the first term of a search  */
/* command, so loop looking for more...         */

	logit ("parse_query", "found search command, keep processing");

	while (1) {
	   if ((tresult = parse_term()) == NO_TERM) {
	      logit ("parse_query:", "DONE");
	      return (VALID_QUERY);
	   }
	   if (tresult == BOGUS_TERM) {
	      logit ("parse_query:", "BOGUS QUERY");
	      return (BOGUS_QUERY);
	   }
/* it's a valid term, so attach it to query structure */
	   termptr->nextptr = qptr->termptr;
	   qptr->termptr = termptr;
	}

/* at this point, we have a valid query filled in
   so we can do the search.   */

}
