#include <stdio.h>
#include <string.h>
#include "wutils.h"
#include "wquery.h"
#include "wreply.h"

/*  
 *  We don't do as much error checking as one should.
 */  

#define ENGLISH 0
#define FRANCAIS 1
#define NOLIM -1

typedef struct {
  int maxhits;
  int lang;
} GlblCons;

typedef struct
{
  const char *attr_name;
  const char *attr_val;
} Reply;


extern const char *getFT proto_((Val ft));
extern const char *tail proto_((const char *path));
extern const Reply *do_search proto_((const WItem *w, const GlblCons *gcons));
extern const char *tail proto_((const char *path));
  
const char *prog;


int main(ac, av)
  int ac;
  char **av;
{
  static GlblCons gcons = { NOLIM, ENGLISH };
  Reply *r;
  WItem *c;
  WItem *l;
  WItem *lst;
  char qstr[128];
  int hits;

  prog = tail(av[0]);
  fclose(stderr);
  (void)freopen("/tmp/werrs", "w", stderr);

  /*  
   *  Assume we are started by inetd.
   */  

  wGetLine(stdin, qstr, sizeof qstr);
  if ( ! (lst = wQueryParse(qstr)))
  {
    fprintf(stderr, "%s: wQueryParse() failed.\n", prog);
    exit(1);
  }

#if 1
  fprintf(stderr, "parsed string into:\n\n");
  wPrintList(stderr, lst);
  fprintf(stderr, "\n\n");
  wSetDebug(3);
#endif
  
  /*  
   *  Check the global constraints we care/know about.
   */
  c = lst->cons;
  while (c)
  {
    if (strcmp(c->lhs, "language") == 0)
    {
      if (strcmp(c->rhs, "francais") == 0) gcons.lang = FRANCAIS;
      /* else it's either english, or one we don't know about */
    }
    else if (strcmp(c->lhs, "maxhits") == 0)
    {
      gcons.maxhits = atoi(c->rhs);
    }
    /* else it's a constraint we don't know about */
    c = c->next;
  }

  /*  
   *  Process the search terms.
   */  

  r = do_search(lst->next, &gcons);
  wFreeList(lst);               /* junk the query */

    
  /*  
   *  Create the reply header item.
   */  
  lst = l = wNewWItem();
  l->type = T_REPLY;
  l->format = F_HEAD;
  
  if ( ! r)
  {
    lst->lhs = strdup("full");
    lst->rhs = strdup("0");
  }
  else
  {
    lst->lhs = strdup("full");
    lst->rhs = strdup("-1"); /* lazy: make wReply() count them */

    while (r->attr_name)
    {
      WItem *t;

      t = wNewWItem();
      if ( ! *r->attr_name)
      {
        /*  
         *  This creates the required item corresponding to the "format
         *  specifier line" for the "full" response type of the WHOIS++
         *  protocol.
         */  
        t->type = T_REPLY;
        t->format = R_FULL_FMT; /* special case of `format' */
        t->lhs = strdup("user");
        t->rhs = strdup("some-handle");

        hits++;
      }
      else
      {
        t->type = T_REPLY;
        t->format = R_FULL;
        t->lhs = strdup(r->attr_name);
        t->rhs = strdup(r->attr_val);
      }

      /*  
       *  Append the new element to the reply list.
       */
      l->next = t;
      l = t;

      r++;
    }
  }

#if 1
  fprintf(stderr, "constructed list is:\n\n");
  wPrintList(stderr, lst);
#endif

  if ( ! wReply(lst, stdout))
  {
    fprintf(stderr, "%s: error replying to query.\n", prog);
    wFreeList(lst);
    exit(1);
  }

  wFreeList(lst);
  exit(0);
}
  
  
/*  
 *  In this case we'll just send back a hardwired reply.  (It will be a FULL
 *  reply, as that is all the library can deal with at the moment.)
 */  
    
const Reply *do_search(w, gcons)
  const WItem *w;
  const GlblCons *gcons;
{
  static const Reply reply[] =
  {
    { "", "" },
    { "First-Name", "Dwayne" },
    { "Last-Name", "Esper" },
    { "Email", "dwayne@maniac.edu" },

    { "", "" },
    { "First-Name", "Bert" },
    { "Last-Name", "Gordon" },
    { "Email", "big@fifty-foot.com" },

    { "", "" },
    { "First-Name", "Ed" },
    { "Last-Name", "Wood" },
    { "Email", "ewood@criswell.us" },

    { "", "" },
    { "First-Name", "Ray" },
    { "Last-Name", "Steckler" },
    { "Email", "rds@pfink.com" },

    { (const char *)0, (const char *)0 }
  };

  fprintf(stderr, "%s: language is %s, maxhits = %d.\n", prog,
          gcons->lang == FRANCAIS ? "francais" : "english", gcons->maxhits);
    
  while (w)
  {
    /*  
     *  Here we could check the local constraints for this term.  (That is if
     *  this weren't just an example program. :-)
     */    

    /*  
     *  Just print the term instead of doing anything useful.
     */    
    fprintf(stderr, "%s: Type: %s, Format: %s, LHS = %s, RHS = %s.\n", prog,
            getFT(w->type), getFT(w->format), w->lhs, w->rhs);
    w = w->next;
  }

  return reply;
}


typedef struct
{
  Val v;
  const char *s;
} VS;

/*  
 *  Return a string corresponding to the format, or type, passed.
 */  
const char *getFT(ft)
  Val ft;
{
  VS *p;
  static VS vs[] =
  {
    /* WItem Query Formats */

    { F_ALL, "all" },
    { F_ATTR, "attr" },
    { F_VALUE, "value" },
    { F_TEMPL, "template" },
    { F_HEAD, "head" },
    { F_HAND, "handle" },
    { F_ATTR_VAL, "attribute-value" },

    /* WItem Response Formats */

    { R_ABRIDG, "abridged" },
    { R_FULL, "full" },
    { R_FULL_FMT, "full_format" },
    { R_HANDLE, "handle" },
    { R_MIME, "mime" },
    { R_POINT, "point" },
    { R_SUM, "summary" },

    /* WHOIS++ Item Types */

    { T_CONS, "constraint" },
    { T_SEARCH, "search" },
    { T_SYSTEM, "system" },
    { T_REPLY, "reply" },

    { NO_VAL, "no_value" },
  };

  p = vs;
  while (p->v != NO_VAL)
  {
    if (ft == p->v) break;
    p++;
  }
  return p->s;
}


const char *tail(path)
  const char *path;
{
  const char *p = strrchr(path, '/');
  return p ? p+1 : path;
}
