#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees, and by CSNET.  No warranties of
 * any kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed without prior consent of CSNET.
 * You may direct questions to nameserv@uiuc.edu
 */

/*
 * these thing keep ld happy
 */
int	InputType;
int	Daemon;
FILE	*Input, *Output;
char	*DBState;

/*
 * end of ld pacification
 */
extern int DontLog;
extern int ReadOnly;
int	CheckMeta;
static char *Me;		/* the name of this program */
extern int DoTree;

main(argc, argv)
	int	argc;
	char   **argv;
{
	int Quiet = 0;

	/* when you're strange, no one remembers your name */
	Me = *argv;

	DontLog = 1;
	ReadOnly = 0;
	while (--argc > 0 && **(++argv) == '-')
	{
		char *equal, **opt;

		(*argv)++;
		if (**argv == 'q')
			Quiet++;
		else if (equal = index(*argv, '='))
		{
			*equal++ = 0;
			for (opt = Strings; *opt; opt += 2)
				if (!strcmp(opt[0], *argv))
				{
					opt[1] = equal;
					break;
				}
			if (*opt == '\0')
			{
				fprintf(stderr, "%s: %s: unknown string.\n",
					Me, *argv);
				exit(1);
			}
		} else
		{
			fprintf(stderr, "%s: %s: unknown option.\n", Me, *argv);
			exit(1);
		}
	}
	Database = (argc > 0) ? *argv : DATABASE;
	if (!Quiet)
		fprintf(stderr, "%s: indexing database %s\n", Me, Database);
	sleep(5);
	setbuf(stdout, NULL);

	DoSysLog(0);		/* report errors to stderr */

	dbi_init(Database);
	dbd_init(Database);
	get_dir_head();
	if (!GetFieldConfig())
		exit(1);
	/* bintree_init(Database); *//* forget bintree here */
	DoTree = 0;
	print_head();
	printf("made indicies for %d dir entries\n", make_index());
	exit(0);
}

extern int TrySum;
extern int TryTimes;
extern int WordsIndexed;
extern int MaxIdx;

make_index()
{
	QDIR	dirp;
	long	ent;
	extern struct dirhead DirHead;
	int	entries_done;
	long	start_time, end_time;

	(void) time(&start_time);
	entries_done = 0;

	for (ent = 1; ent < DirHead.nents; ent++)
	{
		if (!next_ent(ent))
		{
			/* printf("didn't do %d\n",ent); */
			continue;
		}
		getdata(&dirp);	/* setup entry */

		/* for all make the index entries */
		MakeLookup(dirp, ent, make_lookup);

		if ((entries_done++ % 100) == 0)
		{
			(void) time(&end_time);
			printf("%d %ld %d %d %d %d\n", entries_done,
			       end_time - start_time,
			       TrySum, TryTimes, WordsIndexed, MaxIdx);
			MaxIdx = TrySum = TryTimes = 0;
			start_time = end_time;
		}
		FreeDir(&dirp);
	}
	return (ent);
}

print_head()
{
	extern struct dirhead DirHead;

	printf("nents = %d\n", DirHead.nents);
	printf("next_id = %d\n", DirHead.next_id);
}
