/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees, and by CSNET.  No warranties of
 * any kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed without prior consent of CSNET.
 * You may direct questions to nameserv@uiuc.edu
 */

/*
 * This program creates the files associated with a database. if the name of
 * the database is given, then all files are made. If a specific file is
 * named then that file only is made. A database name can't contain a ".".
 * The size is mandatory and is used to build the .idx file.
 */

#include "protos.h"

#define DIR 1
#define INDEX 2

static char *Me;		/* the name of this program */

main(argc, argv)
	int	argc;
	char	**argv;
{
	int	fd, fsize, ftype;
	char	zero = 0;
	char	*dotptr;
	char	tmp[100];
	struct dirhead Dirhead;

	/* when you're strange, no one remembers your name */
	Me = *argv;

	while (--argc > 0 && **(++argv) == '-')
	{
		char *equal, **opt;

		(*argv)++;
		if (equal = index(*argv, '='))
		{
			*equal++ = '\0';
			for (opt = Strings; *opt; opt += 2)
				if (!strcmp(opt[0], *argv))
				{
					opt[1] = equal;
					break;
				}
			if (*opt == '\0')
			{
				fprintf(stderr, "%s: %s: unknown string.\n",
					Me, *argv);
				exit(1);
			}
		} else
		{
			fprintf(stderr, "%s: %s: unknown option.\n", Me, *argv);
			exit(1);
		}
	}
	if (argc < 1 || (fsize = atoi(*argv)) == 0)
	{
		printf("usage: %s size [filename[.(idx|dir)]]\n", Me);
		exit(1);
	}
	fsize *= (sizeof (struct iindex));
	argc--; argv++;

	Database = (argc > 0) ? *argv : DATABASE;
	fprintf(stderr, "%s: creating database %s\n", Me, Database);
	sleep(5);
	if (!(dotptr = rindex(Database, '.')))	/* create all */
		ftype = INDEX | DIR;
	else if (!strcmp(dotptr + 1, "dir"))
	{
		ftype = DIR;
		*dotptr = '\0';
	} else if (!strcmp(dotptr + 1, "idx"))
	{
		ftype = INDEX;
		*dotptr = '\0';
	}
	if (ftype & INDEX)
	{			/* make index file ,uses size */
		if (!index(Database, '.'))
			sprintf(tmp, "%s.idx", Database);
		else
			strcpy(tmp, Database);
		if (!(fd = creat(tmp, 0664)))
		{
			perror(tmp);
			exit(1);
		}

		if (lseek(fd, fsize - 1, 0) < 0)
		{
			perror(tmp);
			exit(1);
		}
		if (write(fd, &zero, 1) < 0)
		{
			perror(tmp);
			exit(1);
		}
		printf("%s : %d bytes\n", tmp, fsize);
		close(fd);

		/* create overflow file */
		sprintf(tmp, "%s.iov", Database);
		if (!(fd = creat(tmp, 0664)))
		{
			perror(tmp);
			exit(1);
		}
		close(fd);
	}
	if (ftype & DIR)
	{
		if (!index(Database, '.'))
			sprintf(tmp, "%s.dir", Database);
		else
			strcpy(tmp, Database);
		if (!(fd = creat(tmp, 0664)))
		{
			perror(tmp);
			exit(1);
		}
		Dirhead.nents = 0;
		Dirhead.next_id = 1;
		Dirhead.nfree = 0;
		if (lseek(fd, 0, 0) < 0)
		{
			perror(tmp);
			exit(1);
		}
		if (write(fd, &Dirhead, sizeof (Dirhead)) < 0)
		{
			perror(tmp);
			exit(1);
		}
		fsize = (sizeof (DREC));
		if (lseek(fd, fsize - 1, 0) < 0)
		{
			perror(tmp);
			exit(1);
		}
		if (write(fd, &zero, 1) < 0)
		{
			perror(tmp);
			exit(1);
		}
		printf("%s : %d bytes\n", tmp, fsize);
		close(fd);

		/* create overflow file */
		sprintf(tmp, "%s.dov", Database);
		if (!(fd = creat(tmp, 0664)))
		{
			perror(tmp);
			exit(1);
		}
		close(fd);
	}
	exit(0);
}
