/****************************************************************
 *	Copyright 1986, Gene H. Olson, Quest Research, Burnsville   *
 *	Minnesota.   Permission to copy and distribute this         *
 *	program, all associated code in source and binary form,     *
 *	for any purpose, so long as this notice is preserved.       *
 ****************************************************************/

#define LCK_PATH "/usr/spool/locks/LCK.."
#define SYSTEMS_FILE "/usr/lib/uucp/L.sys"
#define DEVICES_FILE "/usr/lib/uucp/L-devices"
#define DIALCODES_FILE "/usr/lib/uucp/L-dialcodes"

/*	Dial(3C) return codes */

#define	INTRPT   (-1)   /* Interrupt during dial */
#define	D_HUNG   (-2)   /* Dialer hung */
#define	NO_ANS   (-3)   /* Busy or no answer */
#define	ILL_BD   (-4)   /* Illegal/unknown baud rate */
#define	A_PROB   (-5)   /* Dialinfo(4) configuration error */
#define	L_PROB   (-6)   /* TTY device error */
#define	NO_Ldv   (-7)   /* L-devices file unreadable */
#define	DV_NT_A  (-8)   /* Requested device not available */
#define	DV_NT_K  (-9)   /* Requested device unknown */
#define	NO_BD_A  (-10)  /* Nothing available at requested speed */
#define	NO_BD_K  (-11)  /* No device known at requested speed */

/*	Dial(3C) Call structure */

typedef struct {
	struct termio  *attr;     /* Final terminal attributes */
	int            baud;      /* Baud rate to use after dialing */
	int            speed;     /* Baud rate to use during dialing */
	char           *line;     /* TTY device name */
	char           *telno;    /* Phone number(s) or system name */
	int            modem;     /* Modem control for direct lines */
	char           *device;   /* ACU or dialer name */
	int            dev_len;   /* Length of device name (not used) */
} CALL;

/*	External definitions */

extern int nolock ;	/* Don't use the lock file */

extern int dial() ;
extern void undial() ;
extern void dialmsg() ;
