#! /usr/bin/perl
###############################################################################
#
# File:         indexer.pl
# RCS:          $Header: /users/darrylo/.repository/mh-e/indexer.pl,v 1.1 1998/07/23 22:31:58 darrylo Exp $
# Description:  Perl script to index MH mail folders using glimpse.
#		Designed for use with exmh or mh-e w/glimpse extensions.
# Author:       Darryl Okahata
# Created:      Mon Jul 13 15:57:12 1998
# Modified:     Fri Jul 17 23:00:51 1998 (Darryl Okahata) darrylo@sr.hp.com
# Language:     CPerl
# Package:      N/A
# Status:       Experimental (Do Not Distribute)
#
# (C) Copyright 1998, Hewlett-Packard, all rights reserved.
#
###############################################################################

$mail_dir=`mhparam path`;
chop($mail_dir);

if ($mail_dir !~ m|^/|) {
    $mail_dir = $ENV{'HOME'} . '/' . $mail_dir;
}

die "\"$mail_dir\" is not a directory!" if (! -d $mail_dir);

chdir($mail_dir);

$folder_file = "$mail_dir/.folders";

$index_dir_basename = ".glimpse";
$index_dir = "$mail_dir/$index_dir_basename";

$glimpseoptions = '-M 10';

###############################################################################

require 'ctime.pl';
require 'getopts.pl';

&Getopts('EF');
$output_emacs_progress = 1 if ($opt_E);
$force_excl_update = 1 if ($opt_F);

$| = 1;

$total_files = 0;
$total_bytes = 0;
$total_index_bytes = 0;

$start = &ctime(time);
print "MH Mail indexing started at $start\n";

if ($force_excl_update || !-r $folder_file) {
    unlink($folder_file);		# make sure
    $cmd = "find . -type d -print |
	    sed -e '/\\/$index_dir_basename/d' -e 's|^\\./||' -e '/^\\.\$/d' |
	    sort > $folder_file";
    system($cmd);
    $force_excl_update = 1;
}

$folder_indexed = '';
open(IN, "<$folder_file") || die "$folder_file: $!";
while (<IN>) {
    next if (m@^\s*$@ || m@^\s*\#.*$@);
    chop;
    $folder = $_;
#    print "$folder\n";
    $folder_indexed = 1 if (&index_folder($folder));
}
close(IN);

if ($folder_indexed) {
    if ($total_bytes > 0) {
	$percent = $total_index_bytes / $total_bytes * 100.0;
    } else {
	$percent = 999;
    }
    printf("\n%-20s %5d files, %8d bytes, %7d index bytes, %.1f%%\n",
	   "Totals:", $total_files, $total_bytes, $total_index_bytes,
	   $percent);
} else {
    print "No folders to index\n";
}

$stop = &ctime(time);
print "\nMH Mail indexing finished at $stop";

exit 0;

###############################################################################


sub index_folder
{
    local($folder) = @_;
    local($excl_update, $folder_dir, $dir, $excl, $excl_update, $subdir);
    local($cmd, $nfiles, $file_sizes, $index_size, $size, $filename);
    local($indexed, $percent);

    $indexed = '';
    $excl_update = '';
#    print "$folder\n";
    $folder_dir = "$mail_dir/$folder";
    $dir = "$index_dir/$folder";
    $excl = "$dir/.glimpse_exclude";
    if (!-d $dir) {
	unlink($dir);			# make sure
	mkdir($dir, 0755);
	$excl_update = 1;
    }
    if ($excl_update || $force_excl_update) {
	unlink($excl);			# make sure
	open(OUT, ">$excl") || die "$excl: $!";
	print OUT <<'EOF';
^.*$
^#*$
^*~$
*/.*
*/#*
*/*~
EOF
	foreach $subdir (`cd $folder_dir ; find . -type d`) {
	    chop($subdir);
	    next if ($subdir =~ m|^\.$|);
	    $subdir =~ s|^\./||;
	    next if ($subdir =~ /^\s*$/);
	    print OUT "$subdir/*\n";
	}
	close(OUT);
    }
#    print -M $folder_dir, " ", -M $dir, "\n";
    if (((-M $folder_dir) < (-M $dir)) || $excl_update || $force_excl_update) {
	if ($output_emacs_progress) {
	    print "*Indexing $folder\n";
	}
	unlink("$dir/.glimpse_messages");
	unlink("$dir/.glimpse_statistics");
	$cmd = "glimpseindex -H $dir $glimpseoptions $folder_dir";
#	print "$cmd\n";
	if (open(GLIMPSE, "$cmd 2>&1 |")) {
	    $nfiles = 0;
	    $file_sizes = 0;
	    $index_size = 0;
	    while (<GLIMPSE>) {
		if (/Size.+indexed\s+=\s+([0-9]+)\s+B,\s+Total.+files\s+=\s+([0-9]+)/) {
		    $file_sizes = $1;
		    $nfiles = $2;
		} elsif (/\s([0-9]+)\s+[^\s]+\s+[^\s]+\s+[^\s]+\s+(.glimpse_[^\s]+)/) {
		    $size = $1;
		    $filename = $2;
		    $index_size += $size;
		}
	    }
	    close(GLIMPSE);# || die "\"$folder_dir\": closing glimpse process: $!";
	    if ($file_sizes > 0) {
		$percent = $index_size / $file_sizes * 100.0;
	    } else {
		$percent = 999;
	    }
	    printf("%-20s %5d files, %8d bytes, %7d index bytes, %.1f%%\n",
		   $folder, $nfiles, $file_sizes, $index_size, $percent);
	    $total_files += $nfiles;
	    $total_bytes += $file_sizes;
	    $total_index_bytes += $index_size;
	    $indexed = 1;
	} else {
	    print "\"$folder_dir\": unable to execute glimpse\n";
	}
    } else {
	if ($output_emacs_progress) {
	    print "*$folder up-to-date\n";
	}
    }
    return ($indexed);
}
