/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees, and by CSNET.  No warranties of
 * any kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed without prior consent of CSNET.
 * You may direct questions to nameserv@uiuc.edu
 */

#include "db.h"
#ifdef __STDC__
# include <stdlib.h>
# include <string.h>
# ifndef index
#  define index strchr
#  define rindex strrchr
# endif /* !index */
#else /* !__STDC__ */
char	*index();
char	*rindex();
#endif /* __STDC__ */

#define DIR 1
#define INDEX 2

/*
 * This program creates the files associated with a database. if the name of
 * the database is given, then all files are made. If a specific file is
 * named then that file only is made. A database name can't contain a ".".
 * The size is mandatory and is used to build the .idx file.
 */

main(argc, argv)
	int	argc;
	char	**argv;
{
	int	fd, fsize, ftype;
	char	zero = 0;
	char	*dotptr;
	char	tmp[100];
	struct dirhead Dirhead;

	if (argc < 3)
	{
		printf("usage: %s filename[.(idx|dir)] size\n", argv[0]);
		exit(1);
	}
	if (!(dotptr = rindex(argv[1], '.')))	/* create all */
		ftype = INDEX | DIR;
	else if (!strcmp(dotptr + 1, "dir"))
	{
		ftype = DIR;
		*dotptr = '\0';
	} else if (!strcmp(dotptr + 1, "idx"))
	{
		ftype = INDEX;
		*dotptr = '\0';
	}
	if (ftype & INDEX)
	{			/* make index file ,uses size */
		if (!index(argv[1], '.'))
			sprintf(tmp, "%s.idx", argv[1]);
		else
			strcpy(tmp, argv[1]);
		if (!(fd = creat(tmp, 0664)))
		{
			perror(tmp);
			exit(1);
		}
		fsize = atoi(argv[2]);
		fsize *= (sizeof (struct iindex));

		if (lseek(fd, fsize - 1, 0) < 0)
		{
			perror(tmp);
			exit(1);
		}
		if (write(fd, &zero, 1) < 0)
		{
			perror(tmp);
			exit(1);
		}
		printf("%s : %d bytes\n", tmp, fsize);
		close(fd);

		/* create overflow file */
		sprintf(tmp, "%s.iov", argv[1]);
		if (!(fd = creat(tmp, 0664)))
		{
			perror(tmp);
			exit(1);
		}
		close(fd);
	}
	if (ftype & DIR)
	{
		if (!index(argv[1], '.'))
			sprintf(tmp, "%s.dir", argv[1]);
		else
			strcpy(tmp, argv[1]);
		if (!(fd = creat(tmp, 0664)))
		{
			perror(tmp);
			exit(1);
		}
		Dirhead.nents = 0;
		Dirhead.next_id = 1;
		Dirhead.nfree = 0;
		if (lseek(fd, 0, 0) < 0)
		{
			perror(tmp);
			exit(1);
		}
		if (write(fd, &Dirhead, sizeof (Dirhead)) < 0)
		{
			perror(tmp);
			exit(1);
		}
		fsize = (sizeof (DREC));
		if (lseek(fd, fsize - 1, 0) < 0)
		{
			perror(tmp);
			exit(1);
		}
		if (write(fd, &zero, 1) < 0)
		{
			perror(tmp);
			exit(1);
		}
		printf("%s : %d bytes\n", tmp, fsize);
		close(fd);

		/* create overflow file */
		sprintf(tmp, "%s.dov", argv[1]);
		if (!(fd = creat(tmp, 0664)))
		{
			perror(tmp);
			exit(1);
		}
		close(fd);
	}
	exit(0);
}
