#ifndef PROTOS_H
#define PROTOS_H
#include <cdefs.h>
#include <stdio.h>
#include <ctype.h>
#include "bintree.h"
#include "commands.h"
#include "conf.h"
#include "db.h"
#include "field.h"
#include "log.h"
#include "options.h"
#include "qi.h"
#include "replies.h"

#define NEW(type)	((type *)malloc(sizeof(type)))

extern int errno;

#ifdef __STDC__
# include <stdlib.h>
# include <string.h>
# ifndef index
#  define index strchr
#  define rindex strrchr
# endif /* !index */
# ifndef bcmp
#  define bcmp memcmp
# endif /* !bcmp */
# ifndef bzero
#  define bzero(s,n) memset(s,0,n)
# endif /* !bzero */
# ifndef bcopy
#  define bcopy(h,a,l) memcpy(a,h,l)
# endif /* !bcopy */
#else /* !__STDC__ */
# include <strings.h>
MEM_TYPE *malloc(), *realloc();
char	*strtok();
#endif /* __STDC__ */

char	*crypt __P((const char *, const char *));

char	**getdata __P((QDIR *));
char	*add_string __P((char *));
char	*decrypt __P((char *, char *));
long	*DoLookup __P((ARG *));
long	*do_lookup __P((char **, long *));
FDESC	*FindFD __P((char *));
FDESC	*FindFDI __P((int));
OPTION	*FindOption __P((char *));
long	*findstr __P((char *));
long	*find_all __P((char *));
ARG	*FreshArg __P(());
ARG	*GetAllFields();
DREC	*getdirent __P((long));
FDESC	*GetFD __P((FILE *));
ARG	*getplusAlways __P((ARG *));
ARG	*GetPrintDefaults();
long	*getrecptrs __P((struct iindex *));
char	*getword __P((char *, char *));
long	*get_dir_ptrs __P((long));
long	*intersect __P((long *, long *));
long	*i_oread __P((long, long *));
char	*ltrunc __P((char *));
char	*make_str __P((char *));
long	*merge __P((long *, long *));
char	*PasswordOf __P((QDIR));
char	*phonemify __P((char *));
char	*RandomString __P((int));
char	*strecat __P((char *, char *));
char	*strecpy __P((char *, char *));
char	*strlcpy __P((char *, char *));
char	*StrSkip __P((char *, char *));
char	*to_low_str __P((char *));
long	*un_dupi __P((long *));
char	*Visible __P((char *, int));
void	AddValue __P((char *, int));
int	AliasIsUsed __P((char *, long));
int	AllMeta __P((char *));
IDX	allocate_leaf();
int	any __P((int, char *));		/* 1 char -> int */
int	anyof __P((register char *, register char *));
int	BadAlias __P((char *));
void	bintree_init __P((char *));
int	blankline __P((char *));
int	CanAddEntries();
int	CanChange __P((QDIR, FDESC *));
int	CanDelete __P((QDIR));
int	CanLookup __P((FDESC *));
int	CanSee __P((QDIR, FDESC *, int));
int	ChangeDir __P((QDIR *, FDESC *, char *));
int	ChangeEntries __P((long *, ARG *));
void	close_tree();
void	CollectQuote __P((char *, int));
int	countc __P((char *, int));	/* 2 char -> int */
int	CountDir __P((char *, int));
void	crypt_init __P((char *));
void	crypt_start __P((char *));
int	CurrentDate();
int	CurrentIndex();
int	dbd_init __P((char *));
int	dbi_init __P((char *));
int	decode __P((unsigned char *, unsigned char *));
void	decrypt_end();
int	delete __P((char *));
int	deletestr __P((char *, int));
int	DirMatch __P((QDIR, int, char *, int));
int	dnext_ent __P((long));
void	DoAdd __P((ARG *));
void	DoAnswer __P((ARG *));
void	DoChange __P((ARG *));
void	DoCommand __P((int));
void	DoDelete __P((ARG *));
void	DoFields __P((ARG *));
void	DoHelp __P((ARG *));
void	DoId __P((ARG *));
void	DoInfo __P((ARG *));
void	DoLogin __P((ARG *));
void	DoLogout __P((ARG *));
void	DoQuery __P((ARG *));
void	DoQuit __P((ARG *));
void	DoReply __P((int, char *, ...));
void	DoSet __P((ARG *));
void	DoStatus __P((ARG *));
int	DoSysLog __P((int));
void	DumpFD __P((FILE *, FDESC *));
void	DumpOutput();
int	d_oread __P((DOVR *, int));
int	d_owrite __P((DOVR *, int));
int	d_read __P((DREC *, long));
int	d_write __P((DREC *, long));
int	encode __P((char *, char *, int));
int	encryptit __P((char *, char *));
int	ent_dead();
void	expand __P((LEAF *, int, ITEM *));
int	FindField __P((QDIR, int));
void	flush_leaf();
void	FreeArgs __P((ARG *));
void	FreeDir __P((QDIR *));
void	free_ary __P((long **));
int	GetAC __P((FILE *));
QDIR	GetAliasDir __P((char *));
int	GetFieldConfig();
int	getient __P((register char *, struct iindex *));
int	GetState();
int	getx __P((long *));
void	get_dir_head();
void	get_tree_head();
int	GonnaRead();
int	GonnaWrite();
int	HelpCopy __P((int, FILE *));
int	HelpText __P((int, char *, char *));
int	icopy __P((char *, char *));
long	ihash __P((char *, long, long));
void	InitializeLogging();
void	InitializeOptions();
void	init_string();
void	insert __P((char *, IDX));
int	isblank __P((char *));
int	IsProxy __P((QDIR, char *));
int	issub __P((char *, char *));
int	IssueMessage __P((int, char *fmt, ...));
int	i_owrite __P((long *, long));
int	i_read __P((struct iindex *, long));
int	i_write __P((struct iindex *, long));
int	length __P((long *));
void	LimitHit __P((int));
void	LimitTime __P((int));
void	ListAllFields();
void	ListField __P((FDESC *));
int	ListTopics __P((int, char *));
void	LockInit();
QDIR	MakeADir __P((ARG *));
void	MakeDir __P((QDIR *, int));
void	make_lookup __P((char *, int));
void	mkargv __P((int *, char **, char *));
int	newdovr();
int	new_ent();
int	next_ent __P((long));
void	NotImplemented __P((ARG *));
int	OkByEmail __P((QDIR, char *));
int	OkFields __P((ARG *));
int	OpenTempOut();
int	ovrnew();
void	printarry __P((long *));
void	PrintCommand __P((int, ARG *));
int	PrintFields __P((long *, ARG *, int));
void	PrintOld __P((long *));
void	PrintThem __P((long *, ARG *));
int	print_ent __P((char *));
int	putarry __P((struct iindex *, long *, long));
int	putdata __P((char **));
void	putdirent __P((long, DREC *));
int	putstr __P((char *, int));
void	put_dir_head();
void	put_tree_head();
int	quoted __P((char *));
int	RateAKey __P((char *));
void	read_index __P((char *));
void	read_leaf __P((IDX, LEAF *));
int	RemoveSpecials __P((char *));
int	search __P((char *, LEAF *, int *));
void	SetDeleteMark();
void	SetOption __P((OPTION *, char *));
void	set_date __P((int));
void	simple_insert __P((LEAF *, int, ITEM *, int));
void	SleepTil __P((long));
IDX	start_point __P((char *));
void	store_ent();
int	strcate __P((char *, char *));
int	strcpc __P((register char *, register char *));
int	stricmp __P((char *, char *));
int	strincmp __P((char *, char *, int));
int	ThinArgs __P((ARG *, int));
void	threecpy __P((unsigned char *, unsigned char *));
void	TimeOut __P((int));
void	Unknown __P((char *));
void	Unlock();
void	unmake_lookup __P((char *, int));
int	UserCanChange __P((QDIR));
int	UserCanDelete();
int	UserMatch __P((char *));
int	ValidAdd __P((ARG *));
int	ValidQuery __P((ARG *, int));
void	WhoAreYou();
void	write_leaf __P((LEAF *));

#endif	/*PROTOS_H*/
