#!/usr/bin/perl
#
# archieplex.pl -- Configurable Archie search
#
# $Id: archieplex.pl,v 1.6 1994/08/10 19:08:59 mak Exp $
#
# By Martijn Koster (m.koster@nexor.co.uk)
# This code is placed in the public domain.

# archieplex*.pl files:
$packages = '/nexor/users/www/data/archieplex-info';

unshift(@INC,$packages);
require "archieplexengine.pl";

package archieplex;

%order = (
	  'host',	' ',
	  'date',	'-t',
	  );

%type = (
	 'exact',		'-e',
	 'substring',		'-s',
	 'nocasesubstring',	'-c',
	 'regexp',		'-r',
	 );
			       
%titles = (
	   'host',		'',
	   'date', 		' by Date',

	   'exact',		'Exact Match',
	   'substring',		'Substring Match',
	   'nocasesubstring',	'Case Insensitive Substring Match',
	   'regexp',		'Regular Expression Match',
	   );

# CGI Interface
if (!defined $main'plexus_configured)
{
    $top = $ENV{'SCRIPT_NAME'};
    $rest = $ENV{'PATH_INFO'};
    $query = $ENV{'QUERY_STRING'};
    &main'do_archieplex($top, $rest, $query);
}

# Plexus interface
sub main'do_archieplex
{
    # $top is the first component of the url, indicating the gateway selector
    # $rest is the rest of the UR
    # $query is the query string

    local($top, $rest, $query) = @_;

    # since the separator change from '/' to '&' there have been
    # complaints about old URL's. This explicit redirect may clear
    # up the confusion.

    if ($rest=~s,/,&,g) {	# contains /, bad news

	print <<EOM;
<HTML>
<HEAD>
    <TITLE>
	Old ArchiePlex URL
    </TITLE>
</HEAD>
<BODY>
    <H1>
	Old ArchiePlex URL
    </H1>

    This URL is in the old ArchiePlex format, and is discouraged after a
    <a href="http://web.nexor.co.uk/archieplex-info/changes.html#archieplexurl">
    recent change</A>.

<p>

    Please replace the path component of the ArchiePlex URL with
    <code><A href="/$top/$rest">/$top/$rest</A></code>
    in the document you found this URL on$refererline.

<p>

    If you encountered this URL on someone else's page please tell them
    so they can fix it.

<p>
    Sorry about the inconvenience,

<p>

   <Address>
     <a href="http://web.nexor.co.uk/mak/mak.html">Martijn Koster</a>
   </address>
</BODY>
EOM
    return;
    }

    if ($rest) {

	for(split('&', $rest)) {
	    next if !$_;
 
	    if (!/=/) {
		&main'error('bad_request',"options shoud have <code>tag=value</code>'")
	    }
	    local($tag, $value) = split('=', $_, 2);
	    next if !$value;

	    if ($tags{$tag}) {
		&main'error('bad_request',"Duplicate tag '<code>$tag</code>'");
	    }

	    $tags{$tag} = $value;

	    if ($tag eq 'server') {
		$server = $value;
	    } elsif ($tag eq 'type') {
		$type = $value;
	    } elsif ($tag eq 'order') {
		$order = $value;
	    } else {
		&main'error('bad_request',"Unknown tag '<code>$tag</code>'");
	    }
	}
    }

    if ($query) {
	&do_search($server, $type, $order, $query);
    } else {
	&do_dialog($server, $type, $order);
    }
}
	
sub do_dialog
{
    local($server, $type, $order) = @_;

    &main'MIME_header('ok', 'text/html');

    print <<"EOM";
<HTML>
<HEAD>
  <ISINDEX>
  <TITLE>ArchiePlex $titles{$type} $titles{$order}</TITLE>
</HEAD>
<BODY>
  <H1>ArchiePlex $titles{$type} $titles{$order}</H1>
      ArchiePlex locates files available for anonymous FTP.
  <p>
EOM
    print "This service uses the Archie server at <CODE>$server</CODE> to execute the searches.<p>"
	if (defined $server && $server);

    print <<'EOM';
      Please specify a search term.


  <P>
     See also:

      <UL>
EOM
    $top =~ s,^/*,/,;
    $start = "<LI><A HREF=\"$top/server=$server";
    
    print "$start&type=$type&order=host\">$titles{$type} sorted by Host</A>\n"
	unless ($order eq 'host');	

    print "$start&type=$type&order=date\">$titles{$type} sorted by Date</A>\n"
	unless ($order eq 'date');

    print "</UL>\n<UL>\n";

    print "$start&type=nocasesubstring&order=$order\">$titles{'nocasesubstring'}$titles{$order}</A>\n"
	unless ($type eq 'nocasesubstring');

    print "$start&type=substring&order=$order\">$titles{'substring'}$titles{$order}</A>\n"
	unless ($type eq 'substring');

    print "$start&type=exact&order=$order\">$titles{'exact'}$titles{$order}</A>\n"
	unless ($type eq 'exact');
    
    print "$start&type=regexp&order=$order\">$titles{'regexp'}$titles{$order}</A>\n"
	unless (type eq 'regexp');

    print <<"EOM";
  </UL>
</BODY>
</HTML>
EOM
}

sub do_search
{
    local($server, $type, $order, $query) = @_;

    if (defined $type && $type) {
	$type = $type{$type} || &main'error('bad_request', "Unknown type '$type'");
    }
    if (defined $order && $order) {
	$order = $order{$order} || &main'error('bad_request', "Unknown order '$order'");
    }
    $query =~ s/\+/ /g;
    $query =~ s/%([\da-f]{1,2})/pack(C,hex($1))/eig;

    &archieplexengine'execute($server, $type, $order, undef, $query);
}
    
1;
