
/*

This is to be able to run Alex off of a different port number.

Slightly modified from what was sent in by:

Date: Mon, 27 Jun 94 18:09:05 EDT
From: mct@philabs.Philips.COM (Mark C. Tucker)
To: vac@cs.cmu.edu
Subject: force_mount_alex is working

*/

#define DEFAULTSERVER "foo.bar.edu"

#define NFSCLIENT
#include <sys/errno.h>
#include <sys/mount.h>
#include <rpc/rpc.h>
#include <sys/socket.h>  /* for the socket library of calls */

#include "nfs_prot.h"
/*#include <nfs/nfs.h>*/
#include <netinet/in.h>
#include <netdb.h>
#include "config.nfs.h"

#include <stdio.h>
/* from #include <sys/mount.h> */
#ifdef NEVERDEF
struct	nfs_args {
	struct sockaddr_in	*addr;		/* file server address */
	caddr_t			fh;		/* File handle to be mounted */
	int			flags;		/* flags */
	int			wsize;		/* write size in bytes */
	int			rsize;		/* read size in bytes */
	int			timeo;		/* initial timeout in .1 secs */
	int			retrans;	/* times to retry send */
	char			*hostname;	/* server's hostname */
	int			acregmin;	/* attr cache file min secs */
	int			acregmax;	/* attr cache file max secs */
	int			acdirmin;	/* attr cache dir min secs */
	int			acdirmax;	/* attr cache dir max secs */
	char			*netname;	/* server's netname */
	struct pathcnf		*pathconf;	/* static pathconf kludge */
};
#endif
struct nfs_args ma;
struct sockaddr_in server_addr;

struct sockaddr_in sockaddr_by_name(hostname,portnr)
	char *hostname;int portnr;
{
  struct hostent *hp;
  struct sockaddr_in rv;
  
  if( (hp = gethostbyname(hostname)) == NULL)
    {
      fprintf(stderr,"can't get addr for host: {%s}\n",DEFAULTSERVER);
      exit(-1);
    };

  /* Copy the host addr into the sockaddr we will try to connect */
  /* to. */
  bcopy(hp->h_addr,(caddr_t)&rv.sin_addr,hp->h_length);
     
  rv.sin_family = AF_INET;
  rv.sin_port 	= portnr;
  return rv;
}


extern int errno;
nfs_fh hack_handle;
char *alexhost;

main(argc,argv) int argc; char **argv;
{
  int portnr;
  int rv;


  if( argc == 1)
    {
      alexhost = DEFAULTSERVER;
    }
  else if (argc == 2)
    {
      alexhost = argv[1];
    }
  else
    {
      printf("[usage] force_mount_alex /hack init\n");
      printf("<force_mount_alex failed\n");
      exit(-1);
    }
  printf(">force_mount_alex on:{%s}\n",alexhost);
  if( !alexhost) { printf("force_mount_alex needs an alexhost.\n");exit(-1);}

  
  /*portnr = */
  /*getrpcport(DEFAULTSERVER,NFS_PROGRAM,NFS_VERSION,IPPROTO_UDP);*/
  portnr = ALEXNFSPORT;
  printf("Using portnr: %d on %s\n",portnr,alexhost);
  /*if( portnr == 0) perror("getrpcport failed");*/
  
  server_addr = sockaddr_by_name(alexhost,portnr);
  ma.addr = &server_addr;
  /*strcpy(&hack_handle,initialHandle);*/
  *((int *)(&hack_handle)) = 3;
  ma.fh = (caddr_t) &hack_handle;
  ma.flags =
    NFSMNT_SOFT|NFSMNT_TIMEO|NFSMNT_HOSTNAME
    |NFSMNT_ACREGMIN|NFSMNT_ACREGMAX|NFSMNT_ACDIRMIN|NFSMNT_ACDIRMAX
	|NFSMNT_RETRANS|NFSMNT_RSIZE; 
  ma.hostname = "alexForceHack";
  ma.timeo	= 30;
  ma.retrans 	= 1000;
  ma.rsize 	= 8192;
  ma.acregmin	= 3;
  ma.acregmax	= 60;
  ma.acdirmin	= 30;
  ma.acdirmax	= 60;

  if( (rv = mount("nfs","/alex",M_NEWTYPE|M_NOSUID|M_RDONLY,&ma)) < 0)
    {
      printf("rv: %d errno: %d alexhost{%s}\n",rv,errno,alexhost);
      perror("Mount Failed\n");
      printf("<force_mount_alex EXITING: {%s}\n",alexhost);
      exit(-1);
    };
  
  printf("<force_mount_alex ok on: {%s}\n",alexhost);
}

