/*
** This software is Copyright (c) 1992 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise 
** use any part of this package as long as you do not try to make 
** money from it or pretend that you wrote it.  This copyright 
** notice must be maintained in any copy made.
**
*/

#ifdef GATEWAY 

#include <stdio.h>
#include <sys/stat.h>
#include <syslog.h>
#include <dirent.h>

#define CONFIG_FILE "/etc/outbound.cfg"

char Motd[MAXNAMLEN];     /* Admin message file for displaying status info */
FILE *config;

extern struct stat stbuf;
extern int Load_limit;

int fclose();
int stat();
char *strchr();
char *strcpy();
char *strstrip();

int read_config()
{
    char *sp;
    char *rp;
    char *buf;
    char buffer[BUFSIZ];

    if ((config = fopen(CONFIG_FILE,"r")) == NULL) {
        syslog(LOG_ERR,"Can not open %s\n", CONFIG_FILE);
        return(0);
    }

    while (fgets(buffer,sizeof buffer,config) != NULL) {
        /* ignore comments and blank lines */
        if (*buffer == '#' || !*buffer) 
            continue;

        buf = buffer;

        /* strip leading spaces and tabs */
	while(*buf == ' ' || *buf == '\t')
             ++buf;

        /* if embedded comments, truncate at the comment */
        if ((sp = strchr(buf,'#')) != NULL)
             *sp = '\0';
    
        if ((sp = strchr(buf,'=')) != NULL) {
            sp++;
            while (*sp == ' ' || *sp == '\t')
                sp++;
            if (!*sp)		/* is something still there ? */
		continue;

            switch(*buf) {
                case 'l': /* fall through expected... */
                case 'L': 
                    if (strncasecmp(buf, "LOAD=", 5) == 0) {
                        rp = strstrip(sp);
                        Load_limit = atoi(rp);
                    }
                    break;
                case 'm': /* fall through expected... */
                case 'M': 
                    if (strncasecmp(buf, "MOTD=", 5) == 0) {
                        rp = strstrip(sp);
                        /*
                        ** Need to assure the user has specified
                        ** a valid message file path.
                        */
                        if (stat(rp, &stbuf) != 0) {
                            syslog(LOG_ERR, "Can not find MOTD - %s",rp);
                            return(0);
                        }
                        (void) strcpy(Motd, rp);
                    }
                    break;
            }
        }
    }
    (void) fclose(config);
    return(1);
}

int display_file(file)
char *file;
{
    char buffer[BUFSIZ];
    FILE *fp;

    if ((fp = fopen(file,"r")) == NULL) {
        syslog(LOG_ERR,"Can not open %s\n", file);
        return(0);
    }
    while (fgets(buffer,sizeof buffer,fp) != NULL) {
        printf("%s",buffer);
    }
    (void) fclose(fp);
}
/*
** strstrip:
**
** strstrip(str) returns a pointer to the first non-blank character
** in str. It strips all blanks, and tabs from the front and back
** of a string as well as strip off newlines from the rear.
**
** char *strstrip(str) char *str; { return (str); }
*/

char *strstrip(str)
register char *str;
{
    int strlen();
    register char *cp, *dp;

    cp = str;
    dp = ((str+strlen(str))-1);

    while(*cp && (*cp == ' ' || *cp == '\t'))
      cp++;

    while(dp != cp && (*dp == ' ' || *dp == '\t' || *dp == '\n'))
      --dp;
    *(dp+1) = '\0';

    return(cp);
}

#endif /* GATEWAY */

#ifdef UNITTEST

int fprintf();
char *progname;

int Load_limit;
struct stat stbuf;

int main()
{
    int rc;

    rc = read_config();
    if (rc == 0)
        (void) fprintf(stderr,"read_config failed\n");
    else
        (void) fprintf(stderr,"Motd   == %s\n", Motd);
        (void) fprintf(stderr,"Load   == %ld\n", Load_limit);
 
    return(0);
}
#endif /* UNITTEST */
