/*
 * Copyright (c) 1993,1994
 *	Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Texas A&M University
 *	and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *             David K. Hess, Douglas Lee Schales, David R. Safford
 */
// FILTER.C

typedef struct _Statistics {
	unsigned long cacheAccesses;
	unsigned long cacheMisses;
	unsigned long droppedPackets;
	unsigned long insideFiltered;
	unsigned long outsideFiltered;
	unsigned long insideRx;
	unsigned long outsideRx;
	unsigned long insideTx;
	unsigned long outsideTx;
} Statistics;

typedef struct _IoVec {
        unsigned char *buffer;
        unsigned short length;
}      IoVec;

typedef struct _PktBuf {
	struct _PktBuf *nextLink;
	struct _PktBuf *prevLink;
	int handle;
	int length;
	int packetLength;
	unsigned long sequence;
	unsigned char *buffer;
} PktBuf;

typedef union _HardwareAddress {
        unsigned char bytes[6];
        unsigned short words[3];
        struct {
                unsigned char bytes[6];
        }      addr;
}                HardwareAddress;

typedef struct _Queue {
        PktBuf *head;
        PktBuf *tail;
}      Queue;

typedef struct _CardHandle {
	unsigned char moduleName[16];
        CommonCharacteristics *common;
        int maxSends;
        int sendsPending;
        Queue queue;
        Queue mgmtQueue;
}           CardHandle;

// Generic structure which can be mapped onto the source and destination
//   portion of all hardware frames.
typedef struct _GenericHeader {
        HardwareAddress destHost;
        HardwareAddress srcHost;
}              GenericHeader;

// Media level frame formats.

typedef struct _EthernetIIHeader {
        HardwareAddress etherDestHost;
        HardwareAddress etherSrcHost;
        unsigned short etherType;
}                 EthernetIIHeader;

typedef struct _Ieee802Dot3Header {
        HardwareAddress etherDestHost;
        HardwareAddress etherSrcHost;
        unsigned short length;
}                  Ieee802Dot3Header;

// Geez, this structure actually pads exactly as defined. Ugly.
typedef struct _FddiHeader {
	unsigned char frameControl;
        HardwareAddress etherDestHost;
        HardwareAddress etherSrcHost;
}           FddiHeader;

// NOTE: Token ring is defined but not yet currently supported.
typedef struct _Ieee802Dot5Header {
        HardwareAddress etherDestHost;
        HardwareAddress etherSrcHost;
        unsigned char routeInfo[30];
}                  Ieee802Dot5Header;

typedef struct _Ieee802Dot2SnapHeader {
        unsigned char dsap;			// 0xAA
        unsigned char ssap;			// 0xAA
        unsigned char control;			// 3
        unsigned char protocolId[5];
}                  Ieee802Dot2SnapHeader;

// Internet address structure.
typedef union _in_addr {
        struct {
                unsigned char s_b1;
                unsigned char s_b2;
                unsigned char s_b3;
                unsigned char s_b4;
        }      S_un_b;
        struct {
                unsigned short s_w1;
                unsigned short s_w2;
        }      S_un_w;
        unsigned long S_addr;
}        in_addr;

typedef struct _IpHeader {
 unsigned char ip_hl:
             4,                 /* header length */
      ip_v:
             4;                 /* version */
        unsigned char ip_tos;   /* type of service */
        unsigned short ip_len;  /* total length */
        unsigned short ip_id;   /* identification */
        short ip_off;           /* fragment offset field */
        unsigned char ip_ttl;   /* time to live */
        unsigned char ip_p;     /* protocol */
        unsigned short ip_sum;  /* checksum */
        in_addr ip_src,
                ip_dst;         /* source and dest address */
}         IpHeader;

typedef struct _ArpEntry {
	unsigned char *pendingPacket;
	int pendingPacketLength;
        HardwareAddress hardwareAddress;
        in_addr ipAddress;
        int timeToLive;
        int retries;
        int state;
}         ArpEntry;

typedef struct _ArpHeader {
        unsigned short hardType;/* Type of hardware address */
        unsigned short protType;/* Protocol we wish translation for */
        unsigned char hardSize; /* Size of a hardware addres */
        unsigned char protSize; /* Size of a protocol address */
        unsigned short op;      /* Operation requested */
        HardwareAddress sender; /* Hardware address of who is sending the request */
        in_addr senderIp;       /* Ditto but for IP */
        HardwareAddress target; /* Hardware address of who is targeted by the request */
        in_addr targetIp;       /* Ditto but for IP */
}          ArpHeader;

typedef struct _IcmpHeader {
        unsigned char type;     /* ICMP type */
        unsigned char code;     /* ICMP code */
        unsigned short chkSum;  /* ICMP check sum */
}           IcmpHeader;

typedef struct _IcmpEchoRequestHeader {
        unsigned short id;      /* ICMP Echo Request identifier */
        unsigned short seq;     /* ICMP Echo Request sequence identifier */
}                      IcmpEchoRequestHeader;

typedef unsigned long tcp_seq;

typedef struct _TcpHeader {
        unsigned short th_sport;/* source port */
        unsigned short th_dport;/* destination port */
        tcp_seq th_seq;         /* sequence number */
        tcp_seq th_ack;         /* acknowledgement number */
 unsigned int th_x2:
            4,                  /* (unused) */
     th_off:
            4;                  /* data offset */
        unsigned char th_flags;
        unsigned short th_win;  /* window */
        unsigned short th_sum;  /* checksum */
        unsigned short th_urp;  /* urgent pointer */
}          TcpHeader;

typedef struct _UdpHeader {
        unsigned short uh_sport;/* source port */
        unsigned short uh_dport;/* destination port */
        unsigned short uh_ulen; /* udp length */
        unsigned short uh_sum;  /* udp checksum */
}          UdpHeader;

//
// Structure for an address table entry.
//
typedef struct _AddrTableEntry {
        in_addr network;
        unsigned char dirty;
        unsigned short hostTable;
}               AddrTableEntry;

typedef struct _AccessListTableEntry {
        unsigned short begin;
        unsigned short end;
}                     AccessListTableEntry;

typedef struct _RejectTableEntry {
        in_addr network;
        unsigned long mask;
}                 RejectTableEntry;

// Note that it is assumed that this structure will always be 8 bytes long.
typedef struct _HashEntry {
        HardwareAddress address;
        unsigned char boardNumber;
	unsigned char valid;
}          HashEntry;

typedef struct _AllowTableEntry {
        in_addr network;
        unsigned long mask;
        AccessListTableEntry access[MAX_NUM_ACCESS_RANGES];
}                AllowTableEntry;

//
// Structure representing a filter protocol header.
//
// The purpose for the chkSum and randomInject members is to prevent bit twiddling of a
//   management datagram when encryption is in use. The chkSum prevents anyone from twiddling
//   the bits given a known plaintext and the randomInject prevents anyone from fixing the
//   chkSum because the plaintext is no longer known. Of course a checksum is not too strong
//   since they could brute force it in at most 2^16 tries. This needs to be eventually changed
//   to a CRC calculation.
typedef struct _FilterHeader {
        unsigned char type;
        unsigned char flags;
        unsigned short chkSum;
        unsigned short randomInject;
}           FilterHeader;

typedef struct _Key {
        unsigned long i1;
        unsigned long i2;
        unsigned long i3;
}    Key;

// MESSAGE.C

//
// Structure representing a filter protocol message.
//
typedef struct _SyncPacket {
        unsigned short spinCount;
        unsigned short dummy;
        Key key;
}           SyncPacket;

typedef struct _QueryPacket {
        unsigned char type;
        unsigned char dummy[3];
        union {
                unsigned char index;
                in_addr addr;
        }     queryValue;
        union {
                in_addr networks[MAX_NUM_NETWORKS];
                unsigned char index;
                RejectTableEntry reject[MAX_NUM_REJECT_ENTRIES];
                AllowTableEntry allow[MAX_NUM_ALLOW_ENTRIES];
                struct {
                        AccessListTableEntry in[MAX_NUM_ACCESS_RANGES];
                        AccessListTableEntry out[MAX_NUM_ACCESS_RANGES];
                        AccessListTableEntry src[MAX_NUM_ACCESS_RANGES];
                        AccessListTableEntry udp[MAX_NUM_ACCESS_RANGES];
                }      accessList;
        }     queryResult;
}            QueryPacket;

typedef struct _LoadPacket {
        unsigned char type;
        unsigned char flags;
        unsigned char dummy[2];
        union {
                unsigned char index;
                struct {
                        in_addr network;
                        unsigned long offset;
                }      networkBlock;
        }     loadValue;
        union {
                RejectTableEntry reject[MAX_NUM_REJECT_ENTRIES];
                AllowTableEntry allow[MAX_NUM_ALLOW_ENTRIES];
                struct {
                        AccessListTableEntry in[MAX_NUM_ACCESS_RANGES];
                        AccessListTableEntry out[MAX_NUM_ACCESS_RANGES];
                        AccessListTableEntry src[MAX_NUM_ACCESS_RANGES];
                        AccessListTableEntry udp[MAX_NUM_ACCESS_RANGES];
                }      accessList;
                unsigned char networkBlock[1024];
        }     loadData;
}           LoadPacket;

typedef struct _ReleasePacket {
        unsigned char type;
        unsigned char dummy[3];
        in_addr network;
}              ReleasePacket;

typedef struct _StatisticsPacket {
	unsigned char type;
	unsigned char dummy[3];
	unsigned long statistics[MAX_NUM_STATISTICS];
} StatisticsPacket;

typedef struct _ErrorPacket {
        unsigned char errorCode;
}            ErrorPacket;

// ODI.C

// POTP.C
// QUEUE.C
typedef void (* CallBack) (unsigned char *, int, struct _Socket *);

typedef struct _Socket {
        int kind;
        int flags;
        unsigned short localPort;
        unsigned short remotePort;
        in_addr host;
        CallBack callBack;
}       Socket;

// Typedef for check functions.
typedef int (* CheckFunction) (unsigned short, unsigned char *, int);

typedef struct _FilterConfig {
	int discardOther;
	int discardOtherIp;
	int discardSuspectOffset;
	int numBuffers;
	int listenMode;
	int numManagers;
	in_addr managers[MAX_NUM_MANAGERS];
	in_addr myIpAddr;
	in_addr mySubnetMask;
	in_addr myGateway;
	in_addr logHost;
	int logFacility;
	unsigned long logMask;
	unsigned short listenPort;
	int internalMacSet;
	HardwareAddress internalMac;
} FilterConfig;

typedef void (* EventCallBack) (struct _ScheduledEvent *);

typedef struct _ScheduledEvent {
	unsigned long time;    // Ticks.
	unsigned long opaque;  // Client data.
	EventCallBack callBack;
	unsigned valid;
	unsigned new;
} ScheduledEvent;

typedef struct _NetworkCacheEntry {
	unsigned long tag;
	unsigned char indicies[2];   // The block.
	unsigned long timestamp;
} NetworkCacheEntry;

typedef struct _SyslogMessageEntry {
	unsigned char *message;
	unsigned char priority;
	unsigned char encodedPriority[6];
} SyslogMessageEntry;
