/*
 * dfile.c - AIX file processing functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dfile.c,v 1.2 97/10/23 12:08:57 abe Exp $";
#endif


#include "lsof.h"


/*
 * is_file_named() - is file named?
 */

int
is_file_named(p, ty, ch, ic)
	char *p;			/* path name; NULL = search by device
					 * and inode (from *Lf) */
	enum vtype ty;			/* vnode type */
	chan_t ch;			/* gnode channel */
	int ic;				/* is clone file (4.1.4 and above) */
{
	int f;
	struct sfile *s;
/*
 * Search the file chain.
 */
	for (f = 0, s = Sfile; s; s = s->next) {

#if	AIXV>=4140
	/*
	 * Check for a clone match.
	 */
		if (ic
		&&  CloneMaj >= 0 && major(s->dev) == CloneMaj
		&&  Lf->inp_ty == 1
		&&  minor(s->dev) == major(Lf->dev)
		&&  s->i == (ino_t)Lf->inode) {
				f = 3;
				break;
		}
#endif	/* AIXV>=4140 */

	/*
	 * Search by path name, as requested.
	 */
		if (p != NULL) {
			if (strcmp(p, s->aname) == 0
			||  strcmp(p, s->name)  == 0)
			{
				f = 2;
				break;
			}
			continue;
		}

	/*
	 * Check for a regular AIX multiplexed file.  Match the channel if
	 * it was supplied.
	 */
		if (ty == VMPC) {
			if (s->type && s->mode == S_IFCHR && Lf->dev == s->dev
			&&  (s->ch < 0 || ch == s->ch)) {
				f = 1;
				break;
			}
			continue;
		}
	/*
	 * Check for a regular file or directory -- the device and
	 * inode numbers must match.
	 */
		if (s->type) {
			if (Lf->dev == s->dev && (ino_t)Lf->inode == s->i) {
				f = 1;
				break;
			}
			continue;
		}
	/*
	 * Check for a file system match.
	 * Try to avoid matching character files to non-character devices.
	 */
		if (Lf->dev == s->dev) {
			if ( ! (ty == VCHR && s->mode != S_IFCHR)) {
				f = 1;
				break;
			}
		}
	}
/*
 * Convert the name if a match occurred.
 */
	if (f) {
		if (f == 2) {
			(void) strcpy(Namech, p);

#if	AIXV>=4140
		} else if (f == 3 && ClonePtc >= 0
		       &&  major(Lf->dev) == ClonePtc)
		{
			(void) strcpy(Namech, s->name);
			(void) sprintf(endnm(), "/%d", minor(Lf->dev));

#endif	/* AIXV>=4140 */

		} else {
			(void) strcpy(Namech, s->name);
			if (ty == VMPC && s->ch < 0)
				(void) sprintf(endnm(), "/%d", ch);
			if (s->devnm)
				(void) sprintf(endnm(), " (%s)", s->devnm);
		}
		s->f = 1;
		return(1);
	}
	return(0);
}


/*
 * print_dev() - print device
 */

char *
print_dev(lf)
	struct lfile *lf;		/* file whose device to be printed */
{
	static char buf[128];

#if	AIXV>=3200
	if (lf->dev & SDEV_REMOTE) {
	    (void) sprintf(buf, "NFS,%d", minor(lf->dev));
	    return(buf);
	}
#endif	/* AIXV>=3200 */

	(void) sprintf(buf, "%d,%d", major(lf->dev), minor(lf->dev));
	return(buf);
}
