/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

extern struct avl_node *findroute();
extern struct avl_node *best_match();
extern struct avl_node *talloc();
extern struct avl_node *avl_insert();

/* Owner of the route */
#define NO_OWNER	0
#define OSPF_OWNER	1
#define STATIC_OWNER	2
#define DISCARD_OWNER	3

/* Local Proto Defs */
#define PR_OSPF		OSPF_OWNER
#define PR_STATIC	STATIC_OWNER
#define PR_DISCARD	DISCARD_OWNER

/* Preference of routes */
#define OSPF_ROUTE_PREF		8
#define RIP_ROUTE_PREF 		4
#define EGP_ROUTE_PREF 		2
#define STATIC_ROUTE_PREF	1

#define SET_OSPF_OWN(R)		(R)->avl_owner = OSPF_OWNER
#define UNSET_OSPF_OWN(R)	(R)->avl_owner = 0
#define OSPF_IS_OWNER(R)	((R)->avl_owner == OSPF_OWNER)
#define SET_STATIC_OWN(R)	(R)->avl_owner = STATIC_OWNER
#define UNSET_STATIC_OWN(R)	(R)->avl_owner = 0
#define IS_HOST(R) 		(RT_MASK(R) == HOST_NET_MASK)

#define SET_DISCARD_OWN(R)	(R)->avl_owner = DISCARD_OWNER
#define UNSET_DISCARD_OWN(R)	(R)->avl_owner = 0

/*
 * References for the the routing table access
 */

#define ORT_INFO(R)	((R)->ospf_rt_info)
#define ORT_DTYPE(R) 	((R)->ospf_rt_info->dtype)
#define ORT_ETYPE(R) 	((R)->ospf_rt_info->etype)
#define ORT_CHANGE(R) 	((R)->ospf_rt_info->change)
#define ORT_PTYPE(R) 	((R)->ospf_rt_info->ptype)
#define ORT_REV(R) 	((R)->ospf_rt_info->revision)
#define ORT_AREA(R) 	((R)->ospf_rt_info->area)
#define ORT_COST(R)	((R)->ospf_rt_info->cost)
#define ORT_TYPE2COST(R) ((R)->ospf_rt_info->type2cost)
#define ORT_NH(R,I) 	(nh_block[((R)->ospf_rt_info->nh_ndx[I])].nh_addr)
#define ORT_IO_NDX(R,I) (nh_block[((R)->ospf_rt_info->nh_ndx[I])].ifspfndx)
#define ORT_NH_NDX(R,I) ((R)->ospf_rt_info->nh_ndx[I])
#define ORT_NH_CNT(R) 	((R)->ospf_rt_info->nh_cnt)
#define ORT_ADVRTR(R) 	((R)->ospf_rt_info->advrtr)
#define ORT_OSPF_PREF(R) ((R)->ospf_rt_info->preference)
#define ORT_V(R) 	((R)->ospf_rt_info->v)
#define	ORT_ASE_TAG(R)	((R)->ospf_rt_info->ase_tag)

/* 
 * OSPF's routing table structure 
 */

#define OROUTE struct avl_node
#define ROUTENULL ((AVL *) 0)

#define RT_INSERT(DEST,MASK,NDX,CNT,TYPE,INFO)\
		avl_insert(ospf_rtab,\
				(DEST),\
				(MASK),\
				(NDX),\
				(CNT),\
				(TYPE),\
				(INFO))

#define RT_WALK(ROUTINE,A,L) avl_walk(ospf_rtab,ROUTINE,A,L)

#define RT_FIND(DEST) 	best_match(ospf_rtab,(DEST))
#define RT_BALANCE(R) 	(R)->avl_balanced
#define RT_DELETE(R) 	(R)->avl_delete
#define RT_DIRECT(R) 	((R)->avl_direct)	/* True if direct route */
#define RT_PREF(R) 	((R)->avl_pref)	/* Route preference */
#define RT_OWNER(R) 	((R)->avl_owner)/* Route owner */
#define RT_DEST(R) 	((R)->dest)
#define RT_MASK(R) 	((R)->mask)
#define RT_NH_NDX(R,I) 	((R)->avl_nh_ndx[I])
#define RT_NH(R,I) 	(nh_block[((R)->avl_nh_ndx[I])].nh_addr)
#define RT_IO_NDX(R,I) 	(nh_block[((R)->avl_nh_ndx[I])].ifspfndx)
#define RT_NH_CNT(R) 	((R)->avl_nh_cnt)
#define RT_INFO(R) 	((R)->avl_rt_info)
#define RT_OSPF_EXT_DB(R) ((R)->avl_ext_db)
#define RT_DISCARD(R) 	((R)->avl_discard)

/*
 * For area summarization discard routes are needed
 */
#define ADD_DISCARD_ROUTE(NR)		add_discard_route(NR)
#define DELETE_DISCARD_ROUTE(NR)	delete_discard_route(NR)

/*
 * Structures for importing routes from other protocols into ospf
 */
#define MAX_ASE_IMPORT	14		/* Maximum to import at a time */

/*
 * The only routes that shouldn't be imported (except for those that
 *  are filtered) are direct-static routes that have changed to ospf owned
 */
typedef struct ospf_change_entry {
    u_char8 action;		/* Type of action */
    u_char8 etype;		/* Type 1 or 2 external */
    u_char8 proto;		/* Proto importing from (ie STATIC_OWNER) */
    u_char8 done;		/* Flag TRUE for successful completion  */
    OROUTE *route;
    u_long32 faddr;		/* forwarding address */
    u_long32 metric;		/* external metric */
    u_long32 age;		/* age */
    u_long32 tag;		/* external tag */
} OSPF_CHANGE_ENTRY;

typedef struct ospf_ext_block {
    int count;
    OSPF_CHANGE_ENTRY ce[MAX_ASE_IMPORT];
} OSPF_ASE_BLOCK;



/*
 * Notify other routing protols of route addition/modification
 */
#define ospf_export_check(R)	TRUE

#define ORT_UNBIND(R)\
		 {if (ORT_V((R))) DB_ROUTE(ORT_V((R))) = ROUTENULL;\
		 ORT_V((R)) = LSDBNULL;\
		 ZAP(ORT_INFO(R),OMEM_ORT_INFO);\
		 ORT_INFO(R) = ORT_INFO_NULL;}

/* Export OSPF route to other protocols */
#define ospf_export_route(R)



typedef struct static_rt_info {
    u_long32 nexthop;
    u_char8 nh_ndx[MAXNH];
    u_char8 preference;
} STATIC_RT_INFO;

#define STATIC_NH(R)		(R)->static_rt_info->nexthop
#define STATIC_NH_NDX(R)	(R)->static_rt_info->nh_ndx[0]
#define STATIC_PREF(R)		(R)->static_rt_info->preference
#define STATIC_INFO(R)		(R)->static_rt_info


/* OSPF's routing table */
#ifndef UMBC_SIM
struct avl_node *ospf_rtab;
#endif
