/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

void
send_hello(intf, nbrptr)
struct INTF *intf;
struct NBR *nbrptr;
{
    struct OSPF_HDR *pkt;
    struct HELLO_HDR *hello;
    u_long32 to;
    int len = HELLO_HDR_SIZE + OSPF_HDR_SIZE;

    /* if given a pointer to a neighbor, just send to the neighbor */
    struct NBR *nbr;
    struct RHF *rhf;
    struct AREA *area = AREA_PTR(intf);

    OSPF_PKT_ALLOC(pkt, (len + (intf->nbrIcnt * RHF_SIZE)));
    if (pkt == OSPF_HDR_NULL)
	return;
    hello = &(pkt->un.hello);
    hello->netmask = NDX_IP_MASK(intf->ifspfndx);
    hello->DeadInt = htonl(intf->dead_timer);
    hello->HelloInt = htons(intf->hello_timer);
    hello->rtr_priority = intf->pri;	/* if priority	*/
    hello->dr = (intf->dr != NBRNULL) ? intf->dr->nbrip_addr : 0;
    hello->bdr = (intf->bdr != NBRNULL) ? intf->bdr->nbrip_addr : 0;
    hello->options = (area->ext_option == EXT_OPT_NORMAL) ? OPT_E_bit : 0;

    /* build rtrs heard from stuff */
    rhf = &(hello->rhf);
    if (intf->type > NONBROADCAST) {	/* VIRTUAL or PTP */
	if (intf->nbr.state > NATTEMPT) {
	    rhf->rtr = intf->nbr.nbr_id;
	    len += RHF_SIZE;
	}
    } else				/* NBMA or BROADCAST */
	for (nbr = intf->nbr.next; nbr != NBRNULL; nbr = nbr->next) {
	    if (nbr->state > NATTEMPT) {
		rhf->rtr = nbr->nbr_id;
		len += RHF_SIZE;
		rhf++;
	    }
	}

    switch (intf->type) {
	case BROADCAST:
	    to = AllSPFRouters;
	    break;
	case POINT_TO_POINT:
#ifdef IFF_MULTICAST
	    to = AllSPFRouters;
	    break;
#endif
	case VIRTUAL_LINK:
	    to = intf->nbr.nbrip_addr;
	    break;
	case NONBROADCAST:
	    /* check to see if this was a poll timer or response */
	    if (nbrptr)
		to = nbrptr->nbrip_addr;
	    else
		switch (intf->state) {
		    case IWAITING:	/* send to all eligible */
		    case IDrOTHER:	/* also Dr and backup cases */
			if (intf->pri)	/* if elig */
			    to = ALL_ELIG_NBRS;
			else
			    to = DR_and_BDR;
			break;
		    case IDr:
		    case IBACKUP:
			/* if (!nbrptr) - Send to all up nbrs */
			to = ALL_UP_NBRS;
			break;
		}
	    break;
    }
    ospf_txpkt(pkt, intf, O_HELLO, len, to, NOT_RETRANS);
    ZAP_PKT(pkt);
}

/* MODIFIED 5/24/92 - removed send exstart since it's not used */

/*
 *	Send first on nbr list - don't free until ack has been received
 */
void
send_dbsum(intf, nbr, rt)
struct INTF *intf;
struct NBR *nbr;
int rt;					/* retrans flag */
{

    int len;
    struct DB_HDR *dbh;
    struct LSDB_SUM *ds;
    struct OSPF_HDR *pkt;
    struct AREA *area = AREA_PTR(intf);
    u_long32 to;

    if (nbr->dbsum == LSDB_SUM_NULL) {
	ds = dbsum_alloc(OSPF_HDR_SIZE + DB_HDR_SIZE);
	if (ds == LSDB_SUM_NULL)
	    return;
	ds->len = OSPF_HDR_SIZE + DB_HDR_SIZE;
	nbr->dbsum = ds;
    } else {
	ds = nbr->dbsum;
    }

    pkt = (struct OSPF_HDR *) ds->dbpkt;
    dbh = (struct DB_HDR *) & (pkt->un.database);
    len = ds->len;
    dbh->I_M_MS |= nbr->I_M_MS;
    dbh->options = (area->ext_option == EXT_OPT_NORMAL) ? OPT_E_bit : 0;
    dbh->seq = htonl(nbr->seq);
#ifdef NOTDEF
    DONT_ZAP_PKT(pkt);			/* flag not to free */
#endif

#ifdef IFF_MULTICAST
    to =  (intf->type == POINT_TO_POINT) ? AllSPFRouters : nbr->nbrip_addr;
#else
    to = nbr->nbrip_addr;
#endif

    ospf_txpkt(pkt, intf, O_DB_DESCRIPT, len, to, rt);
}

/* MODIFIED 5/24/92 ls req updated to LS_HDRQ */
/*
 *  send_req - build and send a db req packet
 *	     - called by exstart and retrans time; in both cases
 *		we'll just send what hasn't been taken off the req list
 */
void
send_req(intf, nbr, rt)
struct INTF *intf;
struct NBR *nbr;
int rt;					/* retrans flag */
{
    struct LS_HDRQ *r;
    struct OSPF_HDR *pkt;
    struct LS_REQ_PIECE *req;
    struct LS_REQ_HDR *req_hdr;
    int len = OSPF_HDR_SIZE;		/* max len of pkt is INTF_MTU(intf) */
    int intf_mtu = INTF_MTU(intf);
    int hash;
    u_long32 to;

    if (!nbr->reqcnt) {
	return;
    }

    OSPF_PKT_ALLOC(pkt, intf_mtu);
    if (pkt == OSPF_HDR_NULL)
	return;

#ifdef IFF_MULTICAST
    to =  (intf->type == POINT_TO_POINT) ? AllSPFRouters : nbr->nbrip_addr;
#else
    to = nbr->nbrip_addr;
#endif

    req_hdr = &(pkt->un.ls_req);
    req = &(req_hdr->req);

    hash = LS_REQ_HASH_SIZE;
    while (hash--) {
	for (r = nbr->ls_req[hash].ptr[NEXT];
	     r;
	     r = r->ptr[NEXT])
	{
	    req->ls_type = r->ls_hdr.ls_type;
	    /* MODIFIED 6/2/92 */
	    req->ls_type = htonl(req->ls_type);
	    req->ls_id = r->ls_hdr.ls_id;
	    req->adv_rtr = r->ls_hdr.adv_rtr;
	    len += LS_REQ_PIECE_SIZE;
	    if (len + LS_REQ_PIECE_SIZE > intf_mtu) {
		ospf_txpkt(pkt, intf, O_LSR, len, to, rt);
		ZAP_PKT(pkt);
		return;
	    }
	    req++;
	}
    }
    ospf_txpkt(pkt, intf, O_LSR, len, to, rt);
    ZAP_PKT(pkt);

}

/* MODIFIED 5/24/92 add ack updated to LS_HDRQ */


/*
 *  send_ack - build an ack packet from ack list, pass it to send ack
 */
void
send_ack(intf, nbr, qhp)
struct INTF *intf;
struct NBR *nbr;
struct LS_HDRQ *qhp;
{
    struct OSPF_HDR *pkt;
    struct LS_HDRQ *al;
    struct LS_ACK_HDR *ahdr;
    struct LS_HDR *ap;
    u_long32 to;
    int len = OSPF_HDR_SIZE;
    int intf_mtu = INTF_MTU(intf);

    /* First get 'to' handled */

    /* direct ack? */
    if (nbr) {
        to =  (intf->type == POINT_TO_POINT) ? AllSPFRouters : nbr->nbrip_addr;
    } else {
        switch (intf->type) {
            case BROADCAST:
                to = (intf->state == IDr || intf->state == IBACKUP) ?
                    AllSPFRouters : AllDRouters;
                break;
            case NONBROADCAST:
                to = ALL_EXCH_NBRS;
                break;
            case POINT_TO_POINT:
#ifdef IFF_MULTICAST
                to = AllSPFRouters;
                break;
#endif
            case VIRTUAL_LINK:
                to = intf->nbr.nbrip_addr;
                break;
        }
    }

    OSPF_PKT_ALLOC(pkt, intf_mtu);
    if (pkt == OSPF_HDR_NULL)
        return;
    ahdr = (struct LS_ACK_HDR *) & pkt->un.ls_ack;
    ap = &(ahdr->ack_piece);

    while (al = qhp->ptr[NEXT]) {
        if (len + ACK_PIECE_SIZE >= intf_mtu) {
            ospf_txpkt(pkt, intf, O_ACK, len, to, NOT_RETRANS);
            ZAP_PKT(pkt);
            len = OSPF_HDR_SIZE;
            OSPF_PKT_ALLOC(pkt, intf_mtu);
            if (pkt == OSPF_HDR_NULL)
                return;
            ahdr = (struct LS_ACK_HDR *) & pkt->un.ls_ack;
            ap = &(ahdr->ack_piece);
        }

        (*ap) = al->ls_hdr;     /* struct copy */
        ap->ls_age = htons(ap->ls_age);
        len += ACK_PIECE_SIZE;
        ap++;

        DEL_Q(al, TRUE, OMEM_ACKLST);
        if (!nbr) {
            intf->ack_cnt--;
        }
    }

    if (len > OSPF_HDR_SIZE)
        ospf_txpkt(pkt, intf, O_ACK, len, to, NOT_RETRANS);
    ZAP_PKT(pkt);
}

/*
 * send_lsu - go through db_list and send ls update pkt
 */
int
send_lsu(db_list, hash, nbr, intf, rt)
struct LSDB_LIST *db_list;
int hash;
struct NBR *nbr;
struct INTF *intf;
int rt;					/* retrans flag */
{

    struct OSPF_HDR *pkt;
    /* MODIFIED 8/27/92 ll needs to be DBRT_QH */
    struct DBRT_QH *ll;
    struct DBRT_LIST lsdb_list;
    struct LSDB_LIST *dbl;

    union ADV *adv;
    u_long32 to;
    u_long32 *adv_cnt;
    u_short16 adv_age;

    /* max len of pkt is should be INTF_MTU(intf), but could be larger */
    int intf_mtu = INTF_MTU(intf);
    int len = OSPF_HDR_SIZE + LS_UPDATE_HDR_SIZE;
    time_t sec = ospf_get_time();

    if (intf->state == IDOWN)
	return (0);

    new_lsu(&pkt, &adv_cnt, &adv, intf_mtu);
    if (pkt == OSPF_HDR_NULL)
	return (FLAG_NO_BUFS);
    if (nbr != NBRNULL)
#ifdef IFF_MULTICAST
    	to =  (intf->type == POINT_TO_POINT) ? AllSPFRouters : nbr->nbrip_addr;
#else
    	to = nbr->nbrip_addr;
#endif
    else
	switch (intf->type) {
	    case BROADCAST:
		to = (intf->state == IDr || intf->state == IBACKUP) ?
		    AllSPFRouters : AllDRouters;
		break;
	    case POINT_TO_POINT:
#ifdef IFF_MULTICAST
		to = AllSPFRouters;
		break;
#endif
	    case VIRTUAL_LINK:
		to = intf->nbr.nbrip_addr;
		break;
	    case NONBROADCAST:
		to = ALL_EXCH_NBRS;
		break;
	}

    if (hash > 1) {
    	ll = (struct DBRT_QH *) db_list;
    } else {
    	lsdb_list.ptr[NEXT] = (struct DBRT_LIST *) db_list;
    	ll = (struct DBRT_QH *)&lsdb_list;
    }

    while (hash--) {
        /* For each hash bucket (only one unless a retrans) */

        for (dbl = (struct LSDB_LIST *) ll[hash].ptr[NEXT];
	     dbl;
	     dbl = dbl->ptr[NEXT]) 
	{
	    if (dbl->lsdb == LSDBNULL)
	    	adios("dbl->lsdb is NULL");
	    if (rt) {
	        if ((ospf_get_time() - DB_TIME(dbl->lsdb)) <= intf->retrans_timer)
		continue;
	    } else {			/* !rt */
	    	if ((dbl->flood == DONTFLOOD) ||
		    (NO_GUTS(dbl->lsdb))) {
		    continue;
	    	}
	    }
	    if (len + ntohs(LS_LEN(dbl->lsdb)) >= intf_mtu) {
	    	if (*adv_cnt == 0) {	/* we've got a big'un */
		    ZAP_PKT(pkt);
		    new_lsu(&pkt,
			&adv_cnt,
			&adv,
			len + ntohs(LS_LEN(dbl->lsdb)));
		    if (pkt == OSPF_HDR_NULL)
		    	return (FLAG_NO_BUFS);
		    goto big_un;
	    	}
	        *adv_cnt = htonl(*adv_cnt);
	        /* if rt (retrans flag) is true just send one */
	        ospf_txpkt(pkt, intf, O_LSU, len, to, rt);
	        ZAP_PKT(pkt);
	        if (rt)
		    return (0);
	    	new_lsu(&pkt, &adv_cnt, &adv, intf_mtu);
	    	if (pkt == OSPF_HDR_NULL)
		    return (FLAG_NO_BUFS);
	    	len = OSPF_HDR_SIZE + 4;	/* 4 for adv_cnt */
	    }
      big_un:
	    ADV_COPY(DB_RTR(dbl->lsdb), adv, ntohs(LS_LEN(dbl->lsdb)));
	    adv_age = ((ADV_AGE(dbl->lsdb, sec)) + intf->transdly);
	    adv->rtr.ls_hdr.ls_age = (adv_age > MaxAge) ?
                htons(MaxAge) : htons(adv_age);
	    adv = (union ADV *) ((long) adv + ntohs(LS_LEN(dbl->lsdb)));
	    len += ntohs(LS_LEN(dbl->lsdb));
	    *adv_cnt += 1;
    	}

    }
    if (*adv_cnt) {			/* any left to send? */
    	*adv_cnt = htonl(*adv_cnt);
    	ospf_txpkt(pkt, intf, O_LSU, len, to, rt);
    }
    ZAP_PKT(pkt);
    return (0);
}

/*
 * Send ase pkt to all nbrs
 */
void
ase_blast(intf, start, end, sec)
struct INTF *intf;
struct LSDB *start, *end;	/* just send from start to end on ase list */
time_t sec;
{
    u_long32 to;
    struct OSPF_HDR *pkt;
    struct LSDB *db;
    union ADV *adv;
    u_long32 *adv_cnt;
    int len = OSPF_HDR_SIZE + 4;	/* 4 for adv_cnt */
    int intf_mtu = INTF_MTU(intf);

    new_lsu(&pkt, &adv_cnt, &adv, intf_mtu);
    if (pkt == OSPF_HDR_NULL)
	return;
    switch (intf->type) {
	case BROADCAST:
	    to = (intf->state == IDr || intf->state == IBACKUP) ?
		AllSPFRouters : AllDRouters;
	    break;
	case POINT_TO_POINT:
#ifdef IFF_MULTICAST
	    to = AllSPFRouters;
#else
	    to = intf->nbr.nbrip_addr;
	    break;
#endif
	case NONBROADCAST:
	    to = ALL_EXCH_NBRS;
	    break;
    }

    for (db = start; db != LSDBNULL; db = DB_PTR(db)[NEXT]) {
	/* MODIFIED */
  	/* Use sec to see if we just updated this one */
	if (sec != DB_TIME(db)) {
	    if (db == end) break;
	    continue;
	}
	if (len + ntohs(LS_LEN(db)) >= intf_mtu) {
	    *adv_cnt = ntohl(*adv_cnt);
	    ospf_txpkt(pkt, intf, O_LSU, len, to, NOT_RETRANS);
	    ZAP_PKT(pkt);
	    len = OSPF_HDR_SIZE + 4;	/* 4 for adv_cnt */
	    new_lsu(&pkt, &adv_cnt, &adv, intf_mtu);
	    if (pkt == OSPF_HDR_NULL)
		return;
	}
	ADV_COPY(DB_ASE(db), adv, ntohs(LS_LEN(db)));
	adv->ase.ls_hdr.ls_age = htons(intf->transdly);
	adv = (union ADV *) ((long) adv + ntohs(LS_LEN(db)));
	len += ntohs(LS_LEN(db));
	*adv_cnt += 1;
	if (db == end)
	    break;
    }

    if (*adv_cnt) {			/* any left to send? */
	*adv_cnt = ntohl(*adv_cnt);
	ospf_txpkt(pkt, intf, O_LSU, len, to, NOT_RETRANS);
    }
    ZAP_PKT(pkt);
}



/*
 * send_ase - go through my_ase_list and send ase ls update pkt
 *    	    - flood everything between start and end
 */
void
send_ase(start, end, sec)
struct LSDB *start, *end;
time_t sec;
{
    struct AREA *a;
    struct INTF *intf;
    struct NBR *n;
    struct LSDB *db;
    int floodit = 0;

    if (DB_PTR(&ospf.my_ase_list)[NEXT] == LSDBNULL)
	return;

    /* put everything on retrans lists */
    for (a = FirstArea; a < &(ospf.area[ospf.acnt]); a++) {
	if (a->ext_option != EXT_OPT_NORMAL)
	    continue;
	for (intf = a->intf; intf < &(a->intf[a->ifcnt]); intf++) {
	    if ((intf->state < IWAITING) || (!intf->nbrEcnt))
		continue;
	    for (n = FirstNbr(intf); n != NBRNULL; n = n->next)
		if (n->state >= NEXCHANGE) {
		    for (db = start; 
			 db != LSDBNULL;
			 db = DB_PTR(db)[NEXT]) 
		    {
			/* MODIFIED */
			if (sec == DB_TIME(db)) {
			    add_nbr_retrans(n, db);
			    add_db_retrans(db, n);
			}
			if (db == end)
	    		    break;
		    }
		}
	    ase_blast(intf, start, end, sec);
	}
    }
}

#endif				/* PROTO_OSPF */
