/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF
/* MODIFIED 5/24/92 - all routines dealing with db retransmits */
/*
 * Event: new lsa generated and Area's LINK_LIST has pointer to
 *  all neighbors: link_ptr in nbr has to be removed
 *	- search for link pointer and remove it from a neighbor's list
 *	- remove from nbr
 */
int
rem_db_ptr(nbr, db)
struct NBR *nbr;
struct LSDB *db;
{
    struct DBRT_LIST *lp = nbr->retrans[RETRANS_HASH(LS_ID(db))].ptr[NEXT];

    while (lp && lp->lsdb < db) {
        lp = lp->ptr[NEXT];
    }

    if (lp && lp->lsdb == db) {
        DEL_Q(lp, TRUE, OMEM_DBRT);
        nbr->rtcnt--;
        return(TRUE);
    }

    return(FALSE);
}

/*
 * Event: ack has been received and neighbor has pointer to LINK_LIST
 *	  or nbr's state has dropped and are freeing nbr's lsdb list
 *	- search for nbr pointer in lsdb's nbr list and remove it from list
 */
int
rem_nbr_ptr(db, nbr)
struct LSDB *db;
struct NBR *nbr;
{
    struct NBR_LIST *nl;

    if (NO_GUTS(db))
	adios("GUTS BE NULL\n");
    for (nl = DB_RETRANS(db); nl != NLNULL; nl = nl->ptr[NEXT])
	if (nl->nbr == nbr) {
	    REM_Q(DB_RETRANS(db), nl, NUKE, OMEM_NL);
	    return (TRUE);
	}
    return (FALSE);
}

void
ospf_freeq(qhp, type)
struct Q **qhp;
int type;
{
    struct Q *q;

    for (q = *qhp; *qhp != QNULL;) {
	*qhp = q->ptr[NEXT];
	ZAP(((char *) q), type);
	q = *qhp;
    }
}

/* MODIFIED 5/24/92 - all routines dealing with db retransmits */
/*
 *  add_nbr_retrans - add an lsdb ptr to the nbr's retrans list
 */
void
add_nbr_retrans(nbr, db)
struct NBR *nbr;
struct LSDB *db;
{
    struct DBRT_LIST *hp = (struct DBRT_LIST *)&nbr->retrans[RETRANS_HASH(LS_ID(db))];
    struct DBRT_LIST *ll;
    struct DBRT_LIST *lp = hp;

    DBRT_ALLOC(ll);
    ll->lsdb = db;
    nbr->rtcnt++;

    if (!lp) {
        /* First entry on list */
        ADD_Q(hp, ll);
    } else {
        /* Insert in order */
        while (lp->ptr[NEXT] && lp->ptr[NEXT]->lsdb < db) {
            lp = lp->ptr[NEXT];
        }

        ADD_Q(lp, ll);
    }
}

/*
 *  add_db_retrans - add a nbr ptr to the lsdb's retrans list
 */
void
add_db_retrans(db, nbr)
struct LSDB *db;
struct NBR *nbr;
{
    struct NBR_LIST *nl;

    NL_ALLOC(nl);
    nl->nbr = nbr;
    EN_Q((DB_RETRANS(db)), nl);
}


/*
 * rem_db_retrans - clear lsdb's retrans list and free lsdb prtr from neighbors
 */
void
rem_db_retrans(db)
struct LSDB *db;
{
    struct NBR_LIST *nl, *next_nl;

    /* remove from all nbrs' lists */
    for (nl = DB_RETRANS(db); nl != NLNULL; nl = next_nl) {
	next_nl = nl->ptr[NEXT];
	/* remove from nbr */
	rem_db_ptr(nl->nbr, db);
	/* remove from lsdb's nbr list */
	REM_Q((DB_RETRANS(db)), nl, NUKE, OMEM_NL);
    }
    DB_RETRANS(db) = NLNULL;
}

/* MODIFIED 5/24/92 */
/*
 * freeNbrRetrans - remove all lsdb ptrs from nbr retrans list
 */
void
freeNbrRetrans(nbr)
struct NBR *nbr;
{
    struct DBRT_LIST *ll;
    struct DBRT_QH *hp = nbr->retrans;
    int hash = RETRANS_HASH_SIZE;

    /* remove from all nbrs' lists */
    while (hash--) {
        while (ll = hp->ptr[NEXT]) {
	    if (NO_GUTS(ll->lsdb))
	    	adios("GUTS BE NULL in freeNbrRetrans");

            /* remove from lsdb */
            rem_nbr_ptr(ll->lsdb, nbr);

            /* remove from nbr's retrans list */
            DEL_Q(ll, TRUE, DBRT_LIST);
        }
	hp++;
    }
    nbr->rtcnt = 0;
}


/*
 * Free nbr's db summary list
 */
void
freeDbSum(nbr)
struct NBR *nbr;
{
    struct LSDB_SUM *nextd;

    for (nextd = nbr->dbsum; nextd != LSDB_SUM_NULL;) {
	nbr->dbsum = nextd->next;
	DB_ZAP_PKT(nextd);
	ZAP(nextd, OMEM_DBSUM);
	nextd = nbr->dbsum;
    }
    nbr->dbsum = LSDB_SUM_NULL;
    nbr->dbcnt = 0;
}

/* MODIFIED 5/24/92 */
/*
 * Free nbr's ls request list
 */
void
freeLsReq(nbr)
struct NBR *nbr;
{
    int hash;
    struct LS_HDRQ *req, *next;
    struct LS_REQ_QH *req_qh = nbr->ls_req;

    for (hash = 0; hash < LS_REQ_HASH_SIZE; hash++, req_qh++) {
	if (req = req_qh->ptr[NEXT]) {
	    while (req) {
		next = req->ptr[NEXT];
		ZAP(req, OMEM_LS_REQ);
		req = next;
	    }
	    req_qh->ptr[NEXT] = LS_HDRQNULL;
    	}
    }
    nbr->reqcnt = 0;
}

/* MODIFIED 5/24/92 */
/*
 * Remove request from nbr request list
 */
int
nbr_rem_req(nbr, rtr)
struct NBR *nbr;
struct RTR_LA_HDR *rtr;
{
    struct LS_HDRQ *ls_req;
    int hash = LS_REQ_HASH(rtr->ls_hdr.ls_id);
    int ret;

    for (ls_req = nbr->ls_req[hash].ptr[NEXT];
         ls_req != LS_HDRQNULL;
         ls_req = ls_req->ptr[NEXT])
   {
        if ((rtr->ls_hdr.ls_id == ls_req->ls_hdr.ls_id) &&
            (rtr->ls_hdr.adv_rtr == ls_req->ls_hdr.adv_rtr) &&
            (rtr->ls_hdr.ls_type == ls_req->ls_hdr.ls_type)) {

            if (MORE_RECENT(&(ls_req->ls_hdr), &(rtr->ls_hdr), 0)) {
                return (REQ_MORE_RECENT);
            }

            if (SAME_INSTANCE(&(ls_req->ls_hdr), &(rtr->ls_hdr), 0)) {
                ret = REQ_SAME_INSTANCE;
	    } else {
		ret = REQ_LESS_RECENT;
	    }

            nbr->reqcnt -= 1;
            DEL_Q(ls_req, NUKE, OMEM_LS_REQ);
	    return(ret);
        }
    }
    return (REQ_NOT_FOUND);
}

/* MODIFIED 5/24/92 */
/*
 * Free list of acks to be sent to this nbr
 */
void
freeAckList(intf)
struct INTF *intf;
{
    struct LS_HDRQ *ack = intf->acks.ptr[NEXT], *next;

    intf->acks.ptr[NEXT] = LS_HDRQNULL;

    while (ack) {
	next = ack->ptr[NEXT];
	ZAP(ack, OMEM_ACKLST);
	ack = next;
    }
}

/* MODIFIED 5/24/92 */
/* Removed add_ack - is now a macro */

/*
 * Add neighbor to NBMA or BROADCAST intf in sorted order
 */
void
nbr_enq(intf,nbr)
struct INTF *intf;
struct NBR *nbr;
{
    struct NBR *last_nbr;

    for (last_nbr = &(intf->nbr);;last_nbr = last_nbr->next)
    {
        if ( (last_nbr->next == NBRNULL) ||
	     (ntohl(last_nbr->next->nbrip_addr) > ntohl(nbr->nbrip_addr)) )
	{
	    nbr->next = last_nbr->next;
	    last_nbr->next = nbr;
	    break;
        }
    }
    ospf.nbrcnt++;
    ospf.nbr_sb_not_valid = TRUE;
}

/*
 * Add net range to area in sorted order for ease of MIB ness
 */
void
range_enq(area,range)
struct AREA *area;
struct NET_RANGE *range;
{
    struct NET_RANGE *nr;

    for(nr = &(area->nr);;nr = nr->ptr[NEXT])
    {
        if ( (nr->ptr[NEXT] == NRNULL) ||
	     (ntohl(nr->ptr[NEXT]->net) > ntohl(range->net)) )
	{
	    ADD_Q(nr, range);
	    return;
        }
    }
}

/*
 * Add host to area in sorted order for ease of MIB ness
 */
void
host_enq(area,host)
struct AREA *area;
struct OSPF_HOSTS *host;
{
    struct OSPF_HOSTS *h;

    for(h = &(area->hosts);;h = h->ptr[NEXT])
    {
        if ( (h->ptr[NEXT] == HOSTSNULL) ||
	     (ntohl(h->ptr[NEXT]->if_addr) > ntohl(host->if_addr)) )
	{
	    ADD_Q(h, host);
	    return;
        }
    }
}
#endif				/* PROTO_OSPF */
