/*
 Copyright (c) 2003 RIPE

 All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of the author not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
 AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
 DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

 $Id: db.c,v 1.10 2003/04/16 09:00:47 can Exp $
*/

#include "db.h"

static gboolean dbConnected = FALSE;

/*
 * Connect database for the first time
 */
void db_connectDatabase()
{
    static GStaticMutex connMutex = G_STATIC_MUTEX_INIT;

    g_static_mutex_lock(&connMutex);
    if (!dbConnected) {
        DBHOST = (gchar *) getConf("DBHOST");
        DBPORT = atol((gchar *) getConf("DBPORT"));
        DBUSER = (gchar *) getConf("DBUSER");
        DBPASS = (gchar *) getConf("DBPASS");
        DBNAME = (gchar *) getConf("DBNAME");
        if (!mysql_real_connect
            (&mysql, DBHOST, DBUSER, DBPASS, DBNAME, DBPORT, NULL, 0)) {
            local_error("failed to connect database: %s",
                        mysql_error(&mysql));
        } else {
            g_message("connected %s at %s:XXXXX@%s:%ld", DBNAME, DBUSER,
                      DBHOST, DBPORT);
            dbConnected = TRUE;
        }
    }
    g_static_mutex_unlock(&connMutex);
}

/*
 * Execute query
 */
MYSQL_RES *db_doQuery(gchar * query)
{
    static GStaticMutex qryMutex = G_STATIC_MUTEX_INIT;
    MYSQL_RES *result;
    gchar *errstr;

    db_connectDatabase();
    g_static_mutex_lock(&qryMutex);
    if (mysql_real_query(&mysql, query, strlen(query))) {
        errstr = mysql_error(&mysql);
        local_error("error in query %s: %s", query, errstr);
    }
    result = mysql_store_result(&mysql);
    g_static_mutex_unlock(&qryMutex);
    return (result);
}

/*
 * Query result iterator
 */
void db_foreach_query(gchar * query, db_Func func, gpointer user_data)
{
    MYSQL_RES *qryResult;
    MYSQL_ROW row;
    guint fldCnt;

    qryResult = db_doQuery(query);
    if (qryResult != NULL)
        fldCnt = mysql_num_fields(qryResult);
    else
        fldCnt = 0;
    if (qryResult != NULL) {
        while ((row = mysql_fetch_row(qryResult)) != NULL) {
            (*func) (row, fldCnt, user_data);
        }
    }
    mysql_free_result(qryResult);
}

/*
 * Iterator for 1x1 results
 */
void db_getQuery1x1(MYSQL_ROW row, guint fldCount, gpointer user_data)
{
    gchar *str = user_data;

    if (str[0] != 0) {
        return;
    } else {
        if ((str != NULL) && (row[0] != NULL)) {
            strcpy(str, row[0]);
        }
    }
}

/*
 * Execute query, get the first col from first row
 */
void db_execQuery1x1(gchar * query, void *result)
{
    if (result != NULL)
        strcpy(result, "");
    db_foreach_query(query, db_getQuery1x1, result);
}
