/***************************************
  $Revision: 1.4 $

  Utilities (ut). er_UT_errors.h - definition of errors for the utilities mod.

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/


/* step 1 */

typedef enum {
	 LOW_UT_OK = 0,
	 LOW_UT_OUTMEM,
	 LOW_UT_NOMEMLOG,
         LOW_UT_DUPCLOSE
} UT_err_code_t;

/* step 2 */

#define UT_OK		ER_SEV_I + (FAC_UT<<16) + LOW_UT_OK
#define UT_OUTMEM	ER_SEV_F + (FAC_UT<<16) + LOW_UT_OUTMEM
#define UT_NOMEMLOG	ER_SEV_W + (FAC_UT<<16) + LOW_UT_NOMEMLOG
#define UT_DUPCLOSE	ER_SEV_E + (FAC_UT<<16) + LOW_UT_DUPCLOSE

/* step 3 */

#ifdef ER_IMPL

er_list_t UT_mod_err[]={
 { ERDUP(UT_OK),       "OK" },
 { ERDUP(UT_OUTMEM),   "out of memory" },
 { ERDUP(UT_NOMEMLOG), "logging not supported" },
 { ERDUP(UT_DUPCLOSE), "duplicate close detected" },
 ER_LASTTXT
};

#endif /* ER_IMPL */

