/* template.c - your comments here */

#ifndef	lint
static char *rcsid = "$Header: /a/vulcan/xtel/isode/isode-master/others/quipu/uips/de/RCS/video.c,v 8.0 91/07/17 13:18:51 isode Rel $";
#endif

/* 
 * $Header: /a/vulcan/xtel/isode/isode-master/others/quipu/uips/de/RCS/video.c,v 8.0 91/07/17 13:18:51 isode Rel $
 *
 *
 * $Log:	video.c,v $
 * Revision 8.0  91/07/17  13:18:51  isode
 * Release 7.0
 * 
 * 
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


#include <stdio.h>
#include "quipu/util.h"

#define LINES 24
#define COLS  80

static char *revVideoOn;
static char *resetVideo;
static char *cursorMotion = NULLCP;
static char *clLine = NULLCP;
static char *startLine = NULLCP;
static char bp[1024];
static char buffer[1024];
int inverseVideo = TRUE;

char * getenv();
char * tgetstr();
char * tgoto();
char *TidyString();
int lines, cols;
int output();

void
initVideo()
{
char * cp;
char buf[1024];
int ret;

  cp = getenv("TERM");
  if (cp == (char *)NULL)
    cp = "network";
  if ((strcmp(cp, "network") == 0) || (strcmp(cp, "dumb") == 0))
  {
    (void) fprintf(stderr, "\nIf you are able to provide your terminal type, the presentation of information\n");
    (void) fprintf(stderr, "is slightly improved.  If you don't know what sort of terminal type you are\n");
    (void) fprintf(stderr, "using, type RETURN at the next question.\n");
  }
  for (;;)
  {
    if ((strcmp(cp, "network") == 0) || (strcmp(cp, "dumb") == 0))
    {
      lines = LINES;
      cols = COLS;
      (void) printf("\nEnter your terminal type (or l or L to list possible terminal types): ");
      if (gets(buf) == NULLCP)
      {
        clearerr(stdin);
        inverseVideo = FALSE;
	return;
      }
      cp = TidyString(buf);
      if (strlen(cp) == 0) /* default accepted */
      {
        inverseVideo = FALSE;
	return;
      }
    }
    if (lexequ(cp, "l") == 0)
    {
      displayHelp("termtypes");
      cp = "network";
      continue;
    }

    ret = tgetent(bp, cp);
    if (ret == 1)
      break;
    else
    {
      (void) fprintf(stderr, "\nDon't know anything about your terminal type (%s).\n", cp);
      (void) fprintf(stderr, "If your terminal type is unknown to the system, pressing RETURN for\n");
      (void) fprintf(stderr, "terminal type will accept a default terminal type (assumes 24 line screen).\n");
      cp = "network";
    }
  }

  cp = buffer;
  if (inverseVideo == TRUE)
  {
    revVideoOn = tgetstr("mr", &cp);
    resetVideo = tgetstr("me", &cp);
    if ((revVideoOn == (char *)NULL) || (resetVideo == (char *)NULL))
      inverseVideo = FALSE;
  }

  lines = tgetnum("li");
  if (lines == 0)
    lines = LINES;
  cols = tgetnum("co");
  if (cols == 0)
    cols = COLS;

  cursorMotion = tgetstr("cm", &cp);
  if (cursorMotion != NULLCP)
    startLine = tgoto(cursorMotion, 0, lines);
  clLine = tgetstr("ce", &cp);
}

output(c)
char c;
{
  (void) putchar(c);
}

writeInverse(str)
char * str;
{
  if (inverseVideo == TRUE)
    tputs(revVideoOn, 1, output);
  (void) fputs(str, stdout);
  if (inverseVideo == TRUE)
    tputs(resetVideo, 1, output);
}

clearLine()
{
int i;

  if (startLine != NULLCP)
  {
    tputs(startLine, 1, output);
    if (clLine != NULLCP)
      tputs(clLine, 1, output);
    else
      for (i = 1; i < 80; i++)
        (void) putchar(' ');
    tputs(startLine, 1, output);
  }
  else
    (void) putchar('\n');
}
