/**************************************************************
 * hbox.h: header file for widgets and data structures used in
 *          X HDF Browser
 *************************************************************/
/* $Id: hbox.h,v 1.4 93/11/05 10:39:52 gbourhis Exp $ */

#include <stdio.h>
#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>

#include <Xm/ArrowBG.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/DrawnB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/SeparatoG.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>

#ifdef HDF32
#include <hdf/vg.h>

typedef struct DFdesc_str {
  uint16 tag, ref;
  int32  length, offset;
} DFdesc, *DFdesc_ptr;

#else
#include <hdf/df.h>
#include <hdf/vg.h>
#endif

/* -------------------------------------------
   Helpful constants
   -----------------------------------------*/

#define  OTHER 1
#define  VSET  2
#define  SDS   4
#define  RIG   8
#define  PAL   16
#define  ALL   63  /* OTHER | VSET | SDS | RIG | PAL | 32 */
#define  GROUP 62  /* VSET | SDS | RIG | PAL | 32 */

#define  HB_DESC_SZ   512
#define  BUFFER 100

#define MAX_RANK    10 /* max size of rank for calls to DFSDgetdims */

/* ---------------------------------------
   Constants for X sizes 
----------------------------------------*/
#define LIST_WIDTH     375
#define LIST_HEIGHT    220
#define THIN_LIST      270
#define MAX_LIST       16
#define TAG_NAME_WIDTH  220

#define NUM_LIST       4
#define EDGE_OFFSET    10

/* --------------------------------------
   Format for list entries
---------------------------------------*/
#define FORMAT      "%-30s%6d  "

/* return status */
#define HB_OK   0
#define HB_FAIL FAIL
#define YES     TRUE
#define NO      FALSE


/* -------------------------------------
   Macro to raise a widget to the front
--------------------------------------*/
#define RAISE(w) { XtWidgetGeometry Req, Res; \
		   Req.request_mode = CWStackMode; Req.stack_mode = Above; \
		   XtMakeGeometryRequest(w, &Req, &Res); \
		 }

/* -------------------------------------
   Type definitions 
--------------------------------------*/

typedef struct tag_ref_struct {
  uint16 tag;
  uint16 ref;
} tag_ref, *tag_ref_ptr;

typedef struct hb_group {
  int desc;
  int size;
#ifdef HDF32
  tag_ref_ptr ddList;
#else
  DFdi *ddList;
#endif
} HB_GROUP;

typedef struct stack_struct {
  int                 tag;
  int                 ref;
  int                 sel;
  char                name[100];
  char                class[100];
  struct stack_struct *next;
} stack_elem, *stack_ptr;

typedef struct ctxt_struct {
  Widget     hdfShell;
  Widget     listShell;
  Widget     editShell;
  Widget     helpShell;
  Widget     viewShell;
  Widget     list[NUM_LIST];
  Widget     textedit;
  Widget     helpform;
  Widget     editForm;
  Widget     button[10];   /* toggle buttons for what to view */
  Widget     editLabel;
  Widget     helpText;
  Widget     errorBox;
  int        editType;  /* type of thing being edited (label / annotation) */
  int        textChanged; /* the user has modified text in edit window */
  int        firstEdit; /* Text changed callback will be called when text is set originally */
  int        listShellMapped;
  int        editShellMapped;
  int        list_type;
  int        num_desc;         /* ttl number Vgrps et al groups */
  int        num_list[NUM_LIST];        /* # of elements in list */
  int        selection[NUM_LIST];       /* current selected position in list */
  int        hb_numDesc;
  int        hb_numGrp;
  int        hb_backup;
  DFdesc   * hb_desc;
  HB_GROUP * hb_grp;
  int        hb_currDesc;
  int        send;
  int32      f;
  uint16     ptag[6];     /* ptag[n]: parent tag needed to obtain contents of index[n] */ 
  uint16     pref[6];     /* pref[n]: parent ref needed to obtain contents of index[n] */
  uint16     dTag;                 /* tag of descriptor that annotation is for*/
  uint16     dRef;                 /* ref of descriptor that annotation if for*/
  tag_ref_ptr index[NUM_LIST];     /* pointers to arrays of stuff in lists */
  int         sizes[NUM_LIST];     /* max sizes of above arrays */
  char        name[NUM_LIST][100];
  char        class[NUM_LIST][100];
  char        *backup_text;
  char        *hb_file; /* file name */
  stack_ptr   stack;  /* stack of stuff pushed off of edge of lists */
  tag_ref_ptr buffer; /* buffer of tags/refs to be eventually sent */
  int         buf_size;  /* size of the above buffer */
} ctxt, *ctxt_ptr;

#include "hb.x"
