.bp
.so include.n
.EQ
delim $$
.EN
.ie \nH \{\   \" make a help.txt
.pl 800 
.fo ````
.ds B \fP
.nr sp 1
.ls 1\}
.el \{\
.po
.pn 1
.fo ``-B.%-``
.nr sp 0
.ls 2 \}
.nh
.sp 2
.ce
Appendix B
.he ``muTENSOR\ Functions``
.pp
muTENSOR provides a large number of functions which perform many of 
the common tensor operations of interest in General Relativity and
differential geometry. In general, muTENSOR functions are of three 
types: those which perform mathematical operations with indexed 
objects; those which provide utility functions related to indexed
objects; and those which are general functions, of use in a system
not supporting indexed objects.
.pp
The arguments to each function are in general a combination of 
indexed objects and other expressions. An indexed object may be passed 
to a routine in one of two ways: the object name may be given,
or an object reference may be made (which can
include shift operators, and which will generate the necessary object
if it does not exist). When a name is required for the output object, 
the name must be atomic. Since all indexed objects are
auto-quoted (they evaluate to their own name), quoting of these names is
not required. File-name arguments are given as strings.
.br
.in 3
.sp 5
.br
.sp 1
.ne 5 
.br
.ti 0
\*BCHRISTOFFEL1\fP ({name})
.\"." .ix CHRISTOFFEL1\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BCHRISTOFFEL1\fP>
.br
For the current metric this function computes the Christoffel
symbols of the first kind. If <name> is non-FALSE, the symbol is
computed and given that name. If <name> is FALSE, a look-up is
performed to find the currently defined symbol; if none is found the
symbol is computed, with the value of \*BCHRISTOFFEL1\fP [\*BC1\fP] as its name.
This object is symmetric in its first two indices.
.sp 1
.ne 5 
.br
.ti 0
\*BCHRISTOFFEL2\fP ({name})
.\" .ix CHRISTOFFEL2\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BCHRISTOFFEL2\fP>
.br
For the current metric this function computes the Christoffel
symbols of the second kind. If <name> is non-FALSE, the symbol is
computed and given that name. If <name> is FALSE, a look-up is
performed to find the currently defined symbol; if none is found the
symbol is computed, with the value of \*BCHRISTOFFEL2\fP[\*BC2\fP] as its name.
This object has a contravariant first index and is symmetric in its second
and third indices.
.sp 1
.ne 5 
.br
.ti 0
\*BCLEARTMP\fP ()
.\" .ix CLEARTMP\ ()
.br
.ti 0
Returns:\ TRUE
.br
This function removes all temporary indexed objects currently in
the system. These objects have names of the form TMP#<number>. 
\*BCLEARTMP\fP
also resets certain system variables to their initial state.
.sp 1
.ne 5 
.br
.ti 0
\*BCMOD\fP (z)
.\" .ix CMOD\ (z)
.br
.ti 0
Returns:\ complex modulus of z
.br
\*BCMOD\fP
\x`-\n(sp`computes $|z|~\(eq~"sqrt"~(z~\(**~z bar )$.
.sp 1
.ne 5 
.br
.ti 0
\*BCOFACTOR\fP (name1, name2, {transpose-flag})
.\" .ix COFACTOR\ (name1, name2, {transpose-flag})
.br
.ti 0
Returns:\ <name2>
.br
The function  \*BCOFACTOR\fP
computes the cofactor matrix of the
rank-2 object <name1>; the result is assigned to <name2>. This object
has the same symmetries as <name1>. If <transpose-flag> is
non-FALSE, the transpose of the cofactor matrix is placed in <name2>. 
.sp 1
.ne 5 
.br
.ti 0
\*BCOMPLEX\fP (z1, {z2, ..})
.\" .ix COMPLEX\ (z1, {z2, ..})
.br
.ti 0
Returns:\ TRUE
.br
\*BCOMPLEX\fP flags the variables <z1>, <z2>,\ .. as complex.
\*BCONJ\fP uses this flag
to determine which variables are real and which are complex.
.sp 1
.ne 5 
.br
.ti 0
\*BCONJ\fP (z)
.\" .ix CONJ\ (z)
.br
.ti 0
Returns:\ conjugate of <z>
.br
\*BCONJ\fP
\x`-\n(sp`computes $z bar$. Complex quantities are either declared
complex with 
\*BCOMPLEX\fP or involve #I explicitly.
.sp 1
.ne 5 
.br
.ti 0
\*BCOPY\fP (inname, outname)
.\" .ix COPY\ (inname, outname)
.br
.ti 0
Returns:\ <outname>
.br
The indexed object <inname> is copied to the object <outname>.
If <outname> is protected, 
\*BCOPY\fP will fail.
.sp 1
.ne 5 
.br
.ti 0
\*BCOV\fP (name)
.\" .ix COV\ (name)
.br
.ti 0
Returns:\ <name>#CD
.br
This function computes the covariant derivative of <name> and places the
result on <name>'s property list under the key 
\*B||\fP. The name of the derivative
is of the form <name>#CD (unless the covariant derivative is 0). If
<name> is a shifted object, then the covariant derivative of the
parent object is found or computed and shifted as required.
Note that this function is implicitly called
during an evaluation when an index contains the 
\*B||\fP operator.
.sp 1
.ne 5
.br
.ti 0
\*Bd\fP (exp)
.\" .ix d\ (exp)
.br
.ti 0
Returns:\ total derivative of <exp>.
.br
.sp 1
.ie n .ig TR
\*Bd\fP
computes $sum from i\(eq0 to i\(eqn-1 { {\(pd (exp)} over \(pdx sub i } d(x sub i )$
.TR
.el .ig NR
.nf
.ls 1
              n-1
              --  di(exp)
   _d computes >   ------- d(x ).
              --  di(x )     i
              i\(eq0     i
.ls
.fi
.NR
.br
.sp 1
This function is used in constructing line-elements for 
\*BMETRIC\fP. It computes the total derivative of its argument if this is not a
coordinate name.
.sp 1
.ne 5 
.br
.ti 0
\*BDALAMBERT\fP (exp)
.\" .ix DALAMBERT (exp)
.br
.ti 0
Returns:\ d'Alambertian of <exp>
.br
For the current metric
\*BDALAMBERT\fP
computes the d'Alambertian of the given expression. This expression must
be a scalar, or contract to one.
.sp 1
.ne 5 
.br
.ti 0
\*BDATE\fP ()
.\" .ix DATE
.br
.ti 0
Returns:\ time and date string.
.br
.sp 1
.ne 5 
.br
.ti 0
\*BDELTA\fP (name, frame)
.\" .ix DELTA\ (name, frame)
.br
.ti 0
Returns:\ <name>
.br
This function constructs three delta functions in the
frame determined by the integer <frame> (frame \(eq 1, 2, 3, 4, 5, where these
integers are determined by the \*BCONCOV\fP list required).
Normally, this function should not be needed since a complete set of
system delta functions is generated during the system-build. Note that
the above mentioned delta functions are hidden, they do not appear in
the directory listing and cannot be deleted by 
\*BREM\fP. These objects are named d<frame>.
.sp 1
.ne 5 
.br
.ti 0
\*BDET\fP (name, {exp})
.\" .ix DET\ (name, {exp})
.br
.ti 0
Returns:\ determinant of <name>
.br
\*BDET\fP computes the determinant of <name>, which must be a rank-2
object. The determinant is stored on <name>'s property list under the
key 
\*BDET\fP. If <exp> is non-FALSE, then <exp> replaces the stored determinant.
If the object is changed, the value returned by \*BDET\fP still reflects the
previous state of the object; do PUT (<name>, 'DET) to clear the
value and re-run \*BDET\fP.
.sp 1
.ne 5 
.br
.ti 0
\*BDETERM\fP (name, cofactor-name, {transpose-flag})
.\" .ix DETERM\ (name, cofactor-name, {transpose-flag})
.br
.ti 0
Returns:\ <determinant>
.br
\*BDETERM\fP is similar to 
\*BDET\fP, but uses the cofactor matrix computed by a call to 
\*BCOFACTOR\fP to compute the determinant. See  \*BCOFACTOR\fP.
.sp 1
.ne 5 
.br
.ti 0
\*BDIF\fP (name, difvar1, {difvar2, ..})
.\" .ix DIF\ (name, difvar1, {difvar2, ..})
.br
.ti 0
Returns:\ <derivative>
.br
This function is the standard 
\*BDIF\fP function modified to handle
indexed objects. Note that if there is a dependency, the
return value displays as the tensor element with a derivative index.
If the <difvar\x`\n(sp`\*Di\*U> is a member of the current coordinates, it is replaced
by the corresponding index; otherwise it is displayed directly. 
.sp 1
.ne 5 
.br
.ti 0
\*BDIR\fP ({name1, name2, ..})
.\" .ix DIR\ ({name1, name2, ..})
.br
.ti 0
Returns:\ TRUE
.br
This function displays a directory of all
indexed objects currently in existence (or just those named as arguments),
along with certain information
about each, and a summary of total numbers and total top-level nodes
used. 
.sp 1
.ne 5 
.br
.ti 0
\*BDIV\fP (name, {exp})
.\" .ix DIV\ (name, {exp})
.br
.ti 0
Returns:\ divergence of <name>
.br
\*BDIV\fP
computes the divergence of the vector <name>, and returns this
scalar. This function also requires a current tensor metric be defined.
The divergence is stored on <name>'s property list under the
key 
\*BDIV\fP. If <exp> is non-FALSE, then <exp> replaces the stored divergence.
If <exp> is TRUE, EVAL is applied to the stored divergence and the
result replaces it.
.sp 1
.ne 5 
.br
.ti 0
\*BEINSTEIN\fP ({name})
.\" .ix EINSTEIN\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BEINSTEIN\fP>
.br
For the current metric this function computes the Einstein tensor.
If <name> is non-FALSE, the tensor is computed and given that name. If
<name> is FALSE, a look-up is performed to find the currently defined
tensor; if none is found the tensor is computed, with the value of
\*BEINSTEIN\fP[\*BG\fP] as its name. This object is symmetric in its two
covariant indices.
.sp 1
.ne 5 
.br
.ti 0
\*BEVSUBLET\fP (exp)
.\" .ix EVSUBLET\ (exp)
.br
.ti 0
Returns:\ <exp>
.br
This function applies all defined \*BLET\fP rules to <exp> and EVAL's
the result. See also 
\*BLET\fP and \*BSUBLET\fP.
.sp 1
.ne 5 
.br
.ti 0
\*BFRDS\fP (file)
.\" .ix FRDS\ (file)
.br
.ti 0
Returns:\ <file> or FALSE
.br
This function is similar to RDS but takes a string argument as a file name.
.sp 1
.ne 5 
.br
.ti 0
\*BFWRS\fP (file, {reopen})
.\" .ix FWRS\ (file, {reopen})
.br
.ti 0
Returns:\ <file> or FALSE
.br
This function is similar to WRS but takes a string argument as a file name.
.sp 1
.ne 5 
.br
.ti 0
\*BGARB\fP ({file})
.\" .ix GARB\ ({file})
.br
.ti 0
Returns:\ TRUE
.br
\*BGARB\fP compactifies the virtual memory file <file> [<\*BOFFLOADFILE\fP>].
Note that the file will be bigger than is reported by garb.exe because
updates are written onto the end of the file.
.sp 1
.ne 5 
.br
.ti 0
\*BGEODESIC\fP (name, {param})
.\" .ix GEODESIC\ (name, {param})
.br
.ti 0
Returns:\ <name>
.br
For the current metric tensor, this function computes the geodesic
equations of motion, and places them in the matrix <name>. The affine
parameter [\*Bs\fP] may be specified by entering the desired variable as
<param>. Note that the current coordinates are made to depend on this
parameter; and that the control variable DIFVAR [FALSE] is set to this
parameter if it is not already defined. 
.sp 1
.ne 5 
.br
.ti 0
\*BGETCON\fP (con)
.\" .ix GETCON\ (con)
.br
.ti 0
Returns:\ name of connection of type <con>
.br
\*BGETCON\fP
looks into the connection list 
\*BCURRENTCONNECTION\fP to
find the name of the connection of type <con>; 1 -- tensor-frame,
2 -- tensor-spinor, 3 -- frame-spinor.
.sp 1
.ne 5 
.ti 0
\*BGETMET\fP (met)
.\" .ix GETMET\ (met)
.br
.ti 0
Returns:\ metric of type <met>
.br
\*BGETMET\fP looks into the metric list 
\*BCURRENTMETRIC\fP to find
the name of the metric of type <met>.
If <met> \(eq 1, the tensor metric is returned, if
<met> \(eq 2, the frame component metric is returned, if <met>
\(eq 3, the spinor metric is returned, if <met> \(eq 4, the dotted
spinor metric is returned, if <met> \(eq 5, the matrix metric is
returned. If <met> is negative, the corresponding inverse metric
names are returned. 
.sp 1
.ne 5 
.br
.ti 0
\*BGRADEF\fP (name, var\x`\n(sp`\*D1\*U, val\x`\n(sp`\*D1\*U, {var\x`\n(sp`\*D2\*U, val\x`\n(sp`\*D2\*U, ..})
.\" .ix GRADEF\ (name, var1, val1, {var2, val2, ..})
.br
.ti 0
Returns:\ <name>
.br
\*BGRADEF\fP
puts explicit dependencies on <name>. For each of the 
variables <var\x`\n(sp`\*Di\*U>, the derivative of <name> with respect to 
<var\x`\n(sp`\*Di\*U> becomes <val\x`\n(sp`\*Di\*U>, which may be any expression. Those of the
<val\x`\n(sp`\*Di\*U> which are atomic are made to depend on all the <var\x`\n(sp`\*Di\*U>,
so that implicit higher derivatives are not lost. 
.sp 1
.ne 5 
.br
.ti 0
\*BGRADV\fP (name, val)
.\" .ix GRADV\ (name, val)
.br
.ti 0
Returns:\ <name>
.br
The function 
\*BGRADV\fP will assign <val> to <name> and compute and 
assign all the defined gradients of <name> which are atomic.
The symbolic forms may be regained if <name> is quoted,
and <val> is also the quote of <name>. 
.sp 1
.ne 5 
.br
.ti 0
\*BHELP\fP ({name})
.\" .ix HELP\ ({name})
.br
.ti 0
Returns:\ TRUE
.br
\*BHELP\fP provides an on-line help facility. When <name> is that of a
muTENSOR function or subroutine 
\*BHELP\fP will display information
about that routine from this section of the manual. When <name> is
missing, \*BHELP\fP lists all those
routines for which help is available. 
\*BHELP\fP reads the file named under the key 
\*BHELPFILE\fP on the symbol 
\*BHELPLIST#\fP. The pager program displays a page and
pauses with the prompt "--MORE--";
valid responses are Q to quit, U to back-up a page, and any other character
to continue paging forward through the help file. A carriage return is
required to send the response.
.sp 1
.ne 5 
.br
.ti 0
\*BIAS\fP (name)
.\" .ix IAS\ (name)
.br
.ti 0
Returns:\ <name>
.br
This function provides a simple facility for assigning elements to
an indexed object. Only the canonical form of symmetrically related 
elements is considered for assignment. The user is prompted for the
input, which must be terminated by a valid terminator. A input line
consisting solely of a terminator causes a premature exit from the
function. Only indexed objects which are not write-protected may be
assigned.
.sp 1
.ne 5
.br
.ti 0
\*BIM\fP (z)
.\" .ix IM\ (z)
.br
.ti 0
Returns:\ imaginary part of <z>
.br
.sp 1
\x`-\n(sp`\*BIM\fP computes $(z~-~z bar )/ (2~#I)$.
.sp 1
.ne 5 
.br
.ti 0
\*BINDEXED\fP (name)
.\" .ix INDEXED\ (name)
.br
.ti 0
Returns:\ indexed property of <name>
.br
This function determines whether the object <name> is indexed. The
value returned is FALSE if the object is not indexed; otherwise one of
\*BTENSOR\fP, \*BFRAME\fP, \*BSPINOR\fP, \*BMATRIX\fP, \*BMIXED\fP
or \*BSCALAR\fP is returned.
.sp 1
.ne 5 
.br
.ti 0
\*BINVERT\fP (name)
.\" .ix INVERT\ (name)
.br
.ti 0
Returns:\ <name>#INV
.br
\*BINVERT\fP
computes the matrix inverse of the rank-2
object <name>, and gives it the name <name>#INV. The indices
of the inverse are shifted with respect to those of <name>. The
reciprocal of the determinant of the matrix is placed in the
\*BMULTIPLIER\fP
property of the inverse. The inverse matrix has the same
symmetries as <name>
.sp 1
.ne 5 
.br
.ti 0
\*BIPROP\fP (name)
.\" .ix IPROP\ (name)
.br
.ti 0
Returns:\ TRUE
.br
\*BIPROP\fP
displays a pretty printed version of those elements of
<name>'s property list which are specified in the control variable
\*BIPROP#\fP.
This function is also called when the elements of a single object are
being displayed. In this case, if the switch 
\*BIPROP\fP [TRUE] is FALSE, the property list is not displayed.
.sp 1
.ne 5 
.br
.ti 0
\*BKILLING\fP (name, {conf})
.\" .ix KILLING\ (name, {conf})
.br
.ti 0
Returns:\ <name>
.br
This function computes the Killing equations for the current tensor
metric. The equations are placed in the matrix <name>. If the
parameter <conf> is non-FALSE, the conformal Killing equations are
computed, otherwise the conformal factor is taken as zero. The Killing
vector name is the value of 
\*BKILLING\fP [\*Bk\fP], and is declared to be
implicit and to depend on all the current coordinates. 
.sp 1
.ne 5 
.br
.ti 0
\*BLET\fP (exp, replacement)
.\" .ix LET\ (exp, replacement)
.br
.ti 0
Returns:\ <replacement>
.br
\*BLET\fP
defines a rule for replacing <exp> by <replacement> in expressions
passed through 
\*BSUBLET\fP or \*BEVSUBLET\fP. A rule remains in effect
until removed by a call to \*BUNLET\fP. 
\*BLET\fP rules are simple text replacement rules.
.sp 1
.ne 5 
.br
.ti 0
\*BLIE\fP (name, vector)
.\" .ix LIE\ (name, vector)
.br
.ti 0
Returns:\ <name>
.br
This function computes the Lie derivative of <name> in the
direction of <vector>. The result
is placed in the object named <name><vector>#LIE.
.sp 1
.ne 5 
.br
.ti 0
\*BMAPFI\fP (indexed-object)
.\" .ix MAPFI\ (indexed-object)
.br
or
.br
.ti 0
\*BMAPFI\fP (function ({args,..,} indexed-object, {args,..}))
.\" .ix MAPFI\ (function (args, indexed-object, args))
.br
.ti 0
Returns:\ <indexed-object>
.br
\*BMAPFI\fP
maps either the system evaluation function (first form) or
the function indicated by the formal function call (second form) with 
the given arguments. <indexed-object> is either simply the object name or
an object reference with a formal index which may indicate a shift operation.
Integer indices may restrict the application of the mapping to parts of the
object. The multiplier becomes 1 after the mapping is done.
The original value of <name> and its multiplier are saved in the
global variable \*BMAPBACK\fP.
.sp 1
.ne 5 
.br
.ti 0
\*BMETRIC\fP ({line-element}, {name})
.\" .ix METRIC\ ({line-element}, {name})
.br
or
.br
.ti 0
\*BMETRIC\fP (name)
.br
.ti 0
Returns:\ <name> or <\*BMETRIC\fP>
.br
Given the line element <line-element>, this function computes the
corresponding metric tensor and its inverse. If name is not given, the
value of 
\*BMETRIC\fP [\*Bg\fP] is used as the default tensor name; the inverse is
given the name <\*BMETRIC\fP>#INV. If the current metric tensor is undefined,
\*BMETRIC\fP
declares it to be this object. Note that the names of all
geometric objects are stored on the property list of the metric tensor.
.br
The line element is of the form: 
.sp 1
.ne 5 
.ti +3
name: g\x`\n(sp`\*D0\ 0\*U\ 
\*Bd\fP
(x\x`\n(sp`\*D0\*U)^2\ +\ g\x`\n(sp`\*D0\ 1\*U\ 
\*Bd\fP
(x\x`\n(sp`\*D0\*U)\ 
\*Bd\fP
(x\x`\n(sp`\*D1\*U) + ...
.sp 1
.ne 5 
where each x\x`\n(sp`\*Di\*U is one of the current coordinates as defined on the 
global \*BCOORDS\fP list. The operator \*Bd\fP indicates which elements
of the line element are coordinate displacements.
.ti +3
If <line-element> is FALSE, the metric is computed from the frame metric
and the tensor-frame connection. In the second form of use, a previously
computed object <name> will be turned into a metric tensor if it is a
rank-2 covariant tensor. The inverse metric will have the name <name>#INV.
.sp 1
.ne 5 
.br
.ti 0
\*BMKCOORDS\fP (name, {coords})
.\" .ix MKCOORDS\ (name, {coords})
.br
.ti 0
Returns:\ <name>
.br
\*BMKCOORDS\fP
constructs a contravariant vector from the currently
defined coordinates in <name>. The
coordinates which are placed on the property list are either the
current coordinates or the parameter <coords>.
.sp 1
.ne 5 
.br
.ti 0
\*BMKSCALAR\fP (name)
.\" .ix MKSCALAR\ (name)
.br
.ti 0
Returns:\ <name>
.br
\*BMKSCALAR\fP
declares <name> to be an 'indexed' scalar. The value of <name> can
only be accessed with an empty index (eg. Q[]); any previous value of
<name> is moved to the required location when the object is created
and returned to the value 
cell of <name> when the object is deleted via \*BREM\fP. If name is
used with a non-empty index, it must indicate a derivative operation.
.sp 1
.ne 5 
.br
.ti 0
\*BMKTNSR\fP (name, {concov}, {symmetry}, {implicit}, {type})
.\" .ix MKTNSR\ (name, {concov}, {symmetry}, {implicit}, {type})
.br
.ti 0
Returns:\ <name>[<test index>]
.br
This function creates the indexed object <name>, with
indices as indicated by the parameter <concov>. The number of indices
is given by the length of <concov>; an index is contravariant or
covariant if the corresponding element of <concov> is positive, or
negative, respectively. The type of each indice is given by the
numerical value of the elements of <concov>: 1 -- tensor index, 2 --
frame component index, 3 -- spinor index, 4 - dotted spinor index, 5
-- matrix index. If <concov> is FALSE, <name> is partially created,
this is useful when placing a symmetry list on <name>.
.ti +3
The symmetries of the object are given by a non-FALSE <symmetry>,
which consists of a list of independent symmetry lists of the form: 
.sp 1
.ne 5 
.ce
(({C,} l, p\x`\n(sp`\*D1\*U, p\x`\n(sp`\*D2\*U, p\x`\n(sp`\*D3\*U, ..), .. {(H, p\x`\n(sp`\*D1\*U, p\x`\n(sp`\*D2\*U, ..)})
.sp 1
.ne 5 
.ti +3
In each list <l> is the size of the
blocks involved in the symmetry, if <l> is negative then an anti-symmetry
is implied. If <l> is 0, then a trace symmetry is implied but the block
size is 1. The locations of each block in the index are given by the
pointers p\x`\n(sp`\*Di\*U. If the letter C is prepended to the list, it indicates that
a complex conjugate is to be taken when permuting the index. The form
beginning with the letter H specifies a Hermitian symmetry. In this case,
the pointers p\x`\n(sp`\*Di\*U must point to spinor dotted-spinor blocks within the
\*BCONCOV\fP
list of <name>. An example of a symmetry list describing
the Riemann symmetry is '((-1,1,2),(-1,3,4),(2,1,3)). Note that the
internal form of the symmetry list is somewhat different.
.ti +3
If <implicit> is non-FALSE and the name of an equivalent indexed 
object, then any element reference that would otherwise return zero 
(and is not identically zero by virtue of the intrinsic symmetries),
will instead return the value <implicit> as an indexed element; or if
<implicit> is an integer, that integer is returned.
.ti +3
The type of the object may be specified if <type> is non-FALSE. 
.sp 1
.ne 5 
.br
.ti 0
\*BMULTIPLIER\fP (name, {exp})
.\" .ix MULTIPLIER\ (name, {exp})
.br
.ti 0
Returns:\ multiplier of <name>
.br
This function provides access to the 
\*BMULTIPLIER\fP property of <name>.
If <exp> is FALSE, the multiplier is retrieved,
if <exp> is non-FALSE, <exp> replaces the multiplier.
.sp 1
.ne 5 
.br
.ti 0
\*BNOCOMPLEX\fP (z1, {z2, ..})
.\" .ix NOCOMPLEX\ (z1, {z2, ..})
.br
.ti 0
Returns:\ TRUE
.br
\*BNOCOMPLEX\fP
removes the complex flag from the <zi>.
.sp 1
.ne 5 
.br
.ti 0
\*BNODIR\fP (name1, {name2, ..})
.\" .ix NODIR\ (name1, {name2, ..})
.br
.ti 0
Returns:\ TRUE
.br
This function flags each of the indexed objects name\x`\n(sp`\*Di\*U so they will
not appear in a directory listing. Each flagged object is counted into
the statistics however.
.sp 1
.ne 5 
.br
.ti 0
\*BOFF\fP (switch1, {switch2, ..})
.\" .ix OFF\ (switch1, {switch2, ..})
.br
.ti 0
Returns:\ TRUE
.br
\*BOFF\fP sets each given switch to FALSE. The internal switch name is
prepended by a #. See \*BON\fP.
.sp 1
.ne 5 
.br
.ti 0
\*BOFFLOAD\fP (file, name1, {name2, ..})
.\" .ix OFFLOAD\ (file, name1, {name2, ..})
.br
or
.br
.ti 0
\*BOFFLOAD\fP (file, \*BALL\fP)
.\" .ix OFFLOAD\ (file, ALL)
.br
.ti 0
Returns:\ <file>
.br
This function writes the named indexed objects (or all indexed object objects
if \*BALL\fP is present) to the virtual memory file <file> [<\*BOFFLOADFILE\fP>].
All future writes to these objects will also go to the offload file. To 
reload the objects into the system, use \*BONLOAD\fP.
.sp 1
.ne 5 
.br
.ti 0
\*BON\fP (switch1, {switch2, ..})
.\" .ix ON\ (switch1, {switch2, ..})
.br
.ti 0
Returns:\ TRUE
.br
\*BON\fP sets each given switch to TRUE. The internal switch name is
prepended by a #. See \*BOFF\fP.
.sp 1
.ne 5 
.br
.ti 0
\*BONLOAD\fP (name1, {name2, ..})
.\" .ix ONLOAD\ (name1, {name2, ..})
.br
or
.br
.ti 0
\*BONLOAD\fP (\*BALL\fP)
.\" .ix ONLOAD\ (ALL)
.br
.ti 0
Returns:\ TRUE
.br
This function loads the named indexed objects from the virtual memory files
to internal muSIMP memory. The links to the virtual memory files are 
discarded.
.sp 1
.ne 5
.br
.ti 0
\*BPDIF\fP (exp, index)
.\" .ix PDIF\ (exp, index)
.br
.ti 0
Returns:\ formal partial derivative of <exp>
.br
\*BPDIF\fP
provides a method of indicating partial derivatives of an expression with
respect to the current coordinates. <exp> may
contain indexed objects, the index structures will be correctly sorted
out when <exp> is evaluated.
<index> must be enclosed in square brackets. Until involved in an indexed
assignment operation this function remains unevaluated.
.sp 1
.ne 5
.br
.ti 0
\*BPROTECT\fP (name, {protect-flag})
.\" .ix PROTECT\ (name, {protect-flag})
.br
.ti 0
Returns:\ TRUE
.br
This function sets the protection flag on the indexed object
<name>. The protection is checked by other system functions to
determine the legality of deleting or modifying the object. The
allowed values for <protect-flag> are: 
.ti +10
W -- prevent any routine writing to the object,
.ti +10
K -- prevent the object from being deleted,
.ti +10
KW or WK -- combine the above protections,
.ti +10
FALSE -- remove existing protection,
.ti +10
other -- no action.
.sp 1
.ne 5 
.br
.ti 0
\*BRAT\fP (z/w)
.\" .ix RAT\ (z/w)
.br
.ti 0
Returns:\ rationalization of <z/w>
.br
\x`-\n(sp`\*BRAT\fP computes $(z~w bar ) / |w sup 2 |$. Unless <w> involves #I directly this function will
not result in any change to the argument.
.sp 1
.ne 5 
.br
.ti 0
\*BRE\fP (z)
.\" .ix RE\ (z)
.br
.ti 0
Returns:\ real part of <z>
.br
\x`-\n(sp`\*BRE\fP computes $(z~+~z bar ) / 2$.
.sp 1
.ne 5 
.br
.ti 0
\*BRECOVER\fP (file)
.\" .ix RECOVER\ (file)
.br
.ti 0
Returns:\ TRUE
.br
This function looks into the virtual memory file <file> [<\*BOFFLOADFILE\fP>] and
recovers the indexed objects stored there. This is useful if the system has
crashed with objects on disk. There is, of course, no way to recover those
objects which were residing in muSIMP memory at the time of the crash.
.sp 1
.ne 5 
.br
.ti 0
\*BREM\fP (name1, {name2, name3, ..})
.\" .ix REM\ (name1, {name2, name3, ..})
.br
or
.br
.ti 0
\*BREM\fP (\*BALL\fP, {flag})
.\" .ix REM\ (ALL, {flag})
.br
.ti 0
Returns:\ TRUE
.br
\*BREM\fP
attempts to delete from the
system the specified indexed objects. It has two input formats.
.ti +3
In the first format, those arguments which are indexed 
objects and are not delete protected are removed. If any name is not 
that of an indexed object, it is ignored.
.ti +3
In the second format, the atom \*BALL\fP indicates that \*BREM\fP
will attempt to delete all indexed objects whose names are in the 
\*BINAMES\fP list. If
<flag> is non-FALSE, this action is done immediately, without user
intervention. If <flag> is FALSE, then 
\*BREM\fP considers each object in
turn, with the question "Delete? (Y/N/Q/G)". If the user responds with
a Y, the object is deleted. If a Q is entered, then
\*BREM\fP aborts. If G is entered, \*BREM\fP will attempt to delete all
remaining objects, without further query. To guard against
accident, the message "Are you sure?" is displayed, it must be
answered with a Y, or the operation is abandoned. If any response
other than Y, Q, G is entered, it is treated as N, and no action is
taken. 
.ti +3
\*BREM\fP will fail to delete those objects which are delete protected.
.sp 1
.ne 5 
.br
.ti 0
\*BRICCI\fP ({name})
.\" .ix RICCI\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BRICCI\fP>
.br
For the current metric this function computes the Ricci tensor.
If <name> is non-FALSE, the tensor is computed and given that name. If
<name> is FALSE, a look-up is performed to find the currently defined
tensor; if none is found the tensor is computed, with the value of
\*BRICCI\fP [\*BRIC\fP] as its name. The Ricci tensor is symmetric in its
two covariant indices.
.sp 1
.ne 5 
.br
.ti 0
\*BRICCISC\fP ({name}, {exp})
.\" .ix RICCISC\ ({name}, {exp})
.br
.ti 0
Returns:\ Ricci scalar
.br
For the current metric, this function will compute the Ricci
scalar. If <name> is non-FALSE, the scalar is computed and assigned to
that name. If <name> is FALSE, a look-up is performed to find the
currently defined scalar, or if none is found the scalar is computed
and assigned to the value of \*BRICCISC\fP [\*BRICSC\fP].
.ti +3
If <exp> is non-FALSE it replaces the scalar returned by \*BRICCISC\fP
from storage on the property list of the Ricci tensor;
.sp 1
.ne 5 
.br
.ti 0
\*BRIEMANN\fP ({name})
.\" .ix RIEMANN\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BRIEMANN\fP>
.br
For the current metric this function computes the Riemann tensor.
If <name> is non-FALSE, the tensor is computed and given that name. If
<name> is FALSE, a look-up is performed to find the currently defined
tensor; if none is found the tensor is computed, with the value of
\*BRIEMANN\fP [\*BR\fP] as its name. This object is fully covariant and
has the full Riemann symmetry.
.sp 1
.ne 5 
.br
.ti 0
\*BSAVEC\fP (file,\ name1,\ {name2, ..})
.\" .ix SAVEC\ (file,\ name1,\ {name2, ..})
.br
or
.br
.ti 0
\*BSAVEC\fP (file,\ \*BALL\fP, {\ name1, name2, ..})
.\" .ix SAVEC\ (file,\ ALL, {\ name1, name2, ..})
.br
.ti 0
Returns:\ TRUE
.br
\*BSAVEC\fP
provides a facility for saving the components of
selected indexed objects and other non-indexed objects in the disk
file <file>. The components of each object are saved
independently, under the names <name><index>, where <index> is the
compressed index of the element; only explicit elements are saved.
These values cannot be reintroduced in indexed format. As each object
is saved its name is displayed. If the atom \*BALL\fP is present, 
\*BSAVEC\fP saves all indexed objects present in the \*BINAMES\fP
list, as well as
any non-indexed objects whose names follow. To reload the values, RDS
the file.
.ti +3
In addition to the named objects, those system variables whose names
appear in the \*BSAVELIST#\fP list are also saved. File names found
in the list \*BLOADLIST\fP will be read-in when the save file is read in.
If the variable \*BTITLE\fP has a string value, that value is used for
the title of the file; it is echoed when the file is reloaded, along with
the date and time the file was saved.
.sp 1
.ne 5 
.br
.ti 0
\*BSAVEI\fP (file,\ name1,\ {name2, ..})
.\" .ix SAVEI\ (file,\ name1,\ {name2, ..})
.br
or
.br
.ti 0
\*BSAVEI\fP (file,\ \*BALL\fP, {\ name1,\ name2, ..})
.\" .ix SAVEI\ (file,\ ALL, {\ name1,\ name2, ..})
.br
.ti 0
Returns:\ TRUE
.br
\*BSAVEI\fP
provides a facility for saving selected indexed or 
non-indexed objects in the disk file <file>. The objects are saved
in a format that allows them to be reintroduced to the system in
exactly the same form as originally present. As each object is saved
its name is displayed. If the atom \*BALL\fP is present 
\*BSAVEI\fP saves all
indexed objects present in the inames list, as well as any non-indexed
objects whose names follow. To reload the objects, RDS the file; as
each object is restored its name is echoed.
.ti +3
In addition to the named objects, those system variables whose names
appear in the \*BSAVELIST#\fP list are also saved. File names found
in the list \*BLOADLIST\fP will be read-in when the save file is read in. 
If the variable \*BTITLE\fP has a string value, that value is used for
the title of the file; it is echoed when the file is reloaded, along with
the date and time the file was saved.
.sp 1
.ne 5 
.br
.ti 0
\*BSETCON\fP (name, con)
.\" .ix SETCON\ (name, con)
.br
.ti 0
Returns:\ <name>
.br
\*BSETCON\fP
set the current connection of type <con> to be the
object <name> which must be of type \*BCONNECTION\fP.  <con> \(eq 1:
tensor-frame, <con> \(eq 2: tensor-spinor, <con> \(eq 3: frame-spinor. The
preferred \*BCONCOV\fP lists for these connections are: <con> \(eq 1:
(-2 -1), <con> \(eq 2: (-1 3 4), <con> \(eq 3: (-2 3 4).
.sp 1
.ne 5 
.br
.ti 0
\*BSETMET\fP (name)
.\" .ix SETMET\ (name)
.br
.ti 0
Returns:\ <name>
.br
This function sets the current metric to be the object <name>.
<name> must be of type \*BMETRIC\fP, and must be the 
covariant metric. The \*BCONCOV\fP property of <name> determines which
metric <name> becomes. <name> must be covariant in both its indices.
.sp 1
.ne 5 
.br
.ti 0
\*BSHIFT\fP (name[shifted-index])
.\" .ix SHIFT\ (name[shifted-index])
.br
.ti 0
Returns:\ <offspring name>[<index>]
.br
This function is used to raise and lower indices. The
object is entered as a name and index, where the
index is symbolic. The indices to be shifted are marked by placing a
circumflex (^) before each indice as a prefix operator. When the shifted
object is computed it is given a name of the form <name#n1n2..>,
where n1, n2,\ ..  are determined by coverting the \*BCONCOV\fP
difference list 
to a base-16 number, whose digits are the letters of the alphabet. This
name is placed on the property list of the parent object <name> under
the key \*B^\fP. In order that full advantage be taken of symmetries, the
parent object should be the most symmetric representation of the
geometric object. Any future reference to this shifted object is given
in the same format as the input to this function. 
.sp 1
.ne 5 
.br
.ti 0
\*BSUBLET\fP (exp)
.\" .ix SUBLET\ (exp)
.br
.ti 0
Returns:\ <exp>
.br
This function applies all defined \*BLET\fP rules to <exp>.
See also \*BLET\fP and \*BEVSUBLET\fP.
.sp 1
.ne 5 
.br
.ti 0
\*BTRACE\fP (name)
.\" .ix TRACE\ (name)
.br
.ti 0
Returns:\ trace of <name>
.br
\*BTRACE\fP
computes the trace of <name>, which must be a rank-2 object.
.sp 1
.ne 5 
.br
.ti 0
\*BTRANSFER\fP (file, name1, {name2, ..})
.\" .ix TRANSFER\ (file, name1, {name2, ..})
.br
or
.br
.ti 0
\*BTRANSFER\fP (file,\ \*BALL\fP)
.\" .ix TRANSFER\ (file,\ ALL)
.ti 0
Returns:\ <file>
.br
This function moves the named objects from their current virtual memory
file to <file> [<\*BOFFLOADFILE\fP>]. If the object is currently in memory,
\*BTRANSFER\fP acts like \*BOFFLOAD\fP.
.sp 1
.ne 5 
.br
.ti 0
\*BUNLET\fP (exp)
.\" .ix UNLET\ (exp)
.br
.ti 0
Returns:\ <exp>
.br
\*BUNLET\fP removes the \*BLET\fP rule defined for <exp>.
.sp 1
.ne 5 
.br
.ti 0
\*BUPDATE\fP (name)
.\" .ix UPDATE\ (name)
.br
.ti 0
Returns:\ TRUE
.br
\*BUPDATE\fP
writes a copy of the current state of <name>'s property list
to the virtual memory file where <name>'s elements have been placed. This
allows offloaded objects to be recovered in the event of a system crash.
An \*BUPDATE\fP is done automatically when the object is offloaded or
when the object is created with \*BUSEDISK\fP TRUE. This function
is provided to allow the user to reflect any changes made to <name>'s
property list into the virtual memory file.
.sp 1
.ne 5 
.br
.ti 0
\*BWEYL\fP ({name}
.\" .ix WEYL\ ({name}
.br
.ti 0
Returns:\ <name> or <\*BWEYL\fP>
.br
For the current metric this function computes the Weyl conformal
curvature tensor. If <name> is non-FALSE, the tensor is computed and
given that name. If <name> is FALSE, a look-up is performed to find
the currently defined tensor; if none is found the tensor is computed,
with the value of \*BWEYL\fP [\*BC\fP] as its name. This object has the Riemann
symmetry and has four covariant indices.
.EQ
delim off
.EN
