(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Trigonometric Simplifications
:[font = text; inactive; ]
This example comes from Chapter 6.
This package is similar in functionality to the standard package Algebra/Trigonometry.m.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = section; inactive; startGroup; Cclosed; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
Normal Forms
:[font = input; ]
TrigNormal[ Sin[b-a] ]
:[font = input; endGroup; ]
TrigNormal[ Cos[ -a ] ]
:[font = subsection; inactive; startGroup; Cclosed; ]
Expansion of Products and Powers
:[font = text; inactive; ]
To see whether two trigonometric expressions are equal, apply TrigLinear[] to both of them. Here we integrate and differentiate an expression. To see that the result is equal to the integrand takes some effort.
:[font = input; ]
integrand = Sin[x]^2 Cos[x]^2;
:[font = input; ]

Integrate[ integrand, x]
:[font = input; ]
D[%, x]
:[font = text; inactive; ]
Check whether this is equal to the integrand:
:[font = input; ]
TrigLinear[ % ]
:[font = input; endGroup; endGroup; ]
TrigLinear[ integrand ]
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
BeginPackage["RMPackages`TrigSimplification`"]
(*
:[font = input; initialization; ]
*)
TrigNormal::usage = "TrigNormal[e] puts expressions with trigonometric
	functions into normal form."
(*
:[font = input; initialization; ]
*)
TrigLinear::usage = "TrigLinear[e] expands products and powers of trigonometric
	functions."
(*
:[font = input; initialization; ]
*)
TrigArgument::usage = "TrigArgument[e] writes trigonometric functions of multiple
	angles as products of functions of that angle."
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
TrigCanonicalRules = {
	Sin[n_?Negative x_.] :> -Sin[-n x],
	Cos[n_?Negative x_.] :>  Cos[-n x],
	Tan[n_?Negative x_.] :> -Tan[-n x],
	Sin[n_?Negative x_ + y_] :> - Sin[-n x - y] /; OrderedQ[{x, y}],
	Cos[n_?Negative x_ + y_] :>   Cos[-n x - y] /; OrderedQ[{x, y}],
	Tan[n_?Negative x_ + y_] :> - Tan[-n x - y] /; OrderedQ[{x, y}]
}
(*
:[font = input; initialization; ]
*)
TrigLinearRules = {
	Sin[x_] Sin[y_] :> Cos[x-y]/2 - Cos[x+y]/2,
	Cos[x_] Cos[y_] :> Cos[x+y]/2 + Cos[x-y]/2,
	Sin[x_] Cos[y_] :> Sin[x+y]/2 + Sin[x-y]/2,
	Sin[x_]^(m1_Integer?EvenQ) :> Block[{m=Abs[m1]},
	 (2^(-m+1)
	  (Sum[(-1)^(m/2-k) Binomial[m,k] Cos[(m-2k)x], {k, 0, m/2-1}]+
	   Binomial[m,m/2]/2))^Sign[m1] ],
	Cos[x_]^(m1_Integer?EvenQ) :> Block[{m=Abs[m1]},
	 (2^(-m+1)
	  (Sum[Binomial[m,k] Cos[(m-2k)x], {k, 0, m/2-1}] +
	   Binomial[m,m/2]/2))^Sign[m1] ],
	Sin[x_]^(m1_Integer?OddQ) :> Block[{m=Abs[m1]},
	 (2^(-m+1)
	  Sum[(-1)^((m-1)/2-k)
	     Binomial[m,k] Sin[(m-2k)x], {k, 0, (m-1)/2}])^Sign[m1] ],
	Cos[x_]^(m1_Integer?OddQ) :> Block[{m=Abs[m1]},
	 (2^(-m+1)
	  Sum[Binomial[m,k] Cos[(m-2k)x], {k, 0, (m-1)/2}])^Sign[m1] ]
}
(*
:[font = input; initialization; ]
*)
TrigArgumentRules = {
	Sin[x_ + y_] :> Sin[x] Cos[y] + Sin[y] Cos[x],
	Cos[x_ + y_] :> Cos[x] Cos[y] - Sin[x] Sin[y],
	Sin[n_Integer?Positive x_.] :>
		Sum[ (-1)^((i-1)/2) Binomial[n, i] Cos[x]^(n-i) Sin[x]^i,
		    {i, 1, n, 2} ],
	Cos[n_Integer?Positive x_.] :>
		Sum[ (-1)^(i/2) Binomial[n, i] Cos[x]^(n-i) Sin[x]^i,
		    {i, 0, n, 2} ]
}
(*
:[font = input; initialization; ]
*)
SetAttributes[{TrigNormal, TrigLinear, TrigArgument}, Listable]
(*
:[font = input; initialization; ]
*)
TrigNormal[e_] := e /. TrigCanonicalRules
(*
:[font = input; initialization; ]
*)
TrigLinear[e_] :=
	FixedPoint[ Expand[# //. TrigLinearRules /. TrigCanonicalRules]&, e ]
(*
:[font = input; initialization; ]
*)
TrigArgument[e_] :=
	Together[ FixedPoint[ (# //. TrigArgumentRules /. TrigCanonicalRules)&, e ] ]
(*
:[font = input; initialization; ]
*)
End[]
(*
:[font = input; initialization; ]
*)
Protect[TrigNormal, TrigLinear, TrigArgument]
(*
:[font = input; initialization; endGroup; ]
*)
EndPackage[]
(*
^*)