      PROGRAM Y12M
C
C  DOUBLE PRECISION = 64 bit accuracy.
C
C     Last modification by Sami Saarinen, CSC at 26.1.1991
C
C     - packed matrix input (routine READI borrowed from INVPOWER
C       and modified. input file size is now 1.5 times smaller!!
C     - COMMON /BASE1/ and /BASE2/ included (7.2.91 on SUN-4/390S)
C
      PARAMETER (IHA = 5000, NN = 1000000, NN1 = 1000000)
C
      IMPLICIT DOUBLE PRECISION (A-B, G, P, T-V), INTEGER (C, F,
     1 H-N, R-S, Z)
C
      DOUBLE PRECISION A(NN), PIVOT(NN), B(IHA), AFLAG(8)
      INTEGER SNR(NN), RNR(NN1), HA(IHA, 11), IFLAG(10)
      COMMON /BASE1/ A,PIVOT,B,AFLAG
      COMMON /BASE2/ SNR,RNR,HA
C
C  Channel NIN for input.
C  Channel NOUT for output.
C
      DATA NIN /1/, NOUT /6/, NSCR /20/
C
C  Initialization of the parameters.
C
      CALL INITIM(0)
c
      open(NIN,file='y12m.mat',status='old')
C
      CALL INITIM(1)
C
C-old      READ(NIN, *) N, Z
      READ(NIN, *) N
      WRITE(NOUT,*) '*** MATRIX ORDER N =',N
      if (N.GT.IHA) STOP 'N > IHA'
C
C  Initialize the non-zero elements of matrix A in
C  arbitrary order.
C
C-old       READ(NIN, FMT='((3(2I4,F14.0)))') (RNR(K),SNR(K),A(K),K=1,Z)
      CALL READI(NIN,A,B,RNR,SNR,N,Z)

      open(NSCR,file='restart.dat',
     +     status='unknown',form='unformatted')
      write(NSCR) NN
      write(NSCR) N,Z
      write(NSCR) SNR,RNR
      write(NSCR) PIVOT
      write(NSCR) (A(K),K=1,Z)
      write(NSCR) (B(K),K=1,N)

      WRITE(NOUT,*) '*** NUMBER OF NON-ZEROS Z =',Z
      IF (Z.GT.NN/5 .OR. Z.GT.NN1/5) STOP 'Z > NN/5'
C
C  Initialize the components of the right-hand side vector B.
C
C-old      READ(NIN, *) (B(K), K = 1, N)

C
      CALL SHOTIM(1)
C
      CALL INITIM(2)
C
C  Call the subroutine Y12MAF.
C
      CALL Y12MAF(N, Z, A, SNR, NN, RNR, NN1, PIVOT, HA, IHA,
     1 AFLAG, IFLAG, B, IFAIL)
C
      CALL SHOTIM(2)
C
      CALL INITIM(3)
C
C  Print the results.
C
      WRITE(NOUT, 2001) IFAIL
C
      IF (IFAIL .GT. 0) GOTO 5
C
      WRITE(NOUT, 2002)
C
C-old      DO 4 I = 1, N
        WRITE(NOUT, 2003) (I, B(I), I=1,N)
C-old 4    CONTINUE
C
C  Print the auxiliary information about the solution.
C
      WRITE(NOUT, 2004) AFLAG(6)
C
      WRITE(NOUT, 2005) AFLAG(7)
C
      WRITE(NOUT, 2006) AFLAG(8)
C
      WRITE(NOUT, 2007) AFLAG(5)
C
      WRITE(NOUT, 2008) IFLAG(6)
C
      WRITE(NOUT, 2009) IFLAG(7)
C
      WRITE(NOUT, 2010) IFLAG(8)
C
 5    CONTINUE
C
      CALL SHOTIM(3)
C
      CALL SHOTIM(0)
C
      close(NSCR)
      close(NIN)
c
      STOP
C
C  FORMAT-statements.
C
 2001 FORMAT(' The error diagnostic parameter IFAIL is equal to ',
     1 I4)
C
 2002 FORMAT(' The solution vector is given below.')
C
 2003 FORMAT(1P,(4(I5,G15.7)))
C
 2004 FORMAT(/, ' The largest element in the original matrix is ',
     1 1E12.5)
C
 2005 FORMAT(' The largest element found in the elimination ',
     1 1E12.5)
C
 2006 FORMAT(' The minimal (in abs. value) pivotal element ',
     1 1E12.5)
C
 2007 FORMAT(' The growth factor is ', 1PD12.2)
C
 2008 FORMAT(' The number of collections in the row list ', 1I5)
C
 2009 FORMAT(' The number of collections in the column list ', 1I5)
C
 2010 FORMAT(' The largest number of elements found in array A ',
     1 1I9)
C
      END
