
      SUBROUTINE STRSYM(NC,IB,R,SIGSYM)
C
C     APPLY POINT GROUP OPERATIONS TO THE STRESS TENSOR CALCULATED BY
C     SUMMING OVER SPECIAL POINTS.
C     WRITTEN 14-OCT-82 BY OLE HOLM NIELSEN
C     INPUT: SEE SUBROUTINE ROSYM2.
C     STRESS ..... THE STRESS TO BE SYMMETRIZED. ON RETURN STRESS
C                 CONTAINS THE CORRECT STRESS TENSOR.
C
      INTEGER IB(48)
      REAL R(49,3,3),STRESS(3,3),WORK(3,3),SIGSYM(6)
         STRESS(1,1)=SIGSYM(1)
         STRESS(2,2)=SIGSYM(2)
         STRESS(3,3)=SIGSYM(3)
         STRESS(1,2)=SIGSYM(6)
         STRESS(1,3)=SIGSYM(5)
         STRESS(2,1)=SIGSYM(6)
         STRESS(2,3)=SIGSYM(4)
         STRESS(3,1)=SIGSYM(5)
         STRESS(3,2)=SIGSYM(4)
C-----------------------------------------------------------------------
      DO 100 I = 1,3
        DO 100 J = 1,3
C       DIVIDE BY THE NUMBER OF GROUP OPERATIONS
          WORK(I,J) = STRESS(I,J)/FLOAT(NC)
100   CONTINUE
C
      DO 190 I = 1,3
        DO 190 J = 1,3
          STRESS(I,J) = 0.0
C       SUM OVER ROTATIONS
          DO 190 IROT = 1,NC
C         NOTE THAT FROM K290, THE ARRAYS F0 AND V ARE ARRANGED
C         DIFFERENTLY FROM THE ROTATION MATRICES.
            IC = IB(IROT)
            DO 190 K1 = 1,3
              DO 190 K2 = 1,3
                STRESS(I,J) = STRESS(I,J) + 
     &                     R(IC,I,K1) * R(IC,J,K2) * WORK(K1,K2)
190   CONTINUE
      SIGSYM(1)=STRESS(1,1)
      SIGSYM(2)=STRESS(2,2)
      SIGSYM(3)=STRESS(3,3)
      SIGSYM(4)=STRESS(2,3)
      SIGSYM(5)=STRESS(1,3)
      SIGSYM(6)=STRESS(1,2)
      RETURN
      END

