      SUBROUTINE RHSX(JDIM,KDIM,Q,S,PRESS,XY,XYJ,XIT,FLUX)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON/BASE/
     1  JMAX,       KMAX,     JM,          KM,          JBEGIN,   JEND,
     1  KBEGIN,     KEND,     JPLUS(999),  JMINU (999), JLOW,     JUP,
     1  KLOW,       KUP,      PERIDC  ,    NP,          DT,   CP2TIM,
     1  FSMACH,     ALPHA,    GAMMA,       GAMI,        PI,
     1  DIS2X,      DIS2Y,    DIS4X,       DIS4Y,       PHIDT,    
     1  THETAD ,    RESID,    JACDT,       IPRINT,      NPCP,
     1  JTAIL1,     JTAIL2,   NUMITE ,     ISTART,      NSTEPS
      LOGICAL PERIDC  
      COMMON/GRID/DYM,YMAX,XMIN,XMAX,THICK
C
      DIMENSION Q(JDIM,KDIM,4),PRESS(JDIM,KDIM),S(JDIM,KDIM,4)
      DIMENSION XY(JDIM,KDIM,4),XYJ(JDIM,KDIM),XIT(JDIM,KDIM)
      DIMENSION FLUX(JDIM,KDIM,4)
C
C      CENTRAL DIFFERENCING USED IN XI
C     COMPUTE FLUX VECTORS 
C
      DO 200 K=KLOW,KUP
      DO 200 J=JBEGIN,JEND
         R1 = XY(J,K,1)
         R2 = XY(J,K,2)
         R0 = XIT(J,K)
C       RR IS J/RHO
         RR = 1./Q(J,K,1)
         U = Q(J,K,2)*RR
         V = Q(J,K,3)*RR
C
C      R1, R2 ARE EITHER D XI /DX, D ETA/DX, OR D XI /DY, D ETA/DY
C      QS IS EITHER CAP-U OR CAP-V ( CONTRAVARIANT VELOCITIES )
C
         QS = R0 +R1*U + R2*V
C
C      PRESSJ IS PRESSURE / J
C
         PRESSJ= PRESS(J,K)
C
         FLUX(J,K,1)= Q(J,K,1)*QS
         FLUX(J,K,2)= Q(J,K,2)*QS + R1*PRESSJ
         FLUX(J,K,3)= Q(J,K,3)*QS + R2*PRESSJ
         FLUX(J,K,4) = QS*( Q(J,K,4) + PRESSJ) - PRESSJ*R0
C
200   CONTINUE
C
C
      RT0 = - .5*DT / (1. + PHIDT)
      DO 400 N=1,4
      DO 400 J=JLOW,JUP
         JP1 = JPLUS(J)
         JM1 = JMINU (J)
         DO 400 K = KLOW,KUP
            S(J,K,N) = S(J,K,N) + 
     *          RT0*( FLUX(JP1,K,N) - FLUX(JM1,K,N))
400   CONTINUE
C
C
      RETURN
      END
