      SUBROUTINE FILERY(JDIM,KDIM,Q,S,XYJ,COEF2,COEF4,WORK)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/BASE/
     1  JMAX,       KMAX,     JM,          KM,          JBEGIN,   JEND,
     1  KBEGIN,     KEND,     JPLUS(999),  JMINU (999), JLOW,     JUP,
     1  KLOW,       KUP,      PERIDC  ,    NP,          DT,   CP2TIM,
     1  FSMACH,     ALPHA,    GAMMA,       GAMI,        PI,
     1  DIS2X,      DIS2Y,    DIS4X,       DIS4Y,       PHIDT,    
     1  THETAD ,    RESID,    JACDT,       IPRINT,      NPCP,
     1  JTAIL1,     JTAIL2,   NUMITE ,     ISTART,      NSTEPS
      LOGICAL PERIDC  
      COMMON/GRID/DYM,YMAX,XMIN,XMAX,THICK
C
      DIMENSION Q(JDIM,KDIM,4),S(JDIM,KDIM,4),XYJ(JDIM,KDIM)
      DIMENSION COEF2(JDIM,KDIM),COEF4(JDIM,KDIM)
C
      DIMENSION WORK(JDIM,KDIM,3)
C
C   FOURTH ORDER SMOOTHING, ADDED EXPLICITLY TO RHS
C   SECOND ORDER NEAR SHOCKS WITH PRESSURE GRD COEFF.
C
C  ETA DIRECTION
C
C   START DIFFERENCES EACH VARIABLE SEPARATLY
C
      DO 39 N = 1,4
C
      DO 35 K = KBEGIN,KUP
      KPL = K+1
      DO 35 J = JLOW,JUP
      WORK(J,K,1) = Q(J,KPL,N)*XYJ(J,KPL) - Q(J,K,N)*XYJ(J,K)
35    CONTINUE          
C
C   FOR FOURTH ORDER      
C
      DO 36 K = KLOW,KUP-1
      KPL = K+1
      KMI = K-1
      DO 36 J = JLOW,JUP
      WORK(J,K,2) = WORK(J,KPL,1) - 2.* WORK(J,K,1) + WORK(J,KMI,1)
36    CONTINUE
C
C  BOUNDARY
C
      DO 37 J = JLOW,JUP
      WORK(J,KBEGIN,2) = 0.
      WORK(J,KUP,2) = WORK(J,KUP-1,1) - WORK(J,KUP,1)
37    CONTINUE
C
C
C   FORM DISSIPATION TERM
C
      DO 38 K = KBEGIN,KUP
      DO 38 J = JLOW,JUP
       WORK(J,K,3) = (COEF2(J,K)*WORK(J,K,1) - COEF4(J,K)*WORK(J,K,2))
38    CONTINUE
C
C  ADD IN DISSIPATION
C
C
      DTD = DT / (1. + PHIDT)
C
      DO 40 K = KLOW,KUP
      DO 40 J = JLOW,JUP
      S(J,K,N) = S(J,K,N) + (WORK(J,K,3) - WORK(J,K-1,3))*DTD
40    CONTINUE
C
39    CONTINUE
C
      RETURN
      END
