/*
 * $Header: /noc/network/netlog/src/RCS/netlog_indexer.c,v 2.1 1992/05/11 23:41:35 aggarwal Exp $
 */

/*+ 
 ** Main for the 'indexing' programs of the 'netlog'. Manipulates,
 ** rebuilds database.
 **
 ** Can only be run by NETLOGOWNER- this is done since
 ** this program frontends manipulating the entire index database, and
 ** it doesn't make sense for other group members to run this program.
 **
 ** Sets uid/gid to the effective uid/gid in case those bits are set.
 **
 ** Does NOT need any of the Unix commands in the netlog.h file except
 ** for EGREP. Make sure that its in the path, since this program does not
 ** set/alter the PATH etc.
 **
 ** AUTHOR:
 **	Vikas Aggarwal, JvNCnet, vikas@jvnc.net
 **
 **/

/* Copyright 1992 JvNCnet, Princeton University

 Permission to use, copy, modify and distribute this software and its
 documentation for any purpose is hereby granted without fee, provided
 that the above copyright notice appear in all copies and that both
 that copyright notice and this permission notice appear in supporting
 documentation, and that the name of JvNCnet or Princeton University
 not be used in advertising or publicity pertaining to distribution of
 the software without specific, written prior permission.  Princeton
 University makes no representations about the suitability of this
 software for any purpose.  It is provided "as is" without express or
 implied warranty.

 PRINCETON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS. IN NO EVENT SHALL PRINCETON UNIVERSITY BE LIABLE FOR ANY
 DAMAGES WHATSOEVER, INCLUDING DAMAGES RESULTING FROM LOSS OF USE, DATA
 OR PROFITS, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

/*
 * $Log: netlog_indexer.c,v $
 * Revision 2.1  1992/05/11  23:41:35  aggarwal
 * Changes since tackon_dir() was modified to return a malloc-ed ptr.
 *
 * Revision 2.0  1992/05/10  16:31:11  aggarwal
 * Cleaned up and restructured for releasing 'netlog v2.0'
 *
 *
 */


/* */

#ifndef lint
 static char rcsid[] = "$RCSfile: netlog_indexer.c,v $ $Revision: 2.1 $ $Date: 1992/05/11 23:41:35 $" ;
#endif

#include "netlog.h"
#include <pwd.h>			/* For password routines */

static char *mtitle = "INDEXING UTILITIES\0" ;	/* display in menu	*/
static char *options[] = {
    "Create new index file", "Delete an index entry",
    "Print log dates for ticket", "Sort an index file",
    "Update index file", "View an index file", "Quit", ""
  } ;

char *netlog_owner = NETLOGOWNER ;		/* to extract UID */


main(ac, av)
     int ac ;
     char **av ;
{
    extern char *prognm;		/* defined in netlog.h */
    extern char *optarg ;
    extern int optind, opterr ;
    int c ;
    uid_t owner_uid ;			/* uid of NETLOGOWNER */
    struct passwd *passwd ;		/* to extract uid */

    prognm = av[0] ;

    while ( (c = getopt(ac, av, "d")) != EOF)
      switch (c)
      {
       case 'd':
	  debug = 1 ;
	  break ;
       case '?':
       default:
	  fprintf (stderr, "Unknown flag: %c\n", optarg);
	  fprintf (stderr, "Usage: %s [-d (debug)]\n", prognm);
	  exit (1);
	  break ;
      }		/* end switch	*/

    /* Rest should all be command line options (filenames) */
    ac = ac - optind ;	/* update arg count remaining */
    while (optind--)
      ++av ;		/* update argv */

    umask(NETUMASK);	/* default umask for creating new files */

    if ( (passwd = getpwnam(netlog_owner)) != NULL)
      owner_uid = passwd->pw_uid ;
    else
      owner_uid = 0 ;		/* set to root */

#ifdef DEBUG
    if (debug)
    {
	fprintf(stderr,
	      "((%s) Process' ruid/euid/rgid/egid= %d/%d/%d/%d, ",
		prognm, getuid(), geteuid(), getgid(), getegid() );
	fprintf(stderr, "Allowable uid= %d\n", owner_uid ) ;
    }
#endif

    /*
     * If the owner of this program is running, then set uid/gid to
     * the effective one. Else exit (only the owner can run this program).
     */

    if ( owner_uid !=  getuid() )
    {
	fprintf(stderr, "ERROR: Only uid %d (user %s) can run %s\n",
		owner_uid, netlog_owner, prognm);
	exit (1) ;
    }
    else
    {
	printf( "Setting real & effective uid/gid to %d/%d\n",
	       geteuid(), getegid() );
	sleep (1) ;				/* so person can read,,, */
    }

    setreuid(geteuid() , geteuid()) ;		/* set to effective uid */
    setregid(getegid() , getegid()) ;		/* and gid in case bits set */
    
    Indexfile =  tackon_dir(ETCDIR, INDEXFILE) ;
    Prevtkt = tackon_dir(ETCDIR, PREVTKT) ;

    for (; ;)
    {
	char c ;				/* desired selection	*/

	c = menu(options, mtitle, "Enter indexing option: ") ;
	controller(c, ac, av);
	printf ("\n\t%s: Hit RETURN to continue: ", prognm);
	c = getchar();
    }						/* end for		*/
}						/* end  main		*/

/*+ 			controller
** FUNCTION:
** 	Decides which routine to call depending on main menu
** selection.
**/

controller(c, ac, av)
     char c, **av;
{
    int tkt, fd, logdate ;
    char *reply, junk[2] ;
    char cwd[BUFSIZ] ;

    getwd(cwd) ;
    printf("(%s): Current working directory is: '%s'\n", prognm, cwd) ;

    switch (toupper(c))
    {
     case 'C':				/* create index file with all... */
	printf("\n\n\t\t%s\n\n", "** Create Index **");
	build_new_index_file(ac, av) ;	/* .. cmd line file names  */
	break ;

     case 'D':				/* delete an entry	*/
	printf("\n\n\t\t%s\n\n", "** Delete Entry **");
	reply = get_reply("Enter ticket to delete", (char *)NULL,
			  C_DIGIT);
	sscanf(reply, "%d", &tkt);	/* get ticket number	*/
	tkt = tkt % MAXTKT ;
	printf("Delete ticket number %d [confirm]: ", tkt);
	gets(junk);
	if (*junk != NULL)
	  break ;
	reply = get_reply("Enter index file name", Indexfile,
			  C_DIGIT | C_ALPHA | C_PUNCT);
	if ((fd = open(reply, O_RDWR)) < 0)
	  perror(reply);
	else
	  delete_index_entry(tkt, (char *)NULL, fd);
	close(fd);
	break;

     case 'P':				/* Print one ticket's info	*/
	printf("\n\n\t\t%s\n\n", "** Print Ticket Info **");
	reply = get_reply("Enter ticket number", (char *)NULL,
			  C_DIGIT);
	sscanf(reply, "%d", &tkt);
	print_ticket_entry(tkt, Indexfile);
	break ;

     case 'S':				/* sort index file	*/
	printf("\n\n\t\t%s\n\n", "** Sort Index File **");
	sort_index_file((char *)NULL) ;
	break ;

     case 'U':			       	/* Update index file	*/
	printf("\n\n\t\t%s\n\n", "** Update Index File **");
	update_index_file(ac, av);
	break ;

     case 'V':				/* view an index file	*/
	printf("\n\n\t\t%s\n\n", "** View Index File **");
	print_index_file((char *)NULL) ;
	break ;

     case 'Q':				/* quit			*/
	done();

     default:
	fprintf(stderr, "Uh, oh !! Messed up option - %c", c) ;
	break ;
    }						/* end  option		*/
}					   	/* end  controller	*/

/*+ 		done
** FUNCTION:
**   	Clean up before quitting, and print out the cookie.
**/
done()
{
    exit (0);
}

