/*
 * $Header: /noc/network/netlog/src/RCS/list_open_tkts.c,v 2.0 1992/05/10 16:28:26 aggarwal Exp $
 */

/* Copyright 1992 JvNCnet, Princeton University */

/*+ 
 ** FUNCTION:
 ** 	Display the list of open tickets OPENTKTS in NETLOG.
 **/

/*
 *	$Log: list_open_tkts.c,v $
 * Revision 2.0  1992/05/10  16:28:26  aggarwal
 * Cleaned up and restructured for releasing 'netlog v2.0'
 *
 *
 * Revision 1.1  90/03/01  14:31:58  aggarwal
 * Initial revision
 * 
 */

#ifndef lint
  static char rcsid[] = "$RCSfile: list_open_tkts.c,v $ $Revision: 2.0 $ $Date: 1992/05/10 16:28:26 $" ;
#endif

#include "netlog.h"

list_open_tkts()
{
    char *reply, syscmd[MAXLINE];

    if (access(Opentickets, R_OK) == -1)	/* cannot read */
    {
	perror(Opentickets);
	return(-1);
    }

    printf("\n\n\t\t%s\n\n", "** Display Open Tickets **");

    reply = get_reply("Enter output file name", "/dev/tty",
		      C_DIGIT | C_ALPHA | C_PUNCT);

    if (strcmp(reply, "/dev/tty") == 0)
      sprintf(syscmd, "%s %s | %s\0", CAT, Opentickets, MORE);
    else
    {
	if (create_blank_file(reply, 0666) == -1)
	  return (-1);
	sprintf(syscmd, "%s %s %s\0", COPY, Opentickets, reply);
    }

    if (debug)
      printf("(debug): system(%s)\n", syscmd) ;
    else
      return (system(syscmd)) ;

}					/* end: list_open_tkts	*/
