/**** PostScript interface for network map program.  ****/

/*	Copyright (C) 1989, 1990, 1991 Massachusetts Institute of Technology
 *		Right to copy granted under the terms described
 *		in the file Copyright accompanying this distribution.
 */


/* This is the PostScript interface for the program that displays network
 * connectivity.
 */

#include "map.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#ifdef EDIT_HISTORY

Nbr Date	Author		Description
--- ----	------		-----------
 3  20-Feb-89	M. A. Patton	First release version.
 3A  1-Mar-89	M. A. Patton	Changed misnamed x_pos to h_pos, made copy loop
				ignore comment lines and compress multiple
				spaces.  Removed obsolete PSDraw
 3B  4-Mar-89	M. A. Patton	Made filled in rectangles use macro.  Don't use
				precomputed vertices, too X10 dependant.  Is
				now independant of "Vertex" data.
 4  23-Mar-89	M. A. Patton	Added comment at end of common header.
 4A 23-Mar-89	M. A. Patton	Cosmetics from report by Chris Tengi.
 4B 29-Jun-89	M. A. Patton	Added use of find_file for PS header.  Change
				network label drawing a bit (still uses X)
 4C 22-Aug-89	C. J. Tengi	Added return(val) to end of PSopen for hc on RT
				which doesn't return value of last statement.
 4D 24-Jan-90	M. A. Patton	Place network labels "intelligently".
 4E 10-Feb-90	M. A. Patton	PSTextLL now surplus.
 5   9-Aug-90	M. A. Patton	Check AlreadyPlaced flags in case a redisplay
				hasn't happened (tty mode or load/write in a
				take file).
 5A 11-Mar-91	B. Margolin	Added PS_DrawTitle and PSTextCC.  Added use of
				PS_DrawTitle from Hardcopy.  Added comments at
				beginning of each type of object.
 5B 13-Mar-91	B. Margolin	Added support for DEFAULT_LIB_PATH configuration
				option.
 5C  1-Apr-91	Mike Patton	Added displaying of nets with no addresses to
				get key shown.
 5D 19-Apr-91	Mike Patton	Added point-to-point nets.

#endif


#define PS_HEADER_FILE_NAME	"map"

#ifndef DEFAULT_LIB_PATH
#define DEFAULT_LIB_PATH "/usr/lib/nets/"
#endif

char *ps_path[] = {
    "",
    "nets/",			/* Really need ~/ here but no globbing yet */
    DEFAULT_LIB_PATH,
    NULL };
char *ps_ext[] = {
    ".PS.header",
    "",
    NULL };

/* Sort of a hack for now... */
extern int ps_frame;
/**** Postscript output ****/

typedef struct _PSfile
{   FILE *fd;
    int h_pos;
} PSfile;

Hardcopy(fname)
char *fname;
{   register Network *np;
    register Machine *hp;
    register Title *tp;
    PSfile *file, *PSopen();
    FILE *header;
    int c;

    if ( (file=PSopen(fname)) == NULL)
    {	fprintf(stderr,"Can't open PostScript file %s.\n",fname);
	return;
    }
    if ( (header=find_file(PS_HEADER_FILE_NAME, ps_path, ps_ext, NULL)) == NULL)
    {	fprintf(stderr, "Can't get header file for PostScript output \"%s\".\n",
		PS_HEADER_FILE_NAME);
	return;
    }
    /* Copy the header file, but skip extraneous stuff */
    c = getc(header);
    while (c != EOF)
    {	PSputchar(file,c);
	if (isspace(c))
	{   while (c=='\n')
	    {	c = getc(header);
		if (c=='%')
		    while ( c!='\n' && c!=EOF )
			c=getc(header);
	    }
	    while (isspace(c) && c!='\n')
		c = getc(header);
	}
	else
	    c = getc(header);
    }
    PScomment(file,"End of common header file.");
    PSputint(file,display_height);
    PSputword(file,"SetHeight");
    PSputint(file,display_width);
    PSputword(file,"SetWidth");
    PSputword(file,"Begin");
    if (ps_frame)
	PSputword(file,"stroke");
    else
	PSputword(file,"newpath");
    PSbreak(file);
    PScomment(file,"Networks");
    MAPCAR (np,net_base)
	PS_DrawNetwork(file,np);
    PScomment(file,"Machines");
    MAPCAR (hp,machine_base)
	PS_DrawMachine(file,hp);
    PScomment(file,"Titles");
    MAPCAR (tp,title_base)
        PS_DrawTitle(file,tp);
    PSputword(file,"showpage");
    PSputstr(file,"\n%%End\n");
    PSclose(file);
}
/****	High level functions: Draw a Network.	****/

PS_DrawNetwork(file,np)
PSfile *file;
register Network *np;
{   if (! (np->geo_flag&AlreadyPlaced) )
    {	PlaceNetwork(np);
	if (! (np->geo_flag&AlreadyPlaced) )
	    return;
    }
    PScomment(file,np->name);
    PSputword(file,"save");
    if (np->geo_flag&P_P_NET)
	PS_DrawP2Pnetwork(file,np);
    else
	PS_DrawFlatNetwork(file,np);
    PSputword(file,"restore");
}


static
PS_DrawFlatNetwork(file,np)
PSfile *file;
register Network *np;
{   register int drawn = FALSE;
    register AddressList *ap;
    int a, b, t;

    a = np->side1;
    b = np->side2;
    t = 3;
    MAPCAR (ap,np->addresses)
    {	if ( (show_chaos && ap->address.class==AF_CHAOS) ||
	     (show_IP && ap->address.class==AF_INET) )
	{   if (!drawn)
	    {	if (np->vertical)
		    PSRect(file,a,np->y1,b,np->y2,0.0);
		else
		    PSRect(file,np->x1,a,np->x2,b,0.0);
		drawn = TRUE;
	    }
	    if (np->vertical)
		PSRect(file,a-t,np->y1,a,np->y2,
			(ap->address.class==AF_INET)  ?
				  .3/*IP_pixel*/ : .6/*CHAOS_pixel*/ );
	    else
		PSRect(file,np->x1,a-t,np->x2,a,
			(ap->address.class==AF_INET)  ?
				  .3/*IP_pixel*/ : .6/*CHAOS_pixel*/ );
	    {int tmp=a-t;a=b;b=tmp;}
	    t = -t;
	}
    }
    if ( !drawn && np->addresses==NULL)
    {	if (np->vertical)
	    PSRect(file,a,np->y1,b,np->y2,0.0);
	else
	    PSRect(file,np->x1,a,np->x2,b,0.0);
	drawn = TRUE;
    }
    if (drawn)
    {	if (np->vertical)
	    PSTextCL(file,(a>b?a:b)+3,np->y_pos,np->name);
	else
	    PSTextLC(file,np->x_pos,(a<b?a:b)-3,np->name);
    }
}


/**	Helper routine for above, filled rectangle.	**/


static
PSRect(fd,x1,y1,x2,y2,level)
PSfile *fd;
int x1,y1,x2,y2;
float level;
{   PSputword(fd,"save");
    PSputint(fd,x1);
    PSputint(fd,y1);
    PSputint(fd,x2);
    PSputint(fd,y2);
    PSputfloat(fd,level);
    PSputword(fd,"Rect");
    PSputword(fd,"restore");
    if (fd->h_pos > 50) PSbreak(fd);
}



static
PS_DrawP2Pnetwork(file,np)
PSfile *file;
register Network *np;
{   PSputint(file,np->x1);
    PSputint(file,np->y1);
    PSputint(file,np->x2);
    PSputint(file,np->y2);
    PSputint(file,np->width);
    PSputword(file,"PP");
}
/****	High level functions: Draw a Machine.	****/



PS_DrawMachine(file,hp)
PSfile *file;
register Machine *hp;
{   register int drawn = FALSE;
    register AddressList *ap;
    Host *hst = hp->host;

    if (! (hst->geo_flag&AlreadyPlaced) )
	PlaceHost(hst);
    PScomment(file,hp->name);
    PSputword(file,"save");
    MAPCAR (ap,hst->addresses)
    {	if ( (show_chaos && ap->address.class==AF_CHAOS) ||
	     (show_IP && ap->address.class==AF_INET) )
	{   if (!drawn)
	    {	PSText(file, hp->name);
		PSputint(file, hst->x_pos);
		PSputint(file, hst->y_pos);
		PSputword(file, "Host");
		drawn = TRUE;
	    }
	    if (ap->net_p != NULL)
	    {	if (ap->net_p->vertical)
		    if (ap->net_p->x_pos < hst->x_pos)
		    {   PSputint(file,ap->net_p->side2);
			PSputword(file,"TapL");
		    }
		    else
		    {   PSputint(file,ap->net_p->side1);
			PSputword(file,"TapR");
		    }
		else
		    if (ap->net_p->y_pos < hst->y_pos)
		    {   PSputint(file,ap->net_p->side2);
			PSputword(file,"TapU");
		    }
		    else
		    {   PSputint(file,ap->net_p->side1);
			PSputword(file,"TapD");
		    }
	    }
	}
    }
    PSputword(file,"restore");
}
/**** High level functions: Draw a Title.     ****/



PS_DrawTitle(fd, tp)
PSfile *fd;
register Title *tp;
{   if (! (tp->geo_flag&AlreadyPlaced) )
        PlaceTitle(tp);
    if (*tp->text != '\0')
        PSTextCC(fd, tp->x_pos, tp->y_pos, tp->text);
    if ( (WidthValue|HeightValue)&tp->geo_flag )
    {   PSputint(fd, tp->x1);
	PSputint(fd, tp->y1);
	PSputint(fd, tp->x2);
	PSputint(fd, tp->y2);
	PSputword(fd, "Box");
	PSputword(fd, "stroke");
    }
    if (fd->h_pos > 50) PSbreak(fd);
}

/****	High level Postscript operations, text.	****/



/* Position text with Center Left coord. */
static
PSTextCL(fd,x,y,str)
PSfile *fd;
int x, y;
char *str;
{   PSText(fd,str);
    PSputint(fd,x);
    PSputint(fd,y);
    PSputword(fd,"TextCL");
    if (fd->h_pos > 50) PSbreak(fd);
}


/* Position text with Lower Center coord. */
static
PSTextLC(fd,x,y,str)
PSfile *fd;
int x, y;
char *str;
{   PSText(fd,str);
    PSputint(fd,x);
    PSputint(fd,y);
    PSputword(fd,"TextLC");
    if (fd->h_pos > 50) PSbreak(fd);
}


/* Position text with Center Center coord. */
static
PSTextCC(fd,x,y,str)
PSfile *fd;
int x, y;
char *str;
{   PSText(fd,str);
    PSputint(fd,x);
    PSputint(fd,y);
    PSputword(fd,"TextCC");
    if (fd->h_pos > 50) PSbreak(fd);
}


static
PSText(fd,str)
PSfile *fd;
char *str;
{   PSseperate(fd,strlen(str)+3);
    PSputchar(fd,'(');
    PSputstr(fd,str);
    PSputchar(fd,')');
}

/****	Low level PostScript output.	****/



static PSfile *
PSopen(cp)
char *cp;
{   PSfile *val;

    if ( (val=(PSfile *)malloc(sizeof(PSfile))) == NULL) return (NULL);
    if ( (val->fd=fopen(cp,"w")) == NULL)
    {	free(val);
	return (NULL);
    }
    val->h_pos = 0;
    return (val);
}

static
PSclose(f)
PSfile *f;
{   fclose(f->fd);
    free(f);
}




static
PSputword(fd,str)
PSfile *fd;
char *str;
{   PSseperate(fd,strlen(str));
    PSputstr(fd,str);
}



static
PScomment(f,cp)
PSfile *f;
char *cp;
{   if (f->h_pos != 0)
	PSbreak(f);
    PSputstr(f,"% ");
    PSputstr(f,cp);
    PSputchar(f,'\n');
}


static
PSputint(fd,i)
PSfile *fd;
int i;
{   int p = 10;

    PSseperate(fd,6);
    if (i<0)
    {	PSputchar(fd,'-');
	i = -i;
    }
    while (p<=i)
	p *= 10;
    while ( (p /= 10) > 0)
    {	PSputchar(fd, (i/p)+'0');
	i -= (i/p)*p;
    }
}

static
PSputfloat(fd,n)
PSfile *fd;
float n;
{   char buff[INPUT_LEN];

    sprintf(buff,"%f",n);
    PSputword(fd,buff);
}



static
PSputstr(fd,str)
PSfile *fd;
char *str;
{   while (*str)
	PSputchar(fd,*str++);
}


static
PSseperate(f,d)
PSfile *f;
int d;
{   if (f->h_pos+d > 78)
	PSbreak(f);
    else
	if (f->h_pos != 0) PSputchar(f,' ');
}


static
PSbreak(f)
PSfile *f;
{   putc('\n',f->fd);
    f->h_pos = 0;
}

static
PSputchar(f,c)
PSfile *f;
char c;
{   putc(c,f->fd);
    if (c == '\n')
	f->h_pos=0;
    else
	f->h_pos++;
}
