/****	Routines for manipulating the debug status.	****/

/*	Copyright (C) 1989, 1990 Massachusetts Institute of Technology
 *		Right to copy granted under the terms described
 *		in the file Copyright accompanying this distribution.
 */


/* These are the data structures and routines for symbolic manipulation
 * of the debugging control.
 */

#include "map.h"

#include "debug.h"

#ifdef EDIT_HISTORY

Nbr Date	Author		Description
--- ----	------		-----------
 1   6-Apr-89	M. A. Patton	First written.
 1A 29-Jun-89	M. A. Patton	Added "files".
 1B  8-Jul-89	M. A. Patton	Added "events", "state".
 1C 12-Sep-89	M. A. Patton	Made dbg_lookup do partial match;
				added heading to help message;
				added "connectivity".
 1E 24-Jan-90	M. A. Patton	Added ICMP.
 5  15-Jun-90	M. A. Patton	Added SNMP.
 5A  2-Jul-90	M. A. Patton	Added conditionals so ineffective flags don't
				get listed.

#endif
/**** Documentation ****/


#ifdef DOCUMENTATION


Needs to be written!!!!


#endif
/****	Data structures	****/



/* Debugging flag, each bit represents some kind of action that should be
 * reported on stderr.
 */
long dbg_flag = 0;



char *dbg_help_message[] = {
    "Use the debug command to turn on debugging flags and the undebug command",
    "to turn them off.  The names of the flags are:",
    NULL
};


/* Table of symbolic translations.
 */
struct _dbg_type {
    char *name;
    long val;
    char *desc;
} dbg_tbl[] = {
    { "all", -1, "All possible" },
#ifdef HAVE_X_WINDOWS
    { "color", DBG_COLOR, "Color determination" },
    { "events", DBG_EVENTS, "X display events" },
#endif
    { "files", DBG_FILES, "File data warnings" },
/* This one's actually most useful in command line */
    { "state", DBG_STATE, "Major state happenings" },
    { "ICMP", DBG_ICMP, "ICMP (ping) packet exchanges" },
#ifdef SNMPDK
    { "SNMP", DBG_SNMP, "SNMP operations" },
#endif
    { "connectivity", DBG_CONNECTIVITY, "Connectivity information" },
    { NULL, 0, NULL },
};
/****	Debugging on/off	****/



struct _dbg_type *
dbg_lookup(cp)
char *cp;
{   struct _dbg_type *p;
    struct _dbg_type *result=NULL;

    /* This should really do better matching, but it needs
     * something like cmd processor to do it right.
     */
    for (p=(&dbg_tbl[0]);p->name!=NULL;p++)
    {	char *tp1=p->name;
	char *tp2=cp;
	while (*tp2!='\0'&&upcase(*tp1)==upcase(*tp2)) { tp1++; tp2++; }
	if (*tp2=='\0')
	{   if (result!=NULL) return (NULL); /* duplicate */
	    result = p;
	}
    }
    return (result);
}



debug_help()
{   struct _dbg_type *p;
    char **cpp;

    for (cpp=dbg_help_message;*cpp!=NULL;cpp++)
	printf("%s\n",*cpp);
    for (p=(&dbg_tbl[0]);p->name!=NULL;p++)
	printf("   %-15s%s\n",p->name,p->desc);
    return (TRUE);
}



debug_list()
{   struct _dbg_type *p;
    long i = dbg_flag;
    /* !!!! This help should be a little better !!!! */
    for (p=(&dbg_tbl[0]);p->name!=NULL;p++)
	if (p->val == ( p->val & i ))
	{   i &= ~p->val;
	    printf("  %s debugging is turned on.\n",p->desc);
	}
    return (TRUE);
}
/****	Interface routines	****/


debug_set(cp)
char *cp;
{   struct _dbg_type *p;

    if (streq(cp,"?"))
    {	debug_help();
	return (TRUE);
    }
    p = dbg_lookup(cp);
    if (p==NULL) return(FALSE);
    dbg_flag |= p->val;
    printf("%s debugging turned on.\n",p->desc);
    return (TRUE);
}


debug_unset(cp)
char *cp;
{   struct _dbg_type *p;

    if (streq(cp,"?"))
    {	debug_help();
	return (TRUE);
    }
    p = dbg_lookup(cp);
    if (p==NULL) return(FALSE);
    dbg_flag &= ~p->val;
    printf("%s debugging turned off.\n",p->desc);
    return (TRUE);
}
