
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/errno.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netdb.h>
#include <malloc.h>

#include "Address.h"

/*#define SPECIFYSNMPUDP 1*/
/*fd_set readfds;   /* Read File Descriptors */

/************************************************************************
 * AddAddress( ) - Add Address to AddressList                           *
 *                 Returns updated AddressListHead                      *
 ************************************************************************/
struct AddressListType *AddAddress(AddressListHead, Address)
     struct AddressListType *AddressListHead;
     char *Address;
{
struct AddressListType *A,*ATail;
struct servent *sp;
struct hostent *hp;
static int opensocketcount;

	if ( (Address == NULL) || ( strlen( Address ) < 1 ) ) 
		return(AddressListHead);

        if ((A=(struct AddressListType *)malloc( sizeof( struct AddressListType)))
                                                                ==NULL)
                fastsnmpsyserr("AddAddress(): malloc() AddressListType struct\n");
        if ((A->Address=(char *) malloc( strlen(Address)+1 ))==NULL)
                fastsnmpsyserr("AddAddress(): malloc() Address\n");
        strcpy(A->Address,Address);
	A->Community=NULL;
	A->Busy=0;
	A->LastResponded=0;
	A->SNMP_Cmd=0;
        A->QueryListHead=A->ResponseListHead=NULL;
        bzero( (char *)&(A->snmp_dest), sizeof(A->snmp_dest) );

        if ((A->SNMP_socket=socket( AF_INET, SOCK_DGRAM,  0 )) < 0 ) {
                perror("AddAddress(): socket call failed\n");
		fprintf(stderr,"Only %d socket opens allowed\n",opensocketcount);
                return( AddressListHead );
        }
	opensocketcount++;

#ifdef SPECIFYSNMPUDP
        if ((sp=getservbyname("snmp","udp"))==NULL) {
                fprintf(stderr,"AddAddress(): snmp/udp: unknown service...Check /etc/services\n");
                return( AddressListHead );
        }
#endif
	hp=NULL;
        if (((A->addr = inet_addr(Address))==-1) && 
		((hp=gethostbyname(Address))==NULL)) {

            fprintf(stderr,"AddAddress(): invalid Address %s \n",
                                                Address);
            return(AddressListHead);
        }
	if ( hp ) {
        	bcopy(hp->h_addr,(char *)&(A->snmp_dest.sin_addr),hp->h_length);
        	bcopy(hp->h_addr,(char *)&(A->addr),hp->h_length);
        	A->snmp_dest.sin_family=hp->h_addrtype;
	} else {
        	bcopy(&A->addr,(char *)&(A->snmp_dest.sin_addr),4);
        	A->snmp_dest.sin_family=AF_INET;
	}
#ifdef SPECIFYSNMPUDP
        A->snmp_dest.sin_port = sp->s_port;
#else
        A->snmp_dest.sin_port = 161;
#endif

	if ( AddressListHead==NULL ) AddressListHead=A;
	else {
		for(ATail=AddressListHead; ATail->Next!=NULL; ATail=ATail->Next);
        	ATail->Next=A;
	}
	A->Next=NULL;
	return(AddressListHead);
}

/***************************************************************************
 * FreeAddressList() - Free all Address Structures, VarLists, and bindings *
 ***************************************************************************/
struct AddressListType *FreeAddressList(AHead)
     struct AddressListType *AHead;
{
struct AddressListType *A2;

	for( ; AHead!=NULL; AHead=A2 ) {
                AHead->QueryListHead=FreeVarListChain( AHead->QueryListHead );
                AHead->ResponseListHead=FreeVarListChain( AHead->ResponseListHead );
		/*close(AHead->SNMP_socket);	/* Close Unused socket */
		if (shutdown(AHead->SNMP_socket,2))
			perror("shutdown(): ");	/* Close Unused socket */
                A2=AHead->Next;
		free(AHead);
	}
	return(NULL);
}

/************************************************************************
 * FreeAddressListsVarList() - Free up this Address structures VarLists *
 ************************************************************************/
struct AddressListType *FreeAddressListsVarList(A)
     struct AddressListType *A;
{
	for( ; A!=NULL; A=A->Next ) {
		A->QueryListHead=FreeVarListChain( A->QueryListHead );
		A->ResponseListHead=FreeVarListChain( A->ResponseListHead );
	}
}

struct VarList *MarkDone(A, v)
     struct AddressListType *A;
     struct VarList *v;
{
struct VarList *v2;

	if ((A==NULL) || (v==NULL)) {
		fprintf(stderr,"Error-MarkDone() called with NULL Parameters\n");
		return(NULL);
	}
        /*** Dequeue varlist off Query Node List ***/
	if ( v->Prev ) v->Prev->Next=v->Next;
	else {
		A->QueryListHead = v->Next;
		if ( A->QueryListHead != NULL ) A->QueryListHead->Prev = NULL;
	}
	if ( v->Next ) v->Next->Prev=v->Prev;

        /* Now chain v on the end of the done queue */
        if ( A->ResponseListHead == NULL ) {
                A->ResponseListHead=v;
                v->Prev=NULL;
        }
        else {
		for( v2=A->ResponseListHead; v2->Next!=NULL; v2=v2->Next);
                v->Prev=v2;
                v2->Next=v;
        }
        v->Next=NULL;
	/*FD_CLR( A->SNMP_socket, &readfds );*/
       /*readfds &= ~(1 << A->SNMP_socket ); */
	return(NULL);
}

void Dup_Community_onto_AddressList(AddressListHead, Community)
     struct AddressListType *AddressListHead;
     char *Community;
{
struct AddressListType *A;

	for( A=AddressListHead; A!=NULL; A=A->Next ) {
		A->Community=(char *)malloc( strlen(Community)+1);
		strcpy( A->Community, Community );
	}
}

/************************************************************************
 * Dup_Var_List_onto_AddressList() -                                    *
 *      Duplicate a VarList chain onto each AddressList structure       *
 *      and Update the community field of each on eas well              *
 ************************************************************************/
void Dup_Var_List_onto_AddressList(AddressListHead, Community, VarList)
     struct AddressListType *AddressListHead;
     char *Community;
     struct VarList *VarList;
{
struct AddressListType *A;
struct VarList *v;

	/*FD_ZERO(&readfds);	/* Initialize file descriptor bit masks */
	for( A=AddressListHead; A!=NULL; A=A->Next ) {
		for( v=VarList; v!=NULL; v=v->Next ) 
			A->QueryListHead = DupVarAndChain( A->QueryListHead , v);
		/*FD_SET( A->SNMP_socket, &readfds );*/
        	/*readfds |= (1 << A->SNMP_socket );*/
	}
}

DisplayAddressList(A)
     struct AddressListType *A;
{
struct VarList *v;
struct bindings *b;

	for( v=A->QueryListHead; v!=NULL; v=v->Next ) {
		printf("%s\tQ %s\t%s\t",A->Address,v->VarName,v->Prefix);
		for (b=v->Head; b!=NULL; b=b->Next)
			printf("%s-%s\t",b->instance,b->value);
		printf("\n");
	}
	for( v=A->ResponseListHead; v!=NULL; v=v->Next ) {
		printf("%s\tR %s\t",A->Address,v->VarName);
		for (b=v->Head; b!=NULL; b=b->Next)
			printf("%s-%s\t",b->instance,b->value);
		printf("\n");
	}
}

DisplayAddressChain(AddressListHead)
     struct AddressListType *AddressListHead;
{
struct AddressListType *A;

	for( A=AddressListHead; A!=NULL; A=A->Next ) {
		DisplayAddressList( A );
	}
}
		
