/*
 *	viewif - show interface state
 */
#include <curses.h>
#ifdef AIX
#include <term.h>
#endif
#include <time.h>
#include <signal.h>
#include <ctype.h>
#include <string.h>
#include <sys/file.h>
#include <unistd.h>
#include "ctools.h"
#include "snmptable2.h"

#define UPDATEINTERVAL 1 /*  every sec*/
char *progname,*host,*Community;

struct AddressListType *AddressListTypeHead;

char *variables[]={
		"ifInUcastPkts",
		"ifInNUcastPkts", 
		"ifInErrors",
		"ifInDiscards",
		"ifOutUcastPkts", 
		"ifOutNUcastPkts",
		"ifOutErrors",
		"ifOutDiscards"
};

int NumVars=((sizeof(variables))/(sizeof(char *)));

struct interfacetypes {
	char addr[40];
	char name[100];
	char vals[20][20];
} IF[20];

#define FORMAT "%12.12s "

#define RAWFORMAT 0
#define RELATIVETOSTART 1
#define PPS 2

int Format=2;	/* Which of the display formats to use */
int DisplayName=1;

struct interfacetypes FirstCount[20];
struct interfacetypes LastCount[20];
long LastTime;

gethostname( Addr )
char *Addr;
{
static char name[100];
char addr[4],address[1000];
static struct hostent *hp;

        strcpy( address,Addr );
        addr[0]=atoi( strtok( address, ".\n\t") );
        addr[1]=atoi( strtok( NULL, ".\n\t") );
        addr[2]=atoi( strtok( NULL, ".\n\t") );
        addr[3]=atoi( strtok( NULL, ".\n\t") );
        if ((hp=gethostbyaddr( addr, 4, 2 )) == NULL ) {
		strcpy( name, Addr );
        } else
		strcpy( name, hp->h_name);
}

AddUserVar( var )
char *var;
{
static int virgin=1;

	if ( virgin ) {
		NumVars=0;
		virgin=0;
	}	
	variables[ NumVars ]=(char *) malloc(strlen(var)+1);
	strcpy( variables[ NumVars ], var );
	NumVars++;
}

/**********************************************************
 *  Message: Put a message to the user on the bottom line * 
 **********************************************************/
void Message(msg)
char msg[];
{
   standout();
   mvaddstr(LINES-1,0,msg);
   standend();
   clrtoeol();
   refresh();
}

/********************************************************
 * DrawFrame: Draw a frame in which problems get logged	*
 ********************************************************/
DrawFrame()
{
char TopLine[80],buffer[80],buf2[20];
int i;

    clear(); 
    sprintf(TopLine,"   view %s interfaces",host);
    mvaddstr(0,0,TopLine);

}

/****************************************************************
 * GotoCmdLine:  Got the Command Prompt 			*
 ****************************************************************/
GotoCmdLine()
{
   move(LINES-2,0); clrtoeol();
   standout();
   addstr("Command:");
   standend();  
   move(LINES-2,9);
}

/****************************************************************
 * RefreshScreen:  Force Update of the user's screen		*
 *		   DO NOT CALL THIS ROUTINE!!!!			*
 *		   The user callable version is DrawDynamic	*
 ****************************************************************/
RefreshScreen()
{
	DrawDynamics();	
}

DrawTime()
{
time_t TimeNow=time(&TimeNow);
static time_t StartTime;
char buffer[100];

	if (StartTime==0) StartTime=TimeNow;
	move(1,30);
	switch( Format ) {
	case RAW:
			addstr("                              ");
			move( 3, 0 );
			addstr("RAW");
			break;
	case RELATIVETOSTART:
		sprintf(buffer,"Starting: %s",ctime(&StartTime));
		addstr(buffer);
			move( 3, 0 );
			addstr("RTS");
			break;
	case PPS:
			addstr("                              ");
			move( 3, 0 );
			addstr("PPS");
			break;
	}	
	sprintf(buffer,"TimeNow : %s",ctime(&TimeNow));
	move(2,30);
	addstr(buffer);
}

DrawStats()
{
int i,j;
char buffer[100];
static int virgin=1;
long TimeNow=time(&TimeNow);
int DeltaTime=TimeNow-LastTime;

	if (DeltaTime==0) DeltaTime=1; /* Don't divide by zero! */
	move( 4,0 );
	addstr( "# Interface Addr ");
	move( 4, 19 );
       	for( j=0; j<NumVars; j++ ) {
		sprintf(buffer, FORMAT,variables[j]);
		addstr( buffer ); 
	}
	for( i=0; i<20; i++ ) {
		if ( IF[i].addr[0] != '\0' ) {
			move( i+5, 0 );
			if ( DisplayName )
				sprintf(buffer, "%2d %16.16s ",i,IF[i].name);
			else
				sprintf(buffer, "%2d %16.16s ",i,IF[i].addr);
			addstr( buffer ); 
        		for( j=0; j<NumVars; j++ ) {
				if ( (Format == RAWFORMAT) || (virgin))
					sprintf(buffer, FORMAT,IF[i].vals[j]);
				else if ( Format == RELATIVETOSTART )
					sprintf(buffer, "%12ld ",atol(IF[i].vals[j])-atol(FirstCount[i].vals[j]));
				else 
					sprintf(buffer, 
						"%12ld ",
				(atol(IF[i].vals[j])-atol(LastCount[i].vals[j]))/DeltaTime);
				addstr( buffer ); 
#ifdef DEBUG
				printf("if #%d %s-%s=%ld\n",i,
				IF[i].vals[j],LastCount[i].vals[j],
				atol(IF[i].vals[j])-atol(LastCount[i].vals[j]));
				sleep(1);
#endif
			}
		}
	}
	virgin=0;
	GotoCmdLine();
}

DupLastCount() 
{
int i,j;
	for( i=0; i<20; i++ ) {
		if ( IF[i].addr[0] != '\0' ) {
			strcpy( LastCount[i].addr, IF[i].addr );
			strcpy( LastCount[i].name, IF[i].name );
        		for( j=0; j<NumVars; j++ ) {
				strcpy( LastCount[i].vals[j], IF[i].vals[j]);
			}
		}
	}
}


/****************************************************************
 * DrawDynamics:  Redraw what does change			*
 *			time of day				*
 *			cycletime				*
 *			PROBLEM.FILE				*
 *			CHECKING				*
 *			Goto the command line 			*
 ****************************************************************/
DrawDynamics()
{
  /*signal(SIGALRM,RefreshScreen);	/*  Invoke RefreshScreen on alarm  */
  /*alarm( 0 );		/* Don't interrupt us with alarms ! */

      GotoCmdLine();	/* Go to the command line and */
	DrawTime();
	getStats();
	DrawStats();
      refresh();	/* refresh the screen */

  /*signal(SIGALRM,RefreshScreen);	/*  Invoke RefreshScreen on alarm  */
	  /*alarm( UPDATEINTERVAL );*/
}

AddInterface( index, addr )
int index;
char *addr;
{
	strcpy(IF[ index ].addr,addr);
	strcpy(IF[ index ].name,gethostname(addr));
}

AddStats( index, variable, value )
int index;
char *variable, *value;
{
int i,found=0;

        for( i=0; i<NumVars; i++ ) {
		if ( strcmp( variables[i], variable ) == 0 ) {
			found=1;
			break;
		}
        }
	if ( ! found ) { 
		fprintf(stderr,"No such!!! %s\n",variable);
		exit(1);
	}
	strcpy( IF[ index ].vals[ i ], value );
}

int getConfig()
{
FILE *stream;
char cmd[100];
char buffer[100];
char *h,*var,*val;
int i;
struct AddressListType *A;
struct VarList *QueryListHead=NULL,*V;
struct bindings *b;

	for( i=0; i<20; i++ ) IF[i].addr[0]='\0';

	QueryListHead=AddVar( QueryListHead, "ipAdEntIfIndex" );

	AddressListTypeHead=GetTable( AddressListTypeHead, Community, QueryListHead );

        for( A=AddressListTypeHead; A!=NULL; A=A->Next )
		for( V=A->ResponseListHead; V!=NULL; V=V->Next )
			for ( b=V->Head; b!=NULL; b=b->Next )
				AddInterface( atoi( b->value), b->instance+strlen(V->Prefix) );
	
	AddressListTypeHead->ResponseListHead=FreeVarListChain( AddressListTypeHead->ResponseListHead );
	AddressListTypeHead->QueryListHead=FreeVarListChain( AddressListTypeHead->QueryListHead );
	return(i);
}

static int getstatsvirgin=1;

int getStats()
{
FILE *stream;
char cmd[100];
char buffer[100];
char *h,*var,*index,*val;
int i,j;
struct AddressListType *A;
struct VarList *QueryListHead=NULL,*V;
struct bindings *b;
static int count=0;

	/*fprintf(stderr,"...........Querying.............%d",++count); fflush(stderr);*/
	time(&LastTime);
	DupLastCount();
	/*for( i=0; i<20; i++ ) {
		for( j=0; j<20; j++ ) 
			IF[i].vals[j][0]='-';
	}*/
	for( i=0; i<NumVars; i++ ) {
		QueryListHead=AddVar( QueryListHead, variables[i] );
	}

	AddressListTypeHead=GetTable( AddressListTypeHead, Community, QueryListHead );

        for( A=AddressListTypeHead; A!=NULL; A=A->Next )
		for( V=A->ResponseListHead; V!=NULL; V=V->Next )
			for ( b=V->Head; b!=NULL; b=b->Next )
				AddStats( atoi( b->instance+strlen(V->Prefix)),
					V->VarName,  b->value );
	if ( getstatsvirgin == 1 ) {
		getstatsvirgin=0;
		for( i=0; i<20; i++ ) {
			strcpy(FirstCount[i].addr,IF[i].addr);
			for( j=0; j<20; j++ ) 
				strcpy(FirstCount[i].vals[j],IF[i].vals[j]);
		}
	}
	AddressListTypeHead->ResponseListHead=FreeVarListChain( AddressListTypeHead->ResponseListHead );
	AddressListTypeHead->QueryListHead=FreeVarListChain( AddressListTypeHead->QueryListHead );
        return(i);
}


/****************************************************************
 * ClearMessage:  Clear the message line			*
 ****************************************************************/
void ClearMessage()
{
   move(LINES-1,0);
   clrtoeol();
   refresh();
}

sigcatcher()
{

	printf("Interrupt. ERR! Don't do that!\n");
    endwin(); 			/* Close down the curses environment 	  */
	exit( 0 );
}

/****************************************************************
 * Loop:  main loop of program.  				*
 *		Set an alarm to go off in 30 seconds		*
 *			and provide address of alarm routine	*
 *		Read the Problem List, Checking file		*
 *		Update the screen and display the current time	*
 *		Forever						*
 *			Get a key stroke and handle user cmd.	*	
 ****************************************************************/
Loop()
{
extern int NumProblems;
char ch;

   /*signal(SIGALRM,RefreshScreen);	/*  Invoke RefreshScreen on alarm  */
   signal(SIGHUP,sigcatcher);		/*  Catch all signals */
   signal(SIGINT,sigcatcher);		/*  Catch all signals */
   signal(SIGQUIT,sigcatcher);		/*  Catch all signals */
   signal(SIGTERM,sigcatcher);		/*  Catch all signals */
   signal(SIGTSTP,sigcatcher);		/*  Catch all signals */
   /*alarm(UPDATEINTERVAL);		/* Alarm in UPDATEINTERVAL seconds */
   DrawFrame();				/* Start out with Framework */
   while(1) {
	DrawDynamics();			/*Draw the changing part of the screen*/
#ifdef XXX
	ch=getch();
	/*alarm(0);			/* TURN OFF THE ALARM@@ */
				/* DrawDynamics will restart the alarm for us */
	switch( ch ) {
		case 'q':
		case 'Q':
			addstr("uit");
			move(LINES-1,0);
			clrtoeol();
			refresh();
			return;
			/*NOTREACHED*/
		case 'f':
		case 'F':
			if (++Format >2 ) Format=0;
			break;
		case 'n':
		case 'N':
			DisplayName^=1;
			break;
		case '?':
			Message("   Cmds: (Q)uit (F)ormat (N)ames");
			sleep(5);
			ClearMessage();
			break;
		case ' ':
			DrawFrame();
			break;
		default:  
			refresh();
            		break;
	}	/* switch */ 
#endif
   }	/* While () */
}

Usage()
{
	fprintf(stderr,"Usage(): %s [-n][-a][-c|-r|-p][ -v variable [-v variable ]...] nodename Community\n",progname);
	fprintf(stderr,"\
-n means use DNS Name on interface labels\n\
-a means use IP Address on interface labels\n\
-c means show cooked interface counters (relative to when you started program)\n\
-r means show raw interface counters\n\
-p means show counters in a per second display\n\n");

	exit(1);
}

/************************************************************************
 *   Main Program:     Start up the curses screen package and start 	*
 *				command processing loop			*
 ************************************************************************/
main(argc,argv)
int argc;
char *argv[];
{
char *pingkydir,*getenv();
char buffer[100];
int i;

	MaxSecsB4Retry=3;
	MaxSNMPRetries=3;
    	progname=argv[0];
        argv++; argc--;
        while( *argv && argv[0][0] == '-') {
                switch(argv[0][1]) {
                case 'v':	/* This needs to be redone */
                                *argv++;
                                argc--;
				if ( argc ) AddUserVar( *argv );
				else Usage();
                                *argv++;
                                argc--;
                                break;
		case 'n':		/* Name */
                                *argv++;
                                argc--;
				DisplayName=1;
				break;
		case 'a':		/* Address */
                                *argv++;
                                argc--;
				DisplayName=0;
				break;
		case 'c':		/* cooked */
                                *argv++;
                                argc--;
				Format=RELATIVETOSTART;
				break;
		case 'r':		/* raw */
                                *argv++;
                                argc--;
				Format=RAWFORMAT;
				break;
		case 'p':		/* packets per second */
                                *argv++;
                                argc--;
				Format= PPS;
				break;
                default:
                        Usage();
                        break;
                }
        }

	if ( argc != 2 ) {
		printf( "You Must include nodename and Community\n");
		Usage();
	}
    	host=argv[0];
	AddressListTypeHead=AddAddress( AddressListTypeHead, argv[0] );
    	Community=argv[1];
	getConfig();
	getStats();
    initscr();			/* Open Up the curses environment	  */
    Loop( );	/* Call the main command handling loop 	  */
    endwin(); 			/* Close down the curses environment 	  */
}
