
/************************************************************************
 *	Bill Norton	Enhanced SNMP API				*
 *									*
 *	High-Level Calls:						*
 *		Get() - Provides a SNMP_GET for any number of hosts	*
 *		GetNext() - SNMP GET NEXT for any number of hosts	*
 *		GetTable() - SNMP GET NEXT Until End of Table		*
 *									*
 *	Each of these is called with the following parameters:		*
 *		AddressListHead - List of AddressList structures	*
 *		Community - Community Name for all queries		*
 *			    ( If NULL, it is assumed that caller 	*
 *			     already set up the Community field in the  *
 *			     AddressList Structures.		     )  *
 *		QueryList - List of Variables to Query for.		*
 *			    ( If NULL, it is assumed that the caller	*
 *			     already set up the VarLists for each 	*
 *			     AddressList Structures.		     )  *
 *									*
 *	If a mixture of Gets, GetNexts, and GetTables is desired, you	*
 * will have to "roll your own".  This means setting up the VarLists	*
 * and AddressList structures to accomodate your unique mix of queries. *
 *									*
 *	Comvenience Routines:						*
 *		To create AddressList Structures:			*
 ************************************************************************/
#include "snmptable2.h"

#include "ctools.h"

int io_debug;

/*int MaxSecsB4Retry=5;
int MaxSNMPRetries=5;*/
extern int MaxSecsB4Retry;
extern int MaxSNMPRetries;
extern int verbose;

/*int DebugOnFailure=0;*/

char *progname;


#include "version.h"
void Usage()
{
	fprintf(stderr,"\n\n%s\n\n",Version);
	fprintf(stderr,"Usage: %s -g|-n [ -v -d ] [ -t timeout ] [ -r retries] -h <address> [-h address ... -h address ] -c community table [ table ... table ]\n",progname);
	fprintf(stderr,"\nWhere:\n-g performs gets\n-n performs a get-next\n-v turns on verbosity\n-d turns on verbosity and Network I/O debugging\n");
	fprintf(stderr,"-t timeout specifies the timeout between retries.. Default=%d\n",MaxSecsB4Retry);
	fprintf(stderr,"-r retries specifies the number of retries if request timed out..Default=%d\n",MaxSNMPRetries);
	fprintf(stderr,"-h hostname specifies which host(s) to query\n-c communityname specifies the community name to use for the queries\n");
	fprintf(stderr,"table specifies which table(s) or MIB variable(s) to fetch\n");
	fprintf(stderr,"\n\nAll requested variables MUST exist in /etc/mib_desc file\n\n\n");
	exit(2);
}

void PrintReport(A)
     struct AddressListType *A;
{
struct bindings *b;
struct VarList *v;
extern char *IDtoName();

	if ( A->ResponseListHead == NULL ) {
		printf("%s Did not respond\n",A->Address);
		return;
	}
	for( v=A->ResponseListHead; v!=NULL; v=v->Next)
		for( b=v->Head; b!=NULL; b=b->Next )
		printf("%s: %s %s\n",A->Address, IDtoName(b->instance),b->value);
#ifdef OLD
			if ( A->SNMP_Cmd == SNMPNEXT )
				printf("%s: %s %s\n",A->Address, b->instance,b->value);
			else
				printf("%s: %s.%s %s\n",A->Address, v->VarName, b->instance+strlen(v->Prefix),b->value);
#endif
}

void main( argc, argv )
int argc;
char *argv[];
{
char *Community=NULL;
struct AddressListType *AddressListHead=NULL, *A;
struct VarList *QueryListHead=NULL;
extern int io_debug;
int Cmd=SNMPTABLE;

	progname=argv[0];
        argv++; argc--;
	while(*argv!=NULL && argv[0][0] == '-') {
                switch(argv[0][1]) {
		case 'd':
				io_debug=1;
                case 'v':	verbose=1; 
                                argv++; argc--;
                                break;
		case 'h':
			AddressListHead=AddAddress( AddressListHead, argv[1] );
                       	argv++; argc--;
                       	argv++; argc--;
			break;
		case 'c':
                       	argv++; argc--;
			Community=*argv;
                       	argv++; argc--;
			break;
		case 'g':
			argv++; argc--;
			Cmd=SNMPGET;
			break;
		case 'n':
			argv++; argc--;
			Cmd=SNMPNEXT;
			break;
		case 'r':
                       	argv++; argc--;
			if ( ( argc != 0 ) && ( atoi(argv[0]) != 0 )) {
				MaxSNMPRetries=atoi(argv[0]);
                       		argv++; argc--;
			}
			else fprintf(stderr,"Invalid retry specification\n");
			break;
		case 't':
                       	argv++; argc--;
			if ( ( argc != 0 ) && ( atoi(argv[0]) != 0 )) {
				MaxSecsB4Retry=atoi(argv[0]);
                       		argv++; argc--;
			}
			else fprintf(stderr,"Invalid retry specification\n");
			break;
                default:
                        fprintf(stderr,"unknown option %s ignored\n(Valid options are: -v )\n",argv[1]);
                        argv++; argc--;
                        break;
                }
        }
		
	for( ; *argv!=NULL; argv++ ) 
		QueryListHead=AddVar( QueryListHead, (char *)strtok(*argv," \t\n") );
	if ((AddressListHead==NULL)||(Community==NULL)||(QueryListHead==NULL)) 
		Usage();
	if (Cmd==SNMPGET)
		AddressListHead=Get(AddressListHead, Community, QueryListHead); 
	if (Cmd==SNMPNEXT)
		AddressListHead=GetNext(AddressListHead, Community, QueryListHead); 
	if (Cmd==SNMPTABLE)
		AddressListHead=GetTable(AddressListHead, Community, QueryListHead); 
	for( A=AddressListHead; A!=NULL; A=A->Next )
		PrintReport( A );
}
