#include <stdio.h>
#include <time.h>
#include <ctype.h>
#include <string.h>
#include "ctools.h"

/* Add section - if delta <0 and last counter is > 4,000,000,000,
                delta = MAX long - last counter + value */

#define MAXIFS 30
#define MAXDPS 200000   /* if we see a delta per second of _, toss it-bad data*/
int verbose=0;

#define WRAP 1          /* Mark this counter value as WRAPPED counter */

struct datatype {
        char Flag;
        long TimeStamp;
        long Value;
        long tdiff;
        long delta;
        float dps;
        struct datatype *Next,*Last;
} *Head[MAXIFS],*Tail[MAXIFS];

long DELTA[MAXIFS],TDIFF[MAXIFS];

static char *months[] =
{
        "Jan",
        "Feb",
        "Mar",
        "Apr",
        "May",
        "Jun",
        "Jul",
        "Aug",
        "Sep",
        "Oct",
        "Nov",
        "Dec",
        0
};

static char *days[] = 
{
	"Sun",
	"Mon",
	"Tue",
	"Wed",
	"Thu",
	"Fri",
	"Sat",
	0
};
int Active[ MAXIFS ];
char Label[MAXIFS][150];

#define XGRAPH 0
#define RAW 1
#define REALLYRAW 2
int OutputStyle=XGRAPH;

long CurrentTimeStamp;
int line;


PrintResults()
{
int i;
struct datatype *d;
struct tm *tm;
int lastday=-1,elapsed=0;

        for( i=0; i<MAXIFS; i++ ) {
                elapsed=0;
                lastday=-1;
		DELTA[i]=0;
		TDIFF[i]=0;
                for( d=Head[i]; d!=NULL; d=d->Next ) {
                        if ( d != Head[i] ) {
                                tm=gmtime( &(d->TimeStamp) );
                                if ((lastday!=tm->tm_mday)&&(lastday!=-1)) {
                                        elapsed+=24;
                                }
                                switch ( OutputStyle ) {
                                case XGRAPH:
                                                printf("%2.2d.%2.2d\t%f\n", tm->tm_hour+elapsed,
                                                (tm->tm_min*100)/60, d->dps);
                                                break;
                                case RAW:
                         printf("%s %s %2.2d %2.2d:%2.2d %ld\tdelta=%ld\ttdelta=%ld\t%6.2f/s\n",
days[tm->tm_wday],months[tm->tm_mon],tm->tm_mday,tm->tm_hour,tm->tm_min,
d->Value,d->delta,d->tdiff,d->dps);
				DELTA[i]+=d->delta;
				TDIFF[i]+=d->tdiff;
						break;
				case REALLYRAW:
                                                printf("%2.2d:%2.2d:%2.2d\t%ld\t%ld\t%ld\t%f\n",
tm->tm_mday,tm->tm_hour,tm->tm_min,
d->Value,d->delta,d->tdiff,d->dps);
                                                break;
                                }
                                lastday=tm->tm_mday;
                        }
                        else 
				if ( strncmp(Label[i],"Interf",6)==0)
					printf("\n\"%s#%d\n",Label[i],i);
				else
					printf("\n\"%s\n",Label[i]);
		}
		if ( OutputStyle == RAW && TDIFF[i]!=0 ) { 
		printf("%s SUMMARY: TOTAL: %ld ELAPSEDTIME: %ld AVERAGE= %8.4f\n",
		Label[i],DELTA[i],TDIFF[i],(float)DELTA[i]/(float)TDIFF[i]);
		}
        }
}

ProcessTimeStamp( line )
char *line;
{
extern long time_convert();
long t=time_convert( line );

        if ( t != 0 ) CurrentTimeStamp=t;
        else fprintf(stderr,"ProcessTimeStamp: Invalid Time Stamp on line %d\n",line);
	/*printf("CurrentTime=%u %s",CurrentTimeStamp,ctime(&CurrentTimeStamp));*/
}

AddDataPoint( i, value )
int i;
long value;
{
struct datatype *d,*p,*k,*lastgood;

        if (verbose) printf("AddDataPoint: CurrentTimeStamp=%ld instance=%d value=%ld\n",
                                CurrentTimeStamp,       i,      value );

        if ( ( i >MAXIFS ) || ( i < 0 )) {
                fprintf(stderr,"AddDataPoint: Invalid instance %d on line %d %s",
                        i, line, ctime( &CurrentTimeStamp) );
                return;
        }
        if ( ! Active[i] ) return;      /* User doesn't want to see this */
        if (( d = (struct datatype *) malloc( sizeof( struct datatype ) ) ) == NULL ) {
                fprintf(stderr,"malloc failed on line %d of %s\n",__LINE__,__FILE__);
                return;
        }
        d->Flag=0;
        d->TimeStamp=CurrentTimeStamp;
        d->Value=value;
        d->tdiff=d->delta=d->dps=0;
        d->Next=d->Last=NULL;

        if ( Head[i] ) {
                d->tdiff = d->TimeStamp - Tail[i]->TimeStamp;
                if ( d->tdiff <= 60 ) {
                        fprintf( stderr,"AddDataPoint: TimeStamp Diff <= 60 (tdiff=%d) if# %d on line %d-possible duplicates-lasttime=%u %s tossing this time %u %s",
	d->tdiff,i,line , Tail[i]->TimeStamp,ctime( &Tail[i]->TimeStamp), d->TimeStamp, ctime( &(d->TimeStamp)));
                        free( d );
                        return;
                }
                d->delta = d->Value - Tail[i]->Value;
                if ( d->delta < 0 ) {
			if ( Tail[i]->Value > 4000000000 ) {
				fprintf(stderr,"Real Wrap if# %d last value %ld this value %ld on %s",i,Tail[i]->Value,d->Value,ctime( &(d->TimeStamp)));
				/*
				*	The following was replaced as it
				*	gave alarming and misleading measures
				*
				*d->delta=(long)4294967294-Tail[i]->Value+d->Value;
				*/
				d->delta=d->Value;
                        	d->Flag=WRAP;
			}
			else {
                        	fprintf(stderr,"AddDataPoint: Negative delta; possible Wrap condition if #%d line %d, %s", i,line,ctime( &(d->TimeStamp)));
                        	d->delta=d->Value;
                        	d->Flag=WRAP;
			}
                }
                d->dps = (((float) d->delta) / ((float) d->tdiff));
                /* delta calculation checked in 0-check below */

                Tail[i]->Next=d;
                d->Last=Tail[i];
                Tail[i]=d;
        } else {
                Head[i]=Tail[i]=d;
        }
        /* Check for previous bad 0 counters.... */
        /* This Value and delta are non-zero */
        /* The last value was 0 - see is the 0 is really a "NSFNet NOT Answer"*/
        /* indicated by v1 v2 v3 0 0 v6 v7  where v3<v6... Wrap unlikely */
        /* Also check ALL Wrap conditions */
        if (((d->Value) && (d->delta) && (d->Last)) &&
           ( ((d->Last)->Value==0) || ((d->Last)->Flag==WRAP) )  ) {
                for( p=(d->Last)->Last; p!=NULL; p=p->Last ) {
                        if ( p->Value != 0 ) {
                                if ( p->Value < d->Value ) { /* BAD ZERO */
                                        lastgood=p;
                                        for( k=p->Next,p=p->Next; p!=d; ) {
                                                p=p->Next;
                                                if ( k->Flag!=WRAP )
                                                        fprintf( stderr, "AddDataPoint: Bad Zeros line# %d if# %d, tossing %s",line,i,ctime(&(k->TimeStamp)));
                                                else
                                                        fprintf( stderr, "AddDataPoint: Bad Data line# %d if# %d, tossing %s",line,i,ctime(&(k->TimeStamp)));
                                                free( k );
                                                k=p;
                                        }
                                        lastgood->Next=d; /* Link last good */
                                        d->Last=lastgood; /* To most recent */
                                        /* Recalculate deltas-counts changed*/
                                        d->tdiff = d->TimeStamp - (d->Last)->TimeStamp;
                                        d->delta = d->Value - (d->Last)->Value;
                                        d->dps = (((float) d->delta) / ((float) d->tdiff));

                                        break;  /* We're done freeing */
                                }
                                else break;  /* We're done- nothing wrong */
                        }
                        else; /* Another 0 - back up to previous */
                } /* Zero check for loop */
        }
        else; /* One of the conditions failed - No Zero fault exists */
}

ProcessDataLine( line )
char *line;
{
int instance;
long value;
char *p=strtok( line, " \t\n");
char buffer[100];

        if ( p == NULL ) {
                fprintf(stderr,"ProcessDataLine: invalid null line\n");
                return;
        }
        instance=atoi( p , buffer );
        if ((p=strtok(NULL," \t\n")) == NULL ) {
                fprintf(stderr,"ProcessDataLine: NULL Value on line\n");
                return;
        }
        value = atol( p , buffer );
        if ((p=strtok(NULL," \t\n")) != NULL ) {
                fprintf(stderr,"ProcessDataLine: Extra Values on line!(%s)\n",p);
                return;
        }
        AddDataPoint( instance , value );
}

main( argc, argv )
int argc;
char *argv[];
{
int i;
char buffer[100],*p;
int selective=0;

        for( i=0; i<MAXIFS; i++ ) strcpy( Label[i] , "Interface");
	argv++; argc--;
        while( *argv && argv[0][0] == '-') {
                switch(argv[0][1]) {
                case 'R':
                case 'r':       OutputStyle=RAW; argv++; argc--; break;
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                                i= atoi( &argv[0][1] );
                                if ( i < MAXIFS ) {
                                        selective=1;
                                        Active[ i ] = 1;
                                        if (( p = index( argv[0] , '=' ))!=NULL)
                                                strcpy( Label[i], p+1 );
                                        argv++; argc--;
                                }
                                else fprintf(stderr,"Invalid Interface # %d\n",
                                                        atoi( &argv[0][1] ));
                                break;
                default:
                        fprintf(stderr,"unknown option %s ignored\n(Valid options are: -<if#> -raw)\n",argv[0]);
                        argv++; argc--;
                        break;
                }
        }

        for( i=0; i<MAXIFS; i++ ) {
                Head[i]=Tail[i]=NULL;
                if ( !selective ) Active[i]=1;
        }

        for( line=1; gets(buffer); line++ )
                if ( isalpha(buffer[0]) )
                        ProcessTimeStamp( buffer );
                else
                        ProcessDataLine( buffer );
        PrintResults();
}
