/****************************************************************
 *	G L O B A L P I N G . C - Measure Cross Nework Delay 	*
 *								*
 *--------------------------------------------------------------*
 *    This code requires the day.c code to calculate the datestr*
 *								*
 *   Algorithm:							*
 *	1)	Set up paths where files can be found		*
 *	2)	Read configuration file to get NodeType(T1|T3)  *
 *			SrcAddress, and NodeNamePatternToPing	*
 *					( enss's, rcps or psps )*
 *	3)	Read .rhosts file looking for Pattern Nodes to  *
 *					ping.			*
 *	4)	For each Pattern matching node, ping and store  *
 *					results.		*
 ****************************************************************/

#include <stdio.h>
#include <string.h>
#include <time.h>

char RhostsFile[100];
char ConfigFile[100];
char OutputFile[100];
int NodeType;
char Pattern[100], RegExp[100];
char SourceAddress[100];
char *NumPackets="5";
char *PacketSize="100";
static char *DEFHOME="/usr/delay";
char *ProgName;
char PingCmd[100];

extern int re_exec();
extern char *re_comp();

struct NodeList {
	char *Name;
	struct NodeList *Next;
} *NodeHead=NULL,*NodeTail=NULL;

AddNode( nodename )
char *nodename;
{
struct NodeList *N;

	if ((N=(struct NodeList *)malloc( sizeof(struct NodeList) ))==NULL)
panic("malloc failed");

	if (( N->Name=(char *)malloc(strlen(nodename)+1))==NULL) panic("malloc failed");

	strcpy(N->Name,nodename);
	N->Next=NULL;
	if ( NodeHead==NULL ) NodeHead=NodeTail=N;
	else {
		NodeTail->Next=N;
		NodeTail=N;
	}
}

char *trim( str )
char *str;
{
	str[strlen(str)-1]='\0';
	return(str);
}

panic( str )
char *str;
{
FILE *stream=fopen("/tmp/delay.error","w");
long TimeNow=time(&TimeNow);

	fprintf(stderr,"%s %s: %s\n",trim(ctime(&TimeNow)),ProgName,str);
	fprintf(stream,"%s %s: %s\n",trim(ctime(&TimeNow)),ProgName,str);
	fclose(stream);
	exit(1);
}
	

ReadNodeList( filename, Pattern )
char *filename, *Pattern;
{
FILE *stream;
char buffer[100], *nodename, *regex();
	
	if ( ( stream=fopen(filename,"r"))==NULL) {
		sprintf(buffer,"Error opening .rhosts: %s",filename);
		panic(buffer);
	}
	while( fgets( buffer, sizeof(buffer), stream )) {
		if ((nodename=strtok(buffer," \t\n"))==NULL) continue;
#ifndef AIX
                re_comp( RegExp );
                if ( re_exec( nodename ) == 1 )
#endif
#ifdef AIX
                if ( regex( Pattern, nodename ) != NULL )
#endif
			AddNode( nodename );
	}
	fclose(stream);
}



SetEnv()
{
extern char *day(),*getenv();
char *HOME;

	if (( HOME=getenv("HOME"))==NULL) {
		/*printf("No $HOME available\n");*/
		HOME=DEFHOME;
	} else {
		if ( strlen(HOME) < 7 ) HOME=DEFHOME;
		/*printf("Home=%s\n",HOME);*/
	}
	strcpy( RhostsFile, HOME); strcat( RhostsFile,"/.rhosts");
	strcpy( ConfigFile, HOME); strcat( ConfigFile,"/etc/globalping.config");
	strcpy( OutputFile, HOME); 
	strcat( OutputFile,"/delaymatrix/delaymatrix.");
	strcat( OutputFile, day(0));
	strcpy( PingCmd, HOME );
}


ReadConfigFile( filename )
char *filename;
{
FILE *stream;
char buffer[100], *p, *s, *regcmp();

        if ( ( stream=fopen(filename,"r"))==NULL) {
		sprintf( buffer, "Error opening configfile: %s",filename);
		panic(buffer);
	}
        fgets( buffer, sizeof(buffer), stream );
	if ((p=strtok(buffer," \t\n"))==NULL) panic("No Type in configfile");
	else {
		NodeType=atoi(p);
		if ( (NodeType!=1) && (NodeType !=3 ))
		 	panic("Invalid node type - 1=T1 and 3=T3");
	}
	if ((p=strtok(NULL," \t\n"))==NULL) panic("No node pattern");
	else { 
		strcpy( RegExp, p );
#ifdef AIX
       		if ( ( s = regcmp( RegExp, NULL ) ) == NULL )
#endif
#ifndef AIX
        	if ( ( s = re_comp( RegExp ) ) != NULL )
#endif
			panic("Error in ConfigFile Regexp");
		else strcpy(Pattern,s);
	}
	if ((p=strtok(NULL," \t\n"))==NULL) panic("No source address");
	else strcpy( SourceAddress, p);
	if ( NodeType == 1 ) strcat( PingCmd, "/bin/ping.rt ");
	else strcat( PingCmd, "/bin/ping.rs6000 ");
	strcat( PingCmd, "-S "); strcat(PingCmd,SourceAddress ); strcat(PingCmd," ");
	strcat( PingCmd, "-s "); strcat( PingCmd,PacketSize); strcat(PingCmd," ");
	strcat( PingCmd, "-c "); strcat( PingCmd,NumPackets); strcat(PingCmd," ");
	fclose( stream );
}

DoPings( filename )
char *filename;
{
FILE *stream,*pstream;
char buffer[100], cmd[100], *p;
long timenow=time(&timenow);
struct NodeList *N;

        if ( ( stream=fopen(filename,"a"))==NULL) {
		sprintf(buffer,"Error opening outputfile: %s",filename);
		panic(buffer);
	}
	strcpy( buffer , ctime(&timenow) );
        fputs( buffer, stream );
	for( N=NodeHead; N!=NULL; N=N->Next ) {
		fputs( strtok(N->Name,"."), stream);
		fputs( " ", stream);
		strcpy( cmd, PingCmd ); strcat(cmd," "); strcat(cmd,N->Name);
		if ((pstream=popen( cmd, "r" ))==NULL) panic("Couldn't run ping program");
		else while( fgets( buffer, sizeof(buffer), pstream) !=NULL) {
		/* 64 bytes from 140.223.1.1: icmp_seq=0. time=10. ms */
		/* 64 bytes from 129.140.12.1: seq=0 ttl=249 time=122 ms.  */

			/* Here parse ping output */
			if ((p=strtok(buffer, " \t\n"))==NULL) continue;/*64*/
			if ((p=strtok(NULL, " \t\n"))==NULL) continue;/*bytes*/
			if ((p=strtok(NULL, " \t\n"))==NULL) continue;/*from*/
			if ((p=strtok(NULL, " \t\n"))==NULL) continue;/*addr*/
			if ((p=strtok(NULL, " \t\n"))==NULL) continue;/*seq*/
			if ((p=strtok(NULL, " \t\n"))==NULL) continue;/*ttl*/
			if ((p=strtok(NULL, " \t\n"))==NULL) continue;/*time*/
			if ( strncmp(p,"time=",5) != 0 ) continue;
			else {
			        /*print response time in valid lines to stream*/
				fputs( &p[5], stream);
				fputs( " ", stream);
			}
		}
		pclose( pstream );
		fputs( "\n", stream);
	}
	fclose( stream );	
}
	
main( argc, argv )
int argc;
char *argv[];
{

	ProgName=argv[0];
 /*************************************************************** 
  *	1)	Set up paths where files can be found		* 
  ***************************************************************/
	SetEnv();
 /*************************************************************** 
  *	2)	Read configuration file to get NodeType(T1|T3)  *
  *			SrcAddress, and NodeNamePatternToPing	*
  *					( enss's, rcps or psps )* 
  ***************************************************************/
	ReadConfigFile( ConfigFile );
 /*************************************************************** 
  *	3)	Read .rhosts file looking for Pattern Nodes to  *
  *					ping.			* 
  ***************************************************************/
	ReadNodeList( RhostsFile, Pattern );
 /*************************************************************** 
  *	4)	For each Pattern matching node, ping and store  *
  *					results.		* 
  ***************************************************************/
	DoPings( OutputFile );
}
