/********************************************************************
 *   day.c - code to calculate any days datestr given a offset from *
 * today .							    *
 ********************************************************************/

#include <stdio.h>
#include <time.h>
#include <string.h>

int STDIN=0;
char *ProgramName;

Usage()
{
	fprintf(stderr,"%s -<# days> --\n-5 returns date 5 days ago\n-- reads filenames from stdin and filters out the ones as old or older than n days\n",ProgramName); 
	exit(1);
}

char *cvt( timenow )
long *timenow;
{
static char buffer[20];
struct tm *timestruct;
char *timestr;

    timestruct = localtime( timenow );
    sprintf(buffer,"%.2d%.2d%.2d\n",
	timestruct->tm_year,
        timestruct->tm_mon+1,
        timestruct->tm_mday);
   return(buffer);
}

PrintEarlyThan( datenow )
long datenow;
{
char buffer[1000];
int i;
long thisdate;

	while( gets(buffer) != NULL ) {
		for(i=strlen(buffer)-1; i>=0 && buffer[i]!='.' && buffer[i]!='/'; i--);
		if (( i==0 )||(buffer[i]=='/')) continue;
		thisdate=atol(&buffer[i+1]);
	/*	printf("buffer = %s datelong=%ld thisdate=%ld\n",buffer,datelong,thisdate);/* */
		if ( thisdate < 710000 ) continue; /* impossible date*/
		if ( thisdate <= datenow ) printf("%s\n",buffer);
	}
}

#ifdef STANDALONE
main( argc, argv )
int argc;
char *argv[];
{
long timenow;
int i;
char *datestr;
static int DAYS=-9997;

	ProgramName=argv[0];


	for( i=1; i<argc; i++ )
		if ( argv[i][0] == '-' )
			switch( argv[i][1] ) {
				case '-':	STDIN=1; break;
				default: 
					if ( isdigit(argv[i][1]) )
						DAYS=atoi(&argv[i][1]);	
					else Usage(); break;
			}
	if ( DAYS == -9997 ) Usage();
	time( &timenow );			/* Get the time NOW */
	timenow=timenow-(DAYS*24*60*60);	/* Subtract n DAYS */
	datestr = cvt( &timenow );	/* convert to right format */
	if ( STDIN ) {
		timenow = atol(datestr);
		PrintEarlyThan( timenow );
	}
	else printf(datestr);		
}
#else
char *datestr( DAYS )
int DAYS;
{
static char datestring[10];
long timenow=time(&timenow);			/* Get time now */

	timenow=timenow-(DAYS*24*60*60);        /* Subtract n DAYS */
	strcpy(datestring,cvt( &timenow )); /* convert to right format */
	datestring[strlen(datestring)-1]='\0';	/* kill \n */
	return( datestring );
}
#endif
