/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 * PROBLEM FILE management routines
 */

/*#define STANDALONE 1	/*  */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <pwd.h>
#include <sys/param.h>

#include "pathnames.h"
#include "CommonDefs.h"
#include "problem.h"

static int NumProblems = 0;
struct ProblemType ProblemArray[MAXPROBLEMS];

static char *DefaultPingkyDir = DEFAULT_PINGKY_DIR;
static char *PingkyDir;

static char Problem_File[MAXPATHLEN]; 

static char buffer[BUFSIZ];		/* static buffer for misc uses */
char *progname;

static time_t ProblemFileLastUpdated;

static int ProblemFileChanged = 0;
static int virgin=1;

static void Refresh()
{

        ProblemFileChanged = 0;
        if (virgin) {
                /* set-up config files we will access */
                if ((PingkyDir = getenv("PINGKYDIR")) == NULL)
                        PingkyDir = DefaultPingkyDir;
                sprintf(Problem_File, "%s/%s", PingkyDir, PROBLEM_FILE);
                virgin = 0;
        }

        /* reread problem file if it has changed */
        if (FileChanged(Problem_File, &ProblemFileLastUpdated)) {
                NumProblems = ReadProblemFile(ProblemArray, Problem_File);
                FileChanged(Problem_File, &ProblemFileLastUpdated);
        }
}

int GetNumProblems(   )
{
	Refresh();
	return( NumProblems );
}

unsigned long GetTableTime(   )
{
time_t TimeNow=time(0);

	Refresh();
	return( TimeNow-ProblemFileLastUpdated );
}


unsigned long GetTimeStamp( ProblemNum )
int ProblemNum;
{
	Refresh();
	if ( ProblemNum <=0 || ProblemNum > NumProblems ) return(0);
	else return( ProblemArray[ ProblemNum-1 ].TimeStamp );
}
char *GetNodeName( ProblemNum )
int ProblemNum;
{
	Refresh();
	if ( ProblemNum <=0 || ProblemNum > NumProblems ) return(NULL);
	else return( ProblemArray[ ProblemNum-1 ].Name );
}
char *GetUniqueID( ProblemNum )
int ProblemNum;
{
	Refresh();
	if ( ProblemNum <=0 || ProblemNum > NumProblems ) return(NULL);
	else return( ProblemArray[ ProblemNum-1 ].UniqueID);
}
char *GetTestName( ProblemNum )
int ProblemNum;
{
	Refresh();
	if ( ProblemNum <=0 || ProblemNum > NumProblems ) return(NULL);
	else return( ProblemArray[ ProblemNum-1 ].TestName);
}
char *GetStatusLine( ProblemNum )
int ProblemNum;
{
	Refresh();
	if ( ProblemNum <=0 || ProblemNum > NumProblems ) return(NULL);
	else return( ProblemArray[ ProblemNum-1 ].StatusLine);
}


#ifdef STANDALONE

main(argc, argv)
int argc;
char *argv[];
{
	Refresh();
	printf("%d problems\n",GetNumProblems());
}
#endif
