/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */
#include <stdio.h>
#include <string.h>
#include "CommonDefs.h"
#include "LinkWidth.h"

struct LinkWidth LinkWidthArray[ 1000 ];
int LinkWidthCount;

char CurrentLinkWidthFile[MAXPATHLEN];

void AddLinkWidthEntry( Node1,
			Node2,
			LinkWidth,
			LocalTimeLastCount,
			LocalLastCount,
			LocalTimeCurrentCount,
			LocalCurrentCount,
			RemoteTimeLastCount,
			RemoteLastCount,
			RemoteTimeCurrentCount,
			RemoteCurrentCount,
			LocalPS,
			RemotePS )
char *Node1,*Node2;
int LinkWidth;
long LocalTimeLastCount,LocalLastCount,LocalTimeCurrentCount, LocalCurrentCount;
long RemoteTimeLastCount,RemoteLastCount,RemoteTimeCurrentCount,RemoteCurrentCount,
LocalPS, RemotePS;
{
int i=LinkWidthCount;

	strcpy(LinkWidthArray[i].Node1,Node1);
	strcpy(LinkWidthArray[i].Node2,Node2);
	LinkWidthArray[i].LinkWidth=LinkWidth;
	LinkWidthArray[i].LocalTimeLastCount=LocalTimeLastCount;
	LinkWidthArray[i].LocalLastCount=LocalLastCount;
	LinkWidthArray[i].LocalTimeCurrentCount=LocalTimeCurrentCount;
	LinkWidthArray[i].LocalCurrentCount=LocalCurrentCount;
	LinkWidthArray[i].RemoteTimeLastCount=RemoteTimeLastCount;
	LinkWidthArray[i].RemoteLastCount=RemoteLastCount;
	LinkWidthArray[i].RemoteTimeCurrentCount=RemoteTimeCurrentCount;
	LinkWidthArray[i].RemoteCurrentCount=RemoteCurrentCount;
	LinkWidthArray[i].LocalPS=LocalPS;
	LinkWidthArray[i].RemotePS=RemotePS;
	LinkWidthCount++;
}

struct LinkWidth *FindLinkWidthEntry( Node1, Node2 )
char *Node1, *Node2;
{
int i;

	for (i=0; i<LinkWidthCount; i++ )
		if ( (( strcmp( Node1, LinkWidthArray[i].Node1 ) == 0 ) &&
		      ( strcmp( Node2, LinkWidthArray[i].Node2 ) == 0 )) ||
		     (( strcmp( Node2, LinkWidthArray[i].Node1 ) == 0 ) &&
		      ( strcmp( Node1, LinkWidthArray[i].Node2 ) == 0 )) )
			return( &LinkWidthArray[i] ); 
	return(NULL);
}

void WriteLinkWidthFile( filename )
{
FILE *stream;
int i;
	if ((stream = fopen( filename,"w" )) == NULL) {
		fprintf(stderr,"Can't write %s LinkWidthFile\n",filename);
		return;
	}
	fprintf(stream,"#\n");
	fprintf(stream,"#	Internet Rover Link Width Format\n");
	fprintf(stream,"# %s\n",filename);
	fprintf(stream,"#\n");
	fprintf( stream,"#Node1 Node2 LW LLstTm LLstCnt LCurTm LCurTmCnt RLstTm RLstCnt RCurTm RCurTmCnt LocalPS RemotePS\n");
	fprintf(stream,"#\n");
	for( i=0; i<LinkWidthCount; i++ )
		fprintf( stream,"%s %s %d %ld %ld %ld %ld %ld %ld %ld %ld %ld %ld\n",
			LinkWidthArray[i].Node1,
			LinkWidthArray[i].Node2,
			LinkWidthArray[i].LinkWidth,
			LinkWidthArray[i].LocalTimeLastCount,
			LinkWidthArray[i].LocalLastCount,
			LinkWidthArray[i].LocalTimeCurrentCount,
			LinkWidthArray[i].LocalCurrentCount,
			LinkWidthArray[i].RemoteTimeLastCount,
			LinkWidthArray[i].RemoteLastCount,
			LinkWidthArray[i].RemoteTimeCurrentCount,
			LinkWidthArray[i].RemoteCurrentCount,
			LinkWidthArray[i].LocalPS,
			LinkWidthArray[i].RemotePS
			
		 );
	fclose( stream );
}

/*****************************************************************************
 *  ReadLinkWidthFile() - Read the link width file and store in static array *
 *			This routine sets the global linkwidth structure and *
 *			LinkWidthCount.					     *
 *****************************************************************************/
void ReadLinkWidthFile(filename)
char *filename;
{
	FILE *stream;
	char buffer[BUFSIZ], *n1, *n2, *lw;
	char *ltlc, *llc, *ltcc, *lcc, *lps;	/* Local Counters 	*/
	char *rtlc, *rlc, *rtcc, *rcc, *rps;	/* Remote Counters 	*/

	if (filename == NULL) 
		filename = CurrentLinkWidthFile;
	else 
		strcpy(CurrentLinkWidthFile, filename);

	/*fprintf(stderr, "Reading linkwidth file %s\n",filename);*/
	LinkWidthCount = 0;
	if ((stream = fopen( filename,"r" )) == NULL) {
		fprintf(stderr,"Can't read %s LinkWidthFile\n",filename);
		return;
	}
	while(fgets(buffer, sizeof(buffer), stream) != NULL) {
		if ((n1 = strtok(buffer, DELIMITERS)) == NULL) 
			continue;
		if ( *n1 == '#' ) continue;	/* Ignore comments */
		if ((n2 = strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
		if ((lw = strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
		strncpy(LinkWidthArray[ LinkWidthCount ].Node1, n1, MAXIPADDRESS );
		strncpy(LinkWidthArray[ LinkWidthCount ].Node2, n2, MAXIPADDRESS );
		LinkWidthArray[ LinkWidthCount ].LinkWidth = atoi(lw);
		/** Local Last Time **/
		if ((ltlc= strtok((char *) NULL, DELIMITERS)) == NULL) {
			LinkWidthCount++;	/* Complete link width line */
			continue;
		}
		LinkWidthArray[ LinkWidthCount ].LocalTimeLastCount = atol( ltlc );

		/* Local Last Count */
		if ((llc = strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
		LinkWidthArray[ LinkWidthCount ].LocalLastCount=atol(llc);

		/* Local Time Current Count */
		if ((ltcc= strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
		LinkWidthArray[ LinkWidthCount ].LocalTimeCurrentCount=atol(ltcc);

		/* Local Current Count */
		if ((lcc = strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
		LinkWidthArray[ LinkWidthCount ].LocalCurrentCount=atol(lcc);

		/**** Remote Time Last Count ****/
		if ((rtlc= strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
		LinkWidthArray[ LinkWidthCount ].RemoteTimeLastCount=atol(rtlc);
		
		/* Remote Last Count */
		if ((rlc = strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
		LinkWidthArray[ LinkWidthCount ].RemoteLastCount=atol(rlc);

		/* Remote Time Current Count */
		if ((rtcc= strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
		LinkWidthArray[ LinkWidthCount ].RemoteTimeCurrentCount=atol(rtcc);

		/* Remote Current Count */
		if ((rcc = strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
		LinkWidthArray[ LinkWidthCount ].RemoteCurrentCount=atol(rcc);
		LinkWidthArray[ LinkWidthCount ].RemoteCurrentCount=atol(rcc);

		/* Local Per Second */
		if ((lps = strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
		LinkWidthArray[ LinkWidthCount ].LocalPS=atol(lps);
		/* Remote Per Second */
		if ((rps = strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
		LinkWidthArray[ LinkWidthCount ].LocalPS=atol(rps);
		LinkWidthCount++;
	}
	fclose(stream);
}
