/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 */
/**********************************************************************
 * File: HostfileIO.c        Problem file and hostfile reader / writer*
 *  Version 1.0       Author: WB Norton  Merit Computer Network       *
 *  Modification History:                                             *
 *  written 5/18/89   Bill Norton, Merit Computer Network             *
 *  08/09/89 - Allow Spaces in parm lists for Appletalk argv   @wbn1 *
 *             We do this by substituting paren enclosed spaces       *
 *             with 0x01 - our white separator                        *
 *  12/03/90 - Split apart files - This is NOW InetRover Hostfileio.c *
 *  12/11/90 - Use malloc for each record-now just static array of ptr*
 *	       Call ReadNodeFile each cycle, and if we take care of   *
 *	       re-reading hostfile if things have changed	      *
 *  04/19/92 - Make this into a separate directory and library	      *
 **********************************************************************/
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/param.h>
#include <malloc.h>

#include "CommonDefs.h"
#include "hostfile.h"
#include "ctools.h"
#include "pathnames.h"

#define _NODE(i, j, k)	( Node[i].Test[j].argv[k] )	/* for readability */
#define ENTRY(i, j, k)	( NodeList[i].Test[j].argv[k] )	/* for readability */

struct HostFileNodeType NodeList[MAXNODES];
int NumNodes, HostfileChanged;
static long NodeListLastModified;

#ifdef STANDALONE

char hostfile[MAXPATHLEN];
char *DefaultPingkyDir = DEFAULT_PINGKY_DIR;

main()
{
	char *pingkydir, *getenv();
	struct HostFileNodeType *Nodes;

	if ((pingkydir = getenv("PINGKYDIR")) == NULL) 
		pingkydir = DefaultPingkyDir;
	sprintf(hostfile, "%s/%s", pingkydir, HOST_FILE);
	for (;;)
		Nodes = ReadNodeFile(hostfile);
	printf("There are %d net work nodes in file %s\n", NumNodes, hostfile);
	PrintNodes(Nodes);
}

#endif

/*****************************************************************************
 * ReadNodeFile:  Read the list of nodes we are responsible for.       @bev  *
 *****************************************************************************/
struct HostFileNodeType *ReadNodeFile(file)  /* Read and Store hostfile NodeArray */
char *file;
{
	FILE *fp;
	char buffer[MAXLINE], LastBuffer[MAXLINE];
	int Error = FALSE, virgin = TRUE;
	int i, j, k, line;

	HostfileChanged = 0;
	if (!(FileChanged(file, &NodeListLastModified))) 
		return(NodeList);

	HostfileChanged = 1;
	if (virgin) {
		for(i = 0; i < MAXNODES; i++)
			NodeList[i].NodeName = NULL;
		virgin = FALSE;
	}
	else {
		for(i = 0; i < MAXNODES && NodeList[i].NodeName != NULL; i++) {
			free(NodeList[i].NodeName);
			NodeList[i].NodeName = NULL;
		}
	}

	/* Open File and process a record at a time.  Malloc, and assign ptrs */
	if ((fp = fopen(file,"r")) == NULL)
		syserr("fopen hostfile: ");

	for (i = 0, line = 0; fgets(buffer, sizeof(buffer), fp) != NULL && i < MAXNODES; line++ ) {
		if (Error == TRUE) {
			printf("%s Error in line %d of hostfile - IGNORED the following line\n%s",
			    NodeList[i].NodeName, line, LastBuffer);
			free(NodeList[i].NodeName);
		}
		(void) strcpy(LastBuffer, buffer);
		Error = TRUE;
		if (buffer[0] == '#') { 
			Error = FALSE; 
			continue; 
		}

		if ((NodeList[i].NodeName = malloc((unsigned) (strlen(buffer) + 2))) == NULL)
			syserr("malloc failed in ReadNode");
		(void) strcpy( NodeList[i].NodeName, buffer );
		if ((NodeList[i].NodeName = strtok(NodeList[i].NodeName," \t\n")) == NULL) {
			Error = FALSE;  
			continue; 
		}

		if ((NodeList[i].UniqueID = strtok((char *) NULL," \t\n")) == NULL)
			continue;
		if ((NodeList[i].Helpfilename = strtok((char *) NULL," \t\n")) == NULL)
			continue;

		/* pull off tests to be performed on this node */
		Error = FALSE;
		for (j = 0 ; ((ENTRY(i, j, 0) = strtok((char *) NULL," \t\n")) != NULL); j++) {
			if (j >= MAXTESTS) {
				sprintf(buffer, "ReadNodeFile: Too many Tests (MAX=%d) on line %d of config file\n",MAXTESTS, line);
				Log(buffer, (char *) NULL);
				panic(buffer);
			}
		}
		/******************************/
		/* SPLIT TESTS INTO ARGV LIST */
		/******************************/
		for(j = j - 1; j >= 0; j-- )  {
			ENTRY(i, j, 0) = strtok(ENTRY(i, j, 0), "(,)");
			for(k = 1; k < MAXARGS; k++) {
				if ((ENTRY(i, j, k) = strtok((char *) NULL,"(,)")) == NULL)
					break;
			}
			if (k >= MAXARGS) {
				sprintf(buffer,"ReadNodeFile: Too many arguments (MAX=%d) on line %d of config file\n", MAXARGS, line);
				Log(buffer, (char *) NULL);
				panic(buffer);
			}
		}
		i++;
	}
	(void) fclose(fp);
	if (i == MAXNODES) {
		sprintf(buffer,"ERROR!!!! MAXNODES (%d) reached!!!\n",i);
		Log(buffer, (char *) NULL);
		fprintf(stderr, buffer);
	}
	NumNodes = i;

#ifdef DEBUG
	PrintNodes(NodeList);
#endif

	return(NodeList);
}

void PrintNodes(Node)
struct HostFileNodeType *Node;
{
	register int i, j, k;

	for (i = 0; Node[i].NodeName != NULL; i++) {
		printf("%d %s Node [%s] uses Help: %s & Protos ",i,
		    Node[i].NodeName, Node[i].UniqueID, Node[i].Helpfilename);

		for(j = 0; ((_NODE(i, j, 0) != NULL ) && (j < MAXTESTS)); j++) {
			printf(" %s(", _NODE(i, j, 0));
			for(k = 1; ((_NODE(i, j, k) != NULL) && (k < MAXARGS)) ; k++)
				printf("%d=%s,", k, _NODE(i, j, k));
			if (k != 1) 
				printf("%c", 8);
			printf(")");
		}
		printf("\n");
	}
}
