/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

/************************************************************************
 *          xmapdialogs.c - Dialogs for xmap graphical display		*
 *                                                                      *
 *                                                                      *
 ************************************************************************/
#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <dirent.h>
#include <sys/stat.h>
#include <string.h>
#include <sys/file.h>
#include "motif.h"
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include "xmap.h"
/*#include "version.c"*/

static int CollectorDiedDialogActive = 0;

/****************************************************************************
 * CollectorDied() - Put up a dialog to tell the user the map is not        *
 *                  accurate...                                             *
 *  Fix this so that only 1 dialog will ever be up at a time                *
 *      Use a boolean that gets clear on return from the dialog             *
 ****************************************************************************/
void CollectorDied()
{
	Cardinal n;
	Widget dialog, label;
	XmString xmstr;
	Arg myArgs[5];
	extern Widget drawarea;
	extern void unmanagedialog();

	if (CollectorDiedDialogActive == 1) 
		return;
	n = 0;
	XtSetArg(myArgs[n], XmNautoUnmanage, FALSE); 
	n++;
	dialog = XmCreateMessageDialog(drawarea, "NoCollector", myArgs, n);
	XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON));
	label = XmMessageBoxGetChild(dialog, XmDIALOG_MESSAGE_LABEL);
	n = 0;
	XtSetArg(myArgs[n], XmNalignment, XmALIGNMENT_BEGINNING); 
	n++;
	XtSetValues(label, myArgs, n);
	XtAddCallback(dialog, XmNokCallback, unmanagedialog, (caddr_t) NULL);
	xmstr = XmStringCreateLtoR("Collector Not Running", 
						XmSTRING_DEFAULT_CHARSET);
	n = 0;
	XtSetArg(myArgs[n], XmNmessageString, xmstr); 
	n++;
	XtSetValues(dialog,myArgs, n);

	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
	XtManageChild(dialog);
	CollectorDiedDialogActive = 1;
}

/****************************************************************************
 *  unmanagedialog() - unmanage the COllectorDied Dialog                    *
 ****************************************************************************/
/*ARGSUSED*/
void unmanagedialog(w , client_data, call_data )
Widget w;
caddr_t client_data;
XtCallbackList *call_data;
{
	XtUnmanageChild(w);
	CollectorDiedDialogActive = 0;
}

/*ARGSUSED*/
void ChangeNameDialogCallback( dialog, client_data, cbs )
Widget dialog;
caddr_t client_data;
XmAnyCallbackStruct *cbs;
{
	if (cbs->reason == XmCR_OK)
		printf("Here I would change the name of the map object\n");
	XtPopdown(XtParent(dialog));
}

/*ARGSUSED*/
void ChangeNameDialog(w , AboutFileName, call_data )
Widget w;
char *AboutFileName;
XtCallbackList *call_data;
{
	static Widget dialog;
	XmString t;
	extern void ChangeNameDialogCallback();
	Arg args[5];

	printf("Change Name ()\n");
	if (!dialog) {
		XmString ok;

		ok = XmStringCreateLtoR("OK", XmSTRING_DEFAULT_CHARSET);
		XtSetArg(args[0], XmNautoUnmanage, False);
		XtSetArg(args[1], XmNcancelLabelString, ok);
		dialog = XmCreateInformationDialog(w, "notice", args, 2);
		XtAddCallback(dialog, XmNcancelCallback, 
				ChangeNameDialogCallback, (caddr_t) NULL);
		XtUnmanageChild(XmMessageBoxGetChild(dialog,
					XmDIALOG_OK_BUTTON));
		XtUnmanageChild(XmMessageBoxGetChild(dialog,
					XmDIALOG_HELP_BUTTON));	
	}
	t = XmStringCreateLtoR("You must reply to this dialog\n",
					XmSTRING_DEFAULT_CHARSET );
	XtSetArg(args[0], XmNmessageString, t);
	XtSetValues(dialog, args, 1);
	XmStringFree(t);
	XtManageChild(dialog);
	XtPopup(XtParent(dialog), XtGrabNone);
}

/*************************************************************************
 *  AboutCallback() - This routine gets called when the user selects the *
 *		About() entry.  We are passed the filename, which we will*
 *		read and display in a dialog to the user.		 *
 *************************************************************************/
/*ARGSUSED*/
void AboutCallback(w, AboutFileName, call_data)
Widget w;
char *AboutFileName;
XtCallbackList *call_data;
{
	Cardinal n;
	Widget dialog, label;
	XmString xmstr;
	Arg myArgs[5];
	struct stat stbuf;
	int fd, rc, chars_read = 0;
	char *str, *s, docdata[BUFSIZ];
	extern void exit();
	extern char Version[];

	n = 0;
	XtSetArg(myArgs[n], XmNautoUnmanage, FALSE); 
	n++;
	dialog = XmCreateMessageDialog(w, "AboutStates", myArgs, n);
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));

	label = XmMessageBoxGetChild(dialog, XmDIALOG_MESSAGE_LABEL);
	n = 0;
	XtSetArg(myArgs[n],XmNalignment, XmALIGNMENT_BEGINNING); 
	n++;
	XtSetValues(label, myArgs, n);
	XtAddCallback(dialog, XmNokCallback, unmanagedialog, (caddr_t) NULL);

	if (AboutFileName == NULL) {
		str="\nDocumentation is any file in the \n$PINGKYDIR with a .doc extension.\nThere are several .doc files \navailable in this release of rover";
		strcpy( docdata, Version );
		strcat( docdata, "\n\n");
		strcat( docdata, str );
		str=docdata;
	}
	else {
		/* Here read and display text */
        	if (stat(AboutFileName, &stbuf ) < 0) {
                	fprintf(stderr, "File %s Not found\n", AboutFileName);
                	return;
        	}
        	str = XtMalloc(stbuf.st_size + 1);
        	if ((fd = open(AboutFileName, O_RDONLY)) < 0) {
                	fprintf(stderr, "File %s Not found\n", AboutFileName);
                	return;
        	}
		s = str;
		while (chars_read < stbuf.st_size) {
        		if ((rc = read(fd, s, stbuf.st_size)) < 0) {
				perror("read");
                		exit(1);
        		}
			chars_read += rc;
			s += rc;
		}
        	close(fd);
	}
	xmstr = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	n = 0;
	XtSetArg(myArgs[n],XmNmessageString, xmstr); 
	n++;
	XtSetValues(dialog,myArgs, n);
	XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON));
	XtManageChild(dialog);
}


/************************************************************************
 *  CreateAboutWidgets() - for each .doc file in $PINGKYDIR, create	*
 *			an about file entry in the main window		*
 ************************************************************************/
void CreateAboutWidgets(pingkydir, pulldown)
char *pingkydir;
Widget pulldown;
{
	DIR *dirp;
	struct dirent *entry;
	static Widget W[40];
	static int count = 0, i;
	static char *about[40][MAXPATHLEN];
	char *p, itemname[MAXPATHLEN - 4];

	W[count] = XmCreatePushButton(pulldown, "Documentation", NULL, 0);
	XtManageChild(W[count]);
	XtAddCallback(W[count], XmNactivateCallback, AboutCallback, 
							(caddr_t) NULL);
	count++;
	if ((dirp = opendir(pingkydir)) == NULL) {
		fprintf(stderr, "No .doc files available in %s\n", pingkydir);
		return;
	}
	while ((entry = readdir(dirp)) != NULL) {
		if ((p = strrchr(entry->d_name, '.' )) == NULL) 
			continue;
		if (strcmp(p, ".doc") != 0)
			continue;
		sprintf(about[count], "%s/%s", pingkydir, entry->d_name);
		/*
		 *  Clip off the ".doc" extension and copy the rest of 
		 *  the name to 'itemname'.
		 */
		*p = '\0';
		strcpy(itemname, entry->d_name);
		W[count] = XmCreatePushButton(pulldown, itemname, NULL, 0);
		XtManageChild(W[count]);
		XtAddCallback(W[count], XmNactivateCallback, AboutCallback, 
						(caddr_t) about[count]);
		count++;
	}
	closedir(dirp);
}
