/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <time.h>

void printresusage()
{
	extern time_t time();
	struct rusage rusage;
	time_t TimeNow = time(&TimeNow);
	getrusage(RUSAGE_SELF, &rusage);

printf("************************ Taking Measurement ****************************\n");
printf(ctime(&TimeNow));
  printf("ru_utime=%ld      The total amount of time spent executing in user mode.\n\n",rusage.ru_utime);
  
  printf("ru_stime=%ld      The total amount of time spent in the system executing on\nbehalf of the process(es).\n\n",rusage.ru_stime );
  
  printf("ru_maxrss=%ld     The maximum resident set size utilized (in kilobytes).\n\n",rusage.ru_maxrss);
  
   printf("ru_ixrss=%ld      An integral value indicating the amount of memory used by\nthe  text  segment  that  was also shared among other  processes.\nThis  value  is  expressed in units of  kilobytes  *  seconds-of-\nexecution  and  is  calculated  by summing the number  of  shared\nmemory pages in use  each  time  the internal system clock ticks,\nand then averaging over one second intervals.\n\n",rusage.ru_ixrss);
  
  printf("ru_idrss=%ld      An integral value of the amount of unshared memory resid-\ning in the data segment of a process (expressed in units of kilo\nbytes * seconds-of-execution).\n\n",rusage.ru_idrss);
  
  printf("ru_minflt=%ld     The number of page faults serviced without any I/O ac-\ntivity: here I/O activity is avoided by reclaiming  a  page frame\nfrom the list of pages awaiting reallocation.\n\n",rusage.ru_minflt);
  
  printf("ru_majflt=%ld     The number of page faults serviced that required I/O ac-\ntivity.\n\n",rusage.ru_majflt);
  
  printf("ru_nswap=%ld     The number of times a process was swapped out of main\nmemory.\n\n",rusage.ru_nswap);
  
  printf("ru_inblock=%ld    The number of times the file system had to perform in-\nput.\n\n",rusage.ru_inblock);
  
  printf("ru_oublock=%ld   The number of times the file system had to perform\noutput.\n\n",rusage.ru_oublock);
  
  printf("ru_msgsnd=%ld     The number of IPC messages sent.\n\n",rusage.ru_msgsnd);
  
  printf("ru_msgrcv=%ld     The number of IPC messages received.\n\n",rusage.ru_msgrcv);
  
  printf("ru_nsignals=%ld   The number of signals delivered.\n\n",rusage.ru_nsignals);
  
  printf("ru_nvcsw=%ld      The number of times a context switch resulted due to a\nprocess voluntarily giving up the processor before its time slice\nwas completed (usually to await availability of a resource).\n\n",rusage.ru_nvcsw);
  
  printf("ru_nivcsw=%ld     The number of times a context switch resulted due to a\nhigher priority process becoming runnable  or because the current\nprocess exceeded its time slice.\n\n",rusage.ru_nivcsw);
  
  printf("Note: The numbers the ru_inblock and ru_outblock fields account\nonly for real  I/O;  data  supplied  by  the caching mechanism is\ncharged only to the first process to read or write the data.\n\n");
printf("********************** End Of Mesaurement ***********************\n");
  
}

#ifdef STANDALONE
main()
{
	printresusage();

}
#endif
