/*--------------------connect/ns.c-----------------------------------*/

#define BIT_ZERO_ON_RIGHT 1
#define LOCAL_NAMESERVER_QUERY "whitman.merit.edu"

#include <stdio.h>
#include <sys/types.h>
#include <arpa/nameser.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <resolv.h>
#include <netdb.h>

char answer[PACKETSZ];
extern int h_errno;

#define RES_NSSET 1

int shh = 1;
#ifdef STANDALONE
main(argc, argv)
int argc;
char *argv[];
{

        if (argc < 2 || argc > 3) {
                fprintf(stderr, "Usage:  %s [-v] nameserver-address\n", argv[0])
;
                exit(5);
        }

        if (argc == 3)
                if (!(strcmp(argv[1], "-v"))) {
                        shh--;
                        argv[1] = argv[2];
                }
                else {
                        fprintf(stderr, "Usage:  %s [-v] nameserver-address\n",
argv[0]);
                        exit(5);
                }

	exit(TestNAMED( argv[1] ));
}
#endif

int TestNAMED( addr )
char *addr;
{
struct  in_addr *foo, *inet_addr();
struct servent *sp = getservbyname ("domain", "tcp");

        /* set the nameserver */
        bzero (&_res.nsaddr_list[0], sizeof (struct sockaddr_in));
        _res.nsaddr_list[0].sin_family = PF_INET;
        if ((foo = (struct in_addr *) inet_addr(addr)) == -1) {
                printf("[%s] is not a valid Internet address.\n", addr);
#ifdef STANDALONE
                exit(5);
#else
		return(0);
#endif
        }
        bcopy (&foo, &_res.nsaddr_list[0].sin_addr, 4);
        if (sp)
          _res.nsaddr_list[0].sin_port = sp->s_port;

        /* don't read /etc/resolv.conf in the resolver */
        _res.options |= RES_NSSET;

        /* do the query */
        if (res_query(LOCAL_NAMESERVER_QUERY, C_IN, T_ANY, answer, PACKETSZ) < 0) {
                if (!shh)
                        printf("Nameserver at %s is having problems\n", addr)
;
#ifdef STANDALONE
                exit(7);
#else
		return(0);
#endif
        }
        else {
                if (!shh)
                        printf("Nameserver at %s is alive and well\n", addr);
#ifdef STANDALONE
                exit(0);
#else
		return(1);
#endif
        }
}
