;  1430, Mon 20 Jan 92
;
;  NTASY,,   Hardware-driving routines to support nterm, i.e.
;            Asynch communications using full XON/XOFF protocol.
;            Will handle up to four com ports simultaneously.
;
;  Nevil Brownlee,  Computer Centre,  University of Auckland.
;
;  IBM PC (8250) version.
;     Set one of Turbo_C, Eco_C88, CI_C86 = 1 to specify C compiler.
;
;
;  Routines ..
;
;     cominit(p);        /* Initialise.
;                                 Later invocations just reset buffers */
;     int comreg(p,r,rw,v);  /* Handle 8250 register r:
;                                 rw == 0 to return current value of r,
;                                 rw != 0 to write v to r */
;     comfin(p);         /* Restore MSDOS com handling */
;
;     int comrecv(p);    /* Receive a char.  Returns char if no problems,
;                                 com_bad_char if error when char received,
;                                 -1 if no chars in receive buffer */
;     int comsend(p,c);  /* Send a char (int c).  Returns 0 if no problems,
;                                 -1 if no room in send  buffer */
;
;     int comrbuf(p,c);  /* Number of chars in receive buffer.
;                                 (int) c nonzero to clear usrXOFF */
;     int comrerr(p);    /* Number of chars received with errors.
;                                 Resets bad-char count */
;     int comsbuf(p,c);  /* Abs(result) = number of chars in send buffer.
;                                 Negative if waiting for XON.
;                                 (int) c nonzero to clear txXOFF */
;
;
four_ports  equ  1	; Four ports, even for nterm
;
	include	ndos.mac	; Assembler Macros
	environ	ntasy
	setX
	begdata	ntasy
;
;
dbtrace equ     0       ; Don't include debug tracing code.
;                            To use trace ..
;                               Set dbtrace = 1, uncomment trctail,trcbuf.
;                               Change ntcom to #define DBTRACE.
;                               Assemble ntasy, compile ntcom.
;
asy_port  struc      ; Data structure for AU coms
;
pbase   dw      ?    ;   0  Base address of area containing asy_port
pseg	dw	?    ;   2  Segment containing asy_port
;
rxbmsk  dw      ?    ;   4  rxbsz-1
rxbmax  dw      ?    ;   6  rxbsz-2
rxbemp  dw      ?    ;   8  rxbsz-32
;
txbmsk  dw      ?    ;   A  txbsz-1
txbmax  dw      ?    ;   C  txbsz-2
;
combase dw      ?    ;   E  8250 data port (reg 0)
comctrl dw      ?    ;  10  8250 interrupt enable register (reg 1)
comiir  dw      ?    ;  12  8250 interrupt identification register (reg 2)
commdm  dw      ?    ;  14  8250 modem control register (reg 4)
comline dw      ?    ;  16  8250 line status register (reg 5)
;
intctrl dw      ?    ;  18  8259 A0 = 0 (ICW1, OCW2-3)
intmask dw      ?    ;  1A  8259 A0 = 1 (ICW2-4, OCW1)
;
txhead  dw      ?    ;  1C  Head index into txbuf
txtail  dw      ?    ;  1E  Tail   "     "    "
txcount dw      ?    ;  20  Nbr of chars in txbuf
;
rxhead  dw      ?    ;  22  Head index into rxbuf
rxtail  dw      ?    ;  24  Tail   "     "    "
rxspace dw      ?    ;  26  Free chars in rxbuf
rxlost  dw      ?    ;  28  Chars lost by errors and buf oflo's
;
comadr  dw      ?    ;  2A  Com port address
portseg dw      ?    ;  2C  Seg base for port
;
txbufp  dw      ?    ;  2E  Pointer to buffer for transmitted chars
;
intlev  db      ?    ;  30  Interrupt level for this 8250
eoici   db      ?    ;  31  Specific end-of-interrupt command
mskci   db      ?    ;  32  Mask to set interrupt bit
enaci   db      ?    ;  33  Mask to clear interrupt bit
;
xonctl  db      ?    ;  34  0xFF for  XON/XOFF handling, 0 otherwise
;
txXOFF  db      ?    ;  35  XOFF from host; waiting for host XON
lecho   db      ?    ;  36  Non-zero if local echo required
;
rxXOFF  db      ?    ;  37  XOFF sent by handler
usrXOFF db      ?    ;  38  XOFF sent by user
rxbad   db      ?    ;  39  Char to use in place of bad ones
;
;         if      dbtrace   ; Not allowed to have if inside struc !!!
; trctail dw      ?    ; Pointer to last byte pair put into trace buffer
; trcbuf  db      8192 dup(?) ; Trace buffer
;         endif
;
rxbuf   dw      ?    ;  3A  Buffer for received chars
;
asy_port ends
;
;
rxbful  equ     16
;
; combase dw      ?       ; 8250 data port (reg 0)
; comctrl dw      ?       ; 8250 interrupt enable register (reg 1)
RXRESET equ     000H      ;    No interrupts
RXENABL equ     001H      ;    Received data available
TXENABL equ     002H      ;    Transmitter holding register empty
; comiir  dw      ?       ; 8250 interrupt identification register (reg 2)
INTPEND	equ	001H	  ;    =1 when no interrupt is pending
TXCHINT equ     002H      ;    Transmitter holding register empty
RXCHINT equ     004H      ;    Received data available
; commdm  dw      ?       ; 8250 modem control register (reg 4)
MDMIDL  equ     000H      ;    -RTS, -DTR, -OUT2 (com interrupts disabled)
MDMRST  equ     001H      ;    -RTS, +DTR, -OUT2
MDMRDY  equ     009H      ;    -RTS, +DTR, +OUT2 (com interrupts enabled)
; comline dw      ?       ; 8250 line status register (reg 5)
THREBIT equ     020H      ;    Tx Holding Register Empty
FRAMING	equ	008H
PARITY	equ	004H
OVERRUN	equ	002H
RXDRBIT equ     001H      ;    Rx Data Ready
RXEBITS	equ	OVERRUN
;RXEBITS equ	01EH	  ;    Break, framing, parity, overrun
;
XON     equ     011H      ; ^Q
DC2     equ     012H
XOFF    equ     013H      ; ^S
;
;
        enddata	ntasy
	begcode	ntasy
;
;
	public  int3
aoff3   dw      0    ; Interrupt address offset
aseg3   dw      0    ; Interrupt address segment
aport3  dw      0    ; asy_port address for interrupt 3
;
        public  int4
aoff4   dw      0
aseg4   dw      0
aport4  dw      0
;
   if four_ports
;
	public  int5
aoff5   dw      0
aseg5   dw      0
aport5  dw      0
;
	public  int2
aoff2	dw	0
aseg2   dw      0
aport2	dw	0
;
   endif
;
;
comint  proc    near
;
cirxbc: in      al,dx           ; Rx char error: clear 8251 read buf
        inc     word ptr[ds:rxlost]
        mov     al,ds:rxbad     ; Replace char with com_bad_char
        jmp     cirxok
;
cirful: inc     ds:rxspace      ; No room to save char in rxbuf
        inc     word ptr[ds:rxlost]
        jmp     citrbf
;
;
intr    label   near            ; Dummy receive interrupt from enablci
        if      dbtrace
        mov     ah,086H         ; Monitor line status
        call    trace
        endif
        push    ds              ; Save registers
        push    ax
        push    bx
        push    dx
        jmp     cirxi
;
int3:	push    ds              ; Save registers
        push    ax
	mov     ds,cs:aport3	; Point ds to asy_port 3
        jmp     cistrt
;
int4:	push    ds              ; Save registers
        push    ax
	mov     ds,cs:aport4	; Point ds to asy_port 4
        jmp     cistrt
;
   if four_ports
;
int2:	push    ds              ; Save registers
        push    ax
	mov     ds,cs:aport2    ; Point ds to asy_port 2
        jmp     cistrt
;
int5:	push    ds              ; Save registers
        push    ax
	mov     ds,cs:aport5	; Point ds to asy_port 5
;
   endif
;
cistrt: push    bx
        push    dx
;
        mov     dx,ds:comiir    ; Get interrupt id
        in      al,dx
citint:	test    al,RXCHINT      ; Received data available?
        jz      citxi
;
;       'Receive' interrupt
;
        if      dbtrace         ; Monitor line status
        mov     ah,081H
        call    trace
        endif
        mov     dx,ds:comline   ; Get line status
        in      al,dx
cirxi:  mov     dx,ds:combase
        test    al,RXEBITS      ; Receive error?
        jnz     cirxbc
        in      al,dx           ; Get received char
;
cirxok: dec     ds:rxspace      ; Room to save it?
        jz      cirful
;
        mov     bx,ds:rxhead    ; Yes: put char at head of rx buffer
        mov     byte ptr[bx].rxbuf,al
        inc     bx              ; Bump rxhead
        and     bx,ds:rxbmsk
        mov     ds:rxhead,bx
;
citrbf: cmp     ds:rxspace,rxbful  ; Rx buffer nearly full?
        jle     cirnfl
;
citXOF: cmp     al,XOFF         ; Check for XON/XOFF
        jg      ciret
        cmp     al,XON
        jl      ciret
        cmp     al,DC2
        je      ciret
;
        sub     al,XON          ; XON clears txXOFF
        and     al,ds:xonctl
        mov     ds:txXOFF,al
	cmp     ds:txcount,0    ; Chars in tx buffer (waiting for XON)?
        je      ciret
        jmp     citsnd
;
ciret:	mov     dx,ds:comiir    ; Get interrupt id
        in      al,dx
	test    al,INTPEND      ; Any more interrupts to service now?
	jz      citint
;
	mov     al,ds:eoici     ; Send end-of-interrupt to 8259
        mov     dx,ds:intctrl
        out     dx,al
	sti			; Enable interrupts
        pop     dx              ; Restore registers
        pop     bx
        pop     ax
	pop     ds
        iret
;
;
;       'Transmit' interrupt
;
citxi:  if      dbtrace         ; Monitor line status
        mov     ah,082H
        call    trace
        endif
        cmp     ds:txcount,0    ; Chars in tx buffer?
        je      ciret
        jmp     citsnd
;
;
cirnfl: cmp     ds:xonctl,0     ; Rx buffer nearly full
        je      ciret
        cmp     ds:rxXOFF,0     ; Don't send two XOFFs
        jne     citXOF
        mov     bx,ds:txtail    ; Put XOFF at tail of txbuf
        dec     bx
        and     bx,ds:txbmsk
        mov     ds:txtail,bx
        add     bx,ds:txbufp
        mov     byte ptr[bx],XOFF
        inc     ds:txcount
        mov     ds:rxXOFF,1     ; Set rxXOFF
;
citsnd: push    si              ; Tx buffer not empty
        call    trysend
        pop     si
        jmp     ciret
;
comint  endp
;
        public  trysend
;
trysend proc    near            ; => uses ax, bx, dx, si
        if      dbtrace         ; Monitor line status
        mov     ah,083H
        call    trace
        endif
        mov     dx,ds:comline
        in      al,dx           ; Get line status
        test    al,THREBIT      ; Tx Holding Register empty?
        jz      tsret
        mov     bx,ds:txtail
        mov     si,ds:txbufp
        mov     ah,byte ptr[si+bx]
        cmp     ds:xonctl,0     ; !xonctl => always send
        je      tssend
        cmp     ah,XOFF         ; Always send XOFF
        je      tssend
        cmp     ds:txXOFF,0     ; txOFF: don't send until host sends XON
        jne     tsret
        cmp     ah,XON          ; Anything but XON can go now
        jne     tssend
        cmp     ds:rxXOFF,0     ; XON: wait for !rxXOFF
        jne     tsret
        cmp     ds:usrXOFF,0    ;      && !usrXOFF
        jne     tsret
;
tssend: mov     al,ah           ; Send txtail char
        mov     dx,ds:combase
        out     dx,al
        inc     bx              ; ++txtail;  --txcount;
        and     bx,ds:txbmsk
        mov     ds:txtail,bx
        dec     ds:txcount
tsret:  ret
;
trysend endp
;
;
        if      dbtrace
trace   proc    near                    ; Trace nbr  (81, 82, ..) in ah
        mov     dx,03FDH
        in      al,dx                   ; Line status in al
        mov     bx,ds:trctail
        cmp     word ptr[bx].trcbuf,ax
        je      trcret
        inc     bx
        inc     bx
        and     bx,8191
        mov     ds:trctail,bx
        mov     word ptr[bx].trcbuf,ax
trcret: ret
trace   endp
        endif
;
;
maskci  proc    near            ; => Uses ax, dx
        mov     dx,ds:intmask
        cli                     ; Disable interrupts
        in      al,dx           ; Mask com interrupts
        or      al,ds:mskci
        out     dx,al
        sti                     ; Enable interrupts
        ret
maskci  endp
;
enablci proc    near            ; => Uses ax, dx
;
;       PC Interrupts from devices other than the com ports, e.g. the
;          keyboard, can result in the 8259 losing an 8250 rx interrupt.
;          This causes ntasy to stop receiving characters.
;       To cope with this we check for rx data ready before re-enabling
;          8250 interrupts.
;
        mov     dx,ds:comline   ; Get line status
        in      al,dx
        test    al,RXDRBIT      ; Rx Data Ready?
        jz      enago
	pushf                   ; Yes: fake an rx interrupt to get it
	push	cs		;    Push cs first, so that
	call    intr		;    this looks like a far call!
;
enago:  mov     dx,ds:intmask
        cli                     ; Disable interrupts
        in      al,dx           ; Enable com interrupts
        and     al,ds:enaci
        out     dx,al
        sti                     ; Enable interrupts
        ret
enablci endp
;
portds  proc    near            ; Point ds to asy_port
   if LDATA
	les	bx,dword ptr X[bp]
	mov	ds,word ptr es:[bx].portseg
   else
	mov     bx,X[bp]
        mov     ds,[bx].portseg
   endif
        ret
portds  endp
;
;
	function  comsend       ; (p,c)
;       ========  =======         =====
	mov     cx,-1
	push    ds
	call    portds          ; Point ds to asy_port
	call    maskci          ; Mask com interrupts
	if      dbtrace         ; Monitor line status
	mov     ah,084H
	call    trace
	endif
;
        mov     dx,ds:txcount   ; Compute nbr of chars in tx buffer
        inc     dx
        cmp     dx,ds:txbmax    ; Buffer full?
        jge     csecho
;
        mov     cx,0            ; No; put char at head of buffer
        mov     bx,ds:txhead
	mov     ax,X+DPSIZE[bp] ; Char passed as an int parameter
        mov     si,ds:txbufp
        mov     byte ptr[si+bx],al
        inc     bx
        and     bx,ds:txbmsk    ; ++txhead;  ++txcount;
        mov     ds:txhead,bx
        mov     ds:txcount,dx
;
        cmp     ds:xonctl,0     ; XON/XOFF handling required?
        je      csiord
;
        cmp     al,XOFF
        jne     csiXON
        mov     ds:usrXOFF,1    ; XOFF: set usrXOFF
        jmp     csiord
;
csiXON: cmp     al,XON
        jne     csiord
        mov     ds:usrXOFF,0    ; XON: reset usrXOFF
;
csiord: call    trysend
;
csecho: cmp     ds:lecho,0      ; Local echo required?
        je      csiena
;
        dec     ds:rxspace      ; Space in rx buffer?
        jnz     cssvch
        inc     word ptr[ds:rxlost]  ; No room
        inc     ds:rxspace
        jmp     csiena
;
cssvch: mov     ax,X+DPSIZE[bp] ; Char passed as an int parameter
        mov     bx,ds:rxhead    ; Put char at head of rx buffer
        mov     byte ptr[bx].rxbuf,al
        inc     bx              ; Bump rxhead
        and     bx,ds:rxbmsk
        mov     ds:rxhead,bx
;
csiena: call    enablci         ; Enable com interrupts
        pop     ds
        mov     ax,cx           ; Return int result
	endfn   comsend
;
;
	function  comrecv       ; (p)
;       ========  =======         ===
   if LDATA
	les	bx,dword ptr X[bp]
	mov	ax,word ptr es:[bx].rxtail
	cmp     word ptr es:[bx].rxhead,ax
   else
	mov     bx,X[bp]	; User call: ds points to dgroup
	mov	ax,word ptr[bx].rxtail
	cmp     word ptr[bx].rxhead,ax
   endif
        jne     crbeg
;
        mov     ax,-1           ; Return -1 if buffer empty
        jmp     crend
;
crbeg:  push    ds
        call    portds          ; Point ds to asy_port
        call    maskci          ; Mask com interrupts
        if      dbtrace         ; Monitor line status
        mov     ah,085H
        call    trace
        endif
;
        mov     bx,ds:rxtail    ; Char in rx buffer?
        cmp     bx,ds:rxhead
        je      criena
;
        mov     ch,0            ; Get char from tail of rx buffer
        mov     cl,byte ptr[bx].rxbuf
        inc     bx              ; Bump rxtail
        and     bx,ds:rxbmsk
        mov     ds:rxtail,bx
        inc     ds:rxspace
;
        cmp     ds:rxXOFF,0     ; Handler sent an XOFF?
        je      criena
;
        mov     bx,ds:rxbemp    ; Rx buffer nearly empty?
        cmp     bx,ds:rxspace
        jne     criena
;
        cmp     ds:xonctl,0     ; XON/XOFF handling required?
        je      criena
;
        mov     bx,ds:txhead    ; Put XON at head of tx buffer
        mov     si,ds:txbufp
        mov     byte ptr[si+bx],XON
        inc     bx
        and     bx,ds:txbmsk
        mov     ds:txhead,bx    ; ++txhead;  ++txcount;
        inc     ds:txcount
        mov     ds:rxXOFF,0     ; Reset rxXOFF
        call    trysend
;
criena: call    enablci         ; Enable com interrupts
;
        pop     ds
        mov     ax,cx           ; Return int result
crend:  endfn   comrecv
;
;
	function  comsbuf       ; (p,c)
;       ========  =======         =====
	push    ds
	call    portds          ; Point ds to asy_port
	call    maskci          ; Mask com interrupts
;
        mov     cx,ds:txcount   ; Nbr of chars in tx buffer
        cmp     ds:txXOFF,0     ; Waiting for an XON?
        je      csbchk
        neg     cx              ; Yes
;
	mov     dx,X+DPSIZE[bp] ; Parameter nonzero to clear txXOFF
        cmp     dx,0
        je      csbchk
        mov     ds:txXOFF,0     ; Clear txXOFF
;
csbchk: cmp     cx,0
        je      csbena          ; No chars waiting
        call    trysend         ; In case we missed a tx interrupt
;
csbena: call    enablci         ; Enable com interrupts
        pop     ds
        mov     ax,cx           ; Return int result
	endfn   comsbuf
;
;
	function  comrbuf       ; (p,c)
;       ========  =======         =====
        push    ds
        call    portds          ; Point ds to asy_port
        call    maskci          ; Mask com interrupts
;
        mov     cx,ds:rxhead    ; Compute nbr of chars in rx buffer
        mov     bx,ds:rxtail
        sub     cx,bx
        and     cx,ds:rxbmsk
;
	mov     dx,X+DPSIZE[bp] ; Parameter nonzero to clear usrXOFF
        cmp     dx,0
        je      crbena
        mov     ds:usrXOFF,0    ; Clear usrXOFF
;
crbena: call    enablci         ; Enable com interrupts
        pop     ds
        mov     ax,cx           ; Return int result
	endfn  comrbuf
;
;
	function  comrerr       ; (p)
;       ========  =======         ===
        push    ds
        call    portds          ; Point ds to asy_port
        call    maskci          ; Mask com interrupts
;
        mov     cx,0            ; Reset rxlost
        xchg    cx,ds:rxlost
;
        call    enablci         ; Enable com interrupts
;
        pop     ds
        mov     ax,cx           ; Return int result
	endfn   comrerr
;
;
	function  cominit       ; (p)
;       ========  =======         ===
	push	ds		; Save user's ds
   if LDATA
	mov	ds,X+2[bp]	; ds => asy_port segment
   endif
	mov     si,X[bp]        ; si => asy_port offset
	cmp     [si].portseg,0  ; Interrupts already initialised?
	je	ciinit		; No: initialise interrupt handler
	jmp     ciiset		; Yes: just initialise variables
;
ciinit:	mov     ax,offset int4  ; ax = offset of interrupt handler
        cmp     [si].intlev,4
        je      cinseg
	mov     ax,offset int3
   if four_ports
	cmp     [si].intlev,3
	je      cinseg
	mov     ax,offset int5
	cmp     [si].intlev,5
        je      cinseg
	mov     ax,offset int2
   endif
cinseg: mov     dx,cs           ; dx = segment of interrupt handler
;
        mov     bx,[si].comadr  ; Address for com interrupt
        push    ds              ; Point to bottom of memory
	mov     cx,0
	mov     ds,cx
        cli                     ; Disable interrupts
	xchg    [bx],ax         ; Set com interrupt offset
        xchg    [bx+2],dx       ;   and segment
        sti                     ; Enable interrupts
        pop     ds
;
        mov     bx,si           ; Compute seg address for port
        mov     cl,4
	shr     bx,cl
	mov	cx,ds
	add     bx,cx
        mov     [si].portseg,bx
;
        cmp     [si].intlev,4   ; Save MSDOS interrupt offset+segment
        je      cinp4           ;    and port (segment) address
   if four_ports
	cmp     [si].intlev,3
	je      cinp3
	cmp     [si].intlev,5
	je      cinp5
	mov     cs:aoff2,ax
	mov     cs:aseg2,dx
	mov     cs:aport2,bx
	jmp     ciiset
cinp5:  mov     cs:aoff5,ax
	mov     cs:aseg5,dx
	mov     cs:aport5,bx
	jmp     ciiset
   endif
cinp3:  mov     cs:aoff3,ax
	mov     cs:aseg3,dx
	mov     cs:aport3,bx
        jmp     ciiset
cinp4:  mov     cs:aoff4,ax
	mov     cs:aseg4,dx
	mov     cs:aport4,bx
;
ciiset: mov     ds,[si].portseg	; Initialise variables
	mov     ax,0		;    For re-init as well as init!!
        mov     ds:txhead,ax
        mov     ds:txtail,ax
        mov     ds:txcount,ax
        mov     ds:txXOFF,al
        mov     ds:rxhead,ax
        mov     ds:rxtail,ax
        mov     bx,ds:rxbmax
        mov     ds:rxspace,bx
        mov     ds:rxXOFF,al
        mov     ds:usrXOFF,al
        mov     ds:rxlost,ax
;
	mov     al,MDMRDY       ; -RTS, +DTR, +OUT2 (com board int enable)
        mov     dx,ds:commdm
        out     dx,al
        mov     al,RXENABL+TXENABL  ; 8250 interrupt enable
        mov     dx,ds:comctrl
        out     dx,al
        call    enablci         ; 8259 interrupt enable
;
	pop	ds		; Restore ds
	endfn   cominit
;
;
	function  comreg        ; (p,r,rw,v)
;       ========  ======          ==========
	push    ds
	call    portds          ; Point ds to asy_port
	call    maskci
	mov     dx,ds:combase
	add     dx,X+DPSIZE[bp]	; 8250 register nbr (first int parameter)
	mov     bx,X+DPSIZE+2[bp] ; read or write? (second int parameter)
	mov     ax,X+DPSIZE+4[bp] ; Value to set (third int parameter)
        cmp     bx,0
        je      comrrd
;
        out     dx,al           ; Set register to value
        jmp     comrxt
;
comrrd: in      al,dx           ; Return register value as int
        mov     cl,al
;
comrxt: call    enablci
        pop     ds
        mov     al,cl           ; Return result to caller
        mov     ah,0
	endfn   comreg
;
;
	function  comfin        ; (p)
;       ========  ======          ===
	push    ds
	call    portds          ; Point ds to asy_port
	call    maskci          ; Mask com interupts
	mov     al,RXRESET      ; Disable 8250 interrupts
	mov     dx,ds:comctrl
        out     dx,al
	mov     al,MDMRST       ; +DTR, -RTS, -OUT2 (no com board interrupts)
	mov     dx,ds:commdm
        out     dx,al
;
	cmp     ds:portseg,0	; Were interrupts initialised?
        je      ciirst
;
	cmp     ds:intlev,4	; Yes: Restore MSDOS handler
        je      cfnp4
   if four_ports
	cmp     ds:intlev,3
	je      cfnp3
	cmp     ds:intlev,5
	je      cfnp5
	mov     cx,es:aoff2	; cx = offset of interrupt handler
	mov     dx,es:aseg2	; dx = segment of interrupt handler
	jmp     cfnseg
cfnp5:  mov     cx,cs:aoff5
	mov     dx,cs:aseg5
        jmp     cfnseg
   endif
cfnp3:  mov     cx,cs:aoff3
	mov     dx,cs:aseg3
        jmp     cfnseg
cfnp4:  mov     cx,cs:aoff4
	mov     dx,cs:aseg4
;
cfnseg: mov     bx,ds:comadr	; Address for com interrupt
        push    ds              ; Save ds
        mov     ax,0            ; Point to bottom of memory
        mov     ds,ax
        cli                     ; Disable interrupts
        mov     [bx],cx         ; Restore MSDOS com interrupt offset
        mov     [bx+2],dx       ;   and segment
        sti                     ; Reenable interrupts
        pop     ds              ; Restore ds
	mov     ds:portseg,ax
;
ciirst: pop	ds
	endfn  comfin
;
;
	endcode	ntasy
        end
