/* 1140, Fri 15 Jul 94

   MET_VARS.H:  Data structures for AU Meter SNMP interface

   Copyright (C) 1992-1994 by Nevil Brownlee,
   Computer Centre,  The University of Auckland */

/* Definitions for SNMP (RFC 1067) agent variable finder.
 *
 *
/***********************************************************
	Copyright 1988, 1989 by Carnegie Mellon University
	Copyright 1989	TGV, Incorporated

		      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU and TGV not be used
in advertising or publicity pertaining to distribution of the software
without specific, written prior permission.

CMU AND TGV DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
EVENT SHALL CMU OR TGV BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
******************************************************************/

u_char far *var_system();
u_char far *var_ifEntry();
u_char far *var_atEntry();
u_char far *var_ip();
u_char far *var_ipAddrEntry();
u_char far *var_ipRouteEntry();
u_char far *var_icmp();
u_char far *var_tcp();
u_char far *var_udp();
u_char far *var_process();
u_char far *var_event();
u_char far *var_rinfo();  /* Internet Accounting .. */
u_char far *var_col_tbl();
u_char far *var_ft();
u_char far *var_flow_index();
u_char far *var_rt();
u_char far *getStatPtr();

extern long long_return;
extern u_char return_buf[];

#define INST	0xFFFFFFFF	/* used to fill out the instance field of the variables table */

/*
 * These are unit magic numbers for each variable.
 */

#define VERSION_DESCR	      0
#define VERSION_ID	      1
#define UPTIME		      3
#define IFNUMBER	      2

#define HIGHWATERMARK        11  /* 1 in SNMP */
#define FLOODMARK            12
#define INACT_TIMEOUT        13
#define LAST_COLLECT_TIME    16
#define CURRENT_RULE_SET     18
#define EMERGENCY_RULE_SET   19

#define MSSTATSRESET         31
#define MSSTATSTIME          32
#define MSNPACKETS           33
#define MSTBACKLOG           34
#define MSMXPKTRATE          35
#define MSMXBACKLOG          36
#define MSNFLOWS             37
#define MSFLOWSRCV           38
#define MSNMATCHES           39
#define MSHASHSRCHS          40
#define MSHASHCMPS           41
#define MSTHASHSZ            42
#define MSNHASHENTS          43
#define MSGCINTERVAL         44
#define MSMXFLOWS            45
#define MSAVIDLEPER1000      46
#define MSMINIDLEPER1000     47

#define PCNEARMEM	     61
#define PCFARMEM             62
#define PCBADPKTS	     63
#define PCNOBUFPKTS	     64
#define PCLOSTPKTS	     65

#define IFINDEX		 1
#define IFDESCR		 2
#define IFTYPE	         3
#define IFMTU		 4
#define IFSPEED		 5
#define IFPHYSADDRESS	 6
#define IFADMINSTATUS	 7
#define IFOPERSTATUS	 8
#define IFLASTCHANGE	 9
#define IFINOCTETS	10
#define IFINUCASTPKTS	11
#define IFINNUCASTPKTS	12
#define IFINDISCARDS	13
#define IFINERRORS	14
#define IFINUNKNOWNPROTOS 15
#define IFOUTOCTETS	16
#define IFOUTUCASTPKTS	17
#define IFOUTNUCASTPKTS 18
#define IFOUTDISCARDS	19
#define IFOUTERRORS	20
#define IFOUTQLEN	21

#define ATIFINDEX	0
#define ATPHYSADDRESS	1
#define ATNETADDRESS	2

#define IPFORWARDING	0
#define IPDEFAULTTTL	1
#define IPINRECEIVES	2
#define IPINHDRERRORS	3
#define IPINADDRERRORS	4
#define IPFORWDATAGRAMS 5
#define IPINUNKNOWNPROTOS 6
#define IPINDISCARDS	7
#define IPINDELIVERS	8
#define IPOUTREQUESTS	9
#define IPOUTDISCARDS	10
#define IPOUTNOROUTES	11
#define IPREASMTIMEOUT	12
#define IPREASMREQDS	13
#define IPREASMOKS	14
#define IPREASMFAILS	15
#define IPFRAGOKS	16
#define IPFRAGFAILS	17
#define IPFRAGCREATES	18

#define IPADADDR	1
#define IPADIFINDEX	2
#define IPADNETMASK	3
#define IPADBCASTADDR	4

#define IPROUTEDEST	0
#define IPROUTEIFINDEX	1
#define IPROUTEMETRIC1	2
#define IPROUTEMETRIC2	3
#define IPROUTEMETRIC3	4
#define IPROUTEMETRIC4	5
#define IPROUTENEXTHOP	6
#define IPROUTETYPE	7
#define IPROUTEPROTO	8
#define IPROUTEAGE	9

#define ICMPINMSGS	     0
#define ICMPINERRORS	     1
#define ICMPINDESTUNREACHS   2
#define ICMPINTIMEEXCDS      3
#define ICMPINPARMPROBS      4
#define ICMPINSRCQUENCHS     5
#define ICMPINREDIRECTS      6
#define ICMPINECHOS	     7
#define ICMPINECHOREPS	     8
#define ICMPINTIMESTAMPS     9
#define ICMPINTIMESTAMPREPS 10
#define ICMPINADDRMASKS     11
#define ICMPINADDRMASKREPS  12
#define ICMPOUTMSGS	    13
#define ICMPOUTERRORS	    14
#define ICMPOUTDESTUNREACHS 15
#define ICMPOUTTIMEEXCDS    16
#define ICMPOUTPARMPROBS    17
#define ICMPOUTSRCQUENCHS   18
#define ICMPOUTREDIRECTS    19
#define ICMPOUTECHOS	    20
#define ICMPOUTECHOREPS     21
#define ICMPOUTTIMESTAMPS   22
#define ICMPOUTTIMESTAMPREPS 23
#define ICMPOUTADDRMASKS    24
#define ICMPOUTADDRMASKREPS 25

#define TCPRTOALGORITHM      1
#define TCPRTOMIN	     2
#define TCPRTOMAX	     3
#define TCPMAXCONN	     4
#define TCPACTIVEOPENS	     5
#define TCPPASSIVEOPENS      6
#define TCPATTEMPTFAILS      7
#define TCPESTABRESETS	     8
#define TCPCURRESTAB	     9
#define TCPINSEGS	    10
#define TCPOUTSEGS	    11
#define TCPRETRANSSEGS	    12
#define TCPCONNSTATE	    13
#define TCPCONNLOCALADDRESS 14
#define TCPCONNLOCALPORT    15
#define TCPCONNREMADDRESS   16
#define TCPCONNREMPORT	    17

#define UDPINDATAGRAMS	    0
#define UDPNOPORTS	    1
#define UDPINERRORS	    2
#define UDPOUTDATAGRAMS     3

#define EVENTCLASS		    0
#define EVENTINSTANCE		    1
#define EVENTALARMTYPE		    2
#define EVENTTIME		    3
#define EVENTPROBCAUSE		    4
#define EVENTSPECIFICPROBLEM	    5
#define EVENTSEVERITY		    6
#define EVENTBACKUPSTATUS	    7
#define EVENTBACKUPINSTANCE	    8
#define EVENTTREND		    9
#define EVENTTHRESHOLD		    10
#define EVENTTHRESHOLDLEVEL	    11
#define EVENTTHRESHOLDOBSVALUE	    12
#define EVENTID			    13
#define EVENTCORRELATIONS	    14
#define EVENTOPERSTATE		    16
#define EVENTADMINSTATE		    17
#define EVENTMONATTRIBUTES	    18
#define EVENTREPAIRACTION	    19
#define EVENTDATA		    20
#define EVENTTEXT		    21
#define EVENTCREDIBILITY	    22
#define EVENTINDEX		    23
#define EVENTVALID		    24

#define RIINDEX		 1
#define RIRULESIZE	 2
#define RIACTIONSIZE	 3

#define CIINDEX 	11
#define CIPEERADDR	12
#define CILASTTIME	13
#define CIPREVTIME	14

#define SAMPLE_RATE     21

/* FT defines for flow table moved to flowhash.h */

#define FTCRFIRSTTIME	        0
#define FTCRFLOWINDEX	        1
#define FTACFIRSTTIME	        2
#define FTACFLOWINDEX	        3

#define FTCOLATTRIB	       11
#define FTCOLTIME	       12
#define FTCOLINDEX	       13
#define FTCOLBLOB	       14

#define RTRULESET  	 	1
#define RTRULEINDEX	 	2
#define RTSELECTOR	 	3
#define RTRULEMASK	 	4
#define RTMATCHVALUE	 	5
#define RTRULEACTION	 	6
#define RTJUMPINDEX	 	7

#define ATACTIONINDEX	      101
#define ATLOWINTERFACE        103
#define ATLOWADJACENTTYPE     104
#define ATLOWADJACENTADDRESS  105
#define ATLOWADJACENTMASK     106
#define ATLOWPEERTYPE	      107
#define ATLOWPEERTYPEMASK     108
#define ATLOWPEERADDRESS      109
#define ATLOWPEERMASK         110
#define ATLOWDETAILTYPE       111
#define ATLOWDETAILTYPEMASK   112
#define ATLOWDETAILADDRESS    113
#define ATLOWDETAILMASK       114
#define ATHIINTERFACE         117
#define ATHIADJACENTTYPE      118
#define ATHIADJACENTADDRESS   119
#define ATHIADJACENTMASK      120
#define ATHIPEERTYPE	      121
#define ATHIPEERTYPEMASK      122
#define ATHIPEERADDRESS       123
#define ATHIPEERMASK          124
#define ATHIDETAILTYPE        125
#define ATHIDETAILTYPEMASK    126
#define ATHIDETAILADDRESS     127
#define ATHIDETAILMASK        128
#define ATPDUSCALE            133
#define ATOCTETSCALE          134
#define ATACTIONSET	      135

struct variable {
    oid		    name[26];	    /* object identifier of variable */
    u_char	    namelen;	    /* length of above */
    char	    type;	    /* type of variable, INTEGER or (octet) STRING */
    u_char	    magic;	    /* passed to function as a hint */
    u_short	    acl;	    /* access control list for variable */
    u_char far	    *(*findVar)();  /* function that finds variable */
};
